/*
 * Decompiled with CFR 0.152.
 */
package javafx.stage;

import com.sun.javafx.event.DirectEvent;
import com.sun.javafx.event.EventRedirector;
import com.sun.javafx.event.EventUtil;
import com.sun.javafx.stage.FocusUngrabEvent;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.stage.PopupWindow;

class PopupWindow$PopupEventRedirector
extends EventRedirector {
    private static final KeyCombination ESCAPE_KEY_COMBINATION = KeyCombination.keyCombination("Esc");
    private final PopupWindow popupWindow;

    public PopupWindow$PopupEventRedirector(PopupWindow popupWindow) {
        super(popupWindow);
        this.popupWindow = popupWindow;
    }

    @Override
    protected void handleRedirectedEvent(Object object, Event event) {
        if (event instanceof KeyEvent) {
            this.handleKeyEvent((KeyEvent)event);
            return;
        }
        EventType<? extends Event> eventType = event.getEventType();
        if (eventType == MouseEvent.MOUSE_PRESSED || eventType == ScrollEvent.SCROLL) {
            this.handleAutoHidingEvents(object, event);
            return;
        }
        if (eventType == FocusUngrabEvent.FOCUS_UNGRAB) {
            this.handleFocusUngrabEvent();
            return;
        }
    }

    private void handleKeyEvent(KeyEvent keyEvent) {
        Node node;
        if (keyEvent.isConsumed()) {
            return;
        }
        EventTarget eventTarget = this.popupWindow.getScene();
        if (eventTarget != null && EventUtil.fireEvent(eventTarget = (node = eventTarget.getFocusOwner()) != null ? node : eventTarget, new DirectEvent(keyEvent.copyFor(this.popupWindow, eventTarget))) == null) {
            keyEvent.consume();
            return;
        }
        if (((Event)keyEvent).getEventType() == KeyEvent.KEY_PRESSED && ESCAPE_KEY_COMBINATION.match(keyEvent)) {
            this.handleEscapeKeyPressedEvent(keyEvent);
        }
    }

    private void handleEscapeKeyPressedEvent(Event event) {
        if (this.popupWindow.isHideOnEscape()) {
            this.popupWindow.doAutoHide();
            if (this.popupWindow.getConsumeAutoHidingEvents()) {
                event.consume();
            }
        }
    }

    private void handleAutoHidingEvents(Object object, Event event) {
        if (this.popupWindow.getOwnerWindow() != object) {
            return;
        }
        if (this.popupWindow.isAutoHide() && !this.isOwnerNodeEvent(event)) {
            Event.fireEvent(this.popupWindow, new FocusUngrabEvent());
            this.popupWindow.doAutoHide();
            if (this.popupWindow.getConsumeAutoHidingEvents()) {
                event.consume();
            }
        }
    }

    private void handleFocusUngrabEvent() {
        if (this.popupWindow.isAutoHide()) {
            this.popupWindow.doAutoHide();
        }
    }

    private boolean isOwnerNodeEvent(Event object) {
        Node node = this.popupWindow.getOwnerNode();
        if (node == null) {
            return false;
        }
        if (!((object = ((Event)object).getTarget()) instanceof Node)) {
            return false;
        }
        object = (Node)object;
        do {
            if (object != node) continue;
            return true;
        } while ((object = ((Node)object).getParent()) != null);
        return false;
    }
}

