/*
 * Decompiled with CFR 0.152.
 */
package javafx.stage;

import com.sun.javafx.FXPermissions;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.stage.StageHelper;
import com.sun.javafx.stage.StagePeerListener;
import com.sun.javafx.stage.StagePeerListener$StageAccessor;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.geometry.NodeOrientation;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCombination;
import javafx.stage.Modality;
import javafx.stage.Stage$1;
import javafx.stage.Stage$2;
import javafx.stage.Stage$3;
import javafx.stage.Stage$4;
import javafx.stage.Stage$5;
import javafx.stage.Stage$6;
import javafx.stage.Stage$7;
import javafx.stage.Stage$8;
import javafx.stage.Stage$9;
import javafx.stage.Stage$ResizableProperty;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class Stage
extends Window {
    private boolean inNestedEventLoop = false;
    private static final StagePeerListener$StageAccessor STAGE_ACCESSOR;
    private boolean primary = false;
    private boolean securityDialog = false;
    private boolean important = true;
    private StageStyle style;
    private Modality modality = Modality.NONE;
    private Window owner = null;
    private ReadOnlyBooleanWrapper fullScreen;
    private ObservableList<Image> icons = new Stage$4(this, new Stage$3(this));
    private StringProperty title;
    private ReadOnlyBooleanWrapper iconified;
    private ReadOnlyBooleanWrapper maximized;
    private ReadOnlyBooleanWrapper alwaysOnTop;
    private BooleanProperty resizable;
    private DoubleProperty minWidth;
    private DoubleProperty minHeight;
    private DoubleProperty maxWidth;
    private DoubleProperty maxHeight;
    private final ObjectProperty<KeyCombination> fullScreenExitCombination = new SimpleObjectProperty<Object>(this, "fullScreenExitCombination", null);
    private final ObjectProperty<String> fullScreenExitHint = new SimpleObjectProperty<Object>(this, "fullScreenExitHint", null);

    public Stage() {
        this(StageStyle.DECORATED);
    }

    public Stage(@NamedArg(value="style", defaultValue="DECORATED") StageStyle stageStyle) {
        Toolkit.getToolkit().checkFxUserThread();
        this.initStyle(stageStyle);
        StageHelper.initHelper(this);
    }

    @Override
    public final void setScene(Scene scene) {
        Toolkit.getToolkit().checkFxUserThread();
        super.setScene(scene);
    }

    @Override
    public final void show() {
        super.show();
    }

    final void initSecurityDialog(boolean bl2) {
        if (this.hasBeenVisible) {
            throw new IllegalStateException("Cannot set securityDialog once stage has been set visible");
        }
        this.securityDialog = bl2;
    }

    final boolean isSecurityDialog() {
        return this.securityDialog;
    }

    void setPrimary(boolean bl2) {
        this.primary = bl2;
    }

    boolean isPrimary() {
        return this.primary;
    }

    void setImportant(boolean bl2) {
        this.important = bl2;
    }

    private boolean isImportant() {
        return this.important;
    }

    public void showAndWait() {
        Toolkit.getToolkit().checkFxUserThread();
        if (this.isPrimary()) {
            throw new IllegalStateException("Cannot call this method on primary stage");
        }
        if (this.isShowing()) {
            throw new IllegalStateException("Stage already visible");
        }
        if (!Toolkit.getToolkit().canStartNestedEventLoop()) {
            throw new IllegalStateException("showAndWait is not allowed during animation or layout processing");
        }
        assert (!this.inNestedEventLoop);
        this.show();
        this.inNestedEventLoop = true;
        Toolkit.getToolkit().enterNestedEventLoop(this);
    }

    public final void initStyle(StageStyle stageStyle) {
        if (this.hasBeenVisible) {
            throw new IllegalStateException("Cannot set style once stage has been set visible");
        }
        this.style = stageStyle;
    }

    public final StageStyle getStyle() {
        return this.style;
    }

    public final void initModality(Modality modality) {
        if (this.hasBeenVisible) {
            throw new IllegalStateException("Cannot set modality once stage has been set visible");
        }
        if (this.isPrimary()) {
            throw new IllegalStateException("Cannot set modality for the primary stage");
        }
        this.modality = modality;
    }

    public final Modality getModality() {
        return this.modality;
    }

    public final void initOwner(Window eventTarget) {
        if (this.hasBeenVisible) {
            throw new IllegalStateException("Cannot set owner once stage has been set visible");
        }
        if (this.isPrimary()) {
            throw new IllegalStateException("Cannot set owner for the primary stage");
        }
        this.owner = eventTarget;
        eventTarget = this.getScene();
        if (eventTarget != null) {
            SceneHelper.parentEffectiveOrientationInvalidated((Scene)eventTarget);
        }
    }

    public final Window getOwner() {
        return this.owner;
    }

    public final void setFullScreen(boolean bl2) {
        Toolkit.getToolkit().checkFxUserThread();
        this.fullScreenPropertyImpl().set(bl2);
        if (this.getPeer() != null) {
            this.getPeer().setFullScreen(bl2);
        }
    }

    public final boolean isFullScreen() {
        if (this.fullScreen == null) {
            return false;
        }
        return this.fullScreen.get();
    }

    public final ReadOnlyBooleanProperty fullScreenProperty() {
        return this.fullScreenPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper fullScreenPropertyImpl() {
        if (this.fullScreen == null) {
            this.fullScreen = new ReadOnlyBooleanWrapper(this, "fullScreen");
        }
        return this.fullScreen;
    }

    public final ObservableList<Image> getIcons() {
        return this.icons;
    }

    public final void setTitle(String string) {
        this.titleProperty().set(string);
    }

    public final String getTitle() {
        if (this.title == null) {
            return null;
        }
        return (String)this.title.get();
    }

    public final StringProperty titleProperty() {
        if (this.title == null) {
            this.title = new Stage$5(this);
        }
        return this.title;
    }

    public final void setIconified(boolean bl2) {
        this.iconifiedPropertyImpl().set(bl2);
        if (this.getPeer() != null) {
            this.getPeer().setIconified(bl2);
        }
    }

    public final boolean isIconified() {
        if (this.iconified == null) {
            return false;
        }
        return this.iconified.get();
    }

    public final ReadOnlyBooleanProperty iconifiedProperty() {
        return this.iconifiedPropertyImpl().getReadOnlyProperty();
    }

    private final ReadOnlyBooleanWrapper iconifiedPropertyImpl() {
        if (this.iconified == null) {
            this.iconified = new ReadOnlyBooleanWrapper(this, "iconified");
        }
        return this.iconified;
    }

    public final void setMaximized(boolean bl2) {
        this.maximizedPropertyImpl().set(bl2);
        if (this.getPeer() != null) {
            this.getPeer().setMaximized(bl2);
        }
    }

    public final boolean isMaximized() {
        if (this.maximized == null) {
            return false;
        }
        return this.maximized.get();
    }

    public final ReadOnlyBooleanProperty maximizedProperty() {
        return this.maximizedPropertyImpl().getReadOnlyProperty();
    }

    private final ReadOnlyBooleanWrapper maximizedPropertyImpl() {
        if (this.maximized == null) {
            this.maximized = new ReadOnlyBooleanWrapper(this, "maximized");
        }
        return this.maximized;
    }

    public final void setAlwaysOnTop(boolean bl2) {
        this.alwaysOnTopPropertyImpl().set(bl2);
        if (this.getPeer() != null) {
            this.getPeer().setAlwaysOnTop(bl2);
        }
    }

    public final boolean isAlwaysOnTop() {
        if (this.alwaysOnTop == null) {
            return false;
        }
        return this.alwaysOnTop.get();
    }

    public final ReadOnlyBooleanProperty alwaysOnTopProperty() {
        return this.alwaysOnTopPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper alwaysOnTopPropertyImpl() {
        if (this.alwaysOnTop == null) {
            this.alwaysOnTop = new ReadOnlyBooleanWrapper(this, "alwaysOnTop");
        }
        return this.alwaysOnTop;
    }

    public final void setResizable(boolean bl2) {
        this.resizableProperty().set(bl2);
    }

    public final boolean isResizable() {
        if (this.resizable == null) {
            return true;
        }
        return this.resizable.get();
    }

    public final BooleanProperty resizableProperty() {
        if (this.resizable == null) {
            this.resizable = new Stage$ResizableProperty(this);
        }
        return this.resizable;
    }

    public final void setMinWidth(double d2) {
        this.minWidthProperty().set(d2);
    }

    public final double getMinWidth() {
        if (this.minWidth == null) {
            return 0.0;
        }
        return this.minWidth.get();
    }

    public final DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new Stage$6(this, 0.0);
        }
        return this.minWidth;
    }

    public final void setMinHeight(double d2) {
        this.minHeightProperty().set(d2);
    }

    public final double getMinHeight() {
        if (this.minHeight == null) {
            return 0.0;
        }
        return this.minHeight.get();
    }

    public final DoubleProperty minHeightProperty() {
        if (this.minHeight == null) {
            this.minHeight = new Stage$7(this, 0.0);
        }
        return this.minHeight;
    }

    public final void setMaxWidth(double d2) {
        this.maxWidthProperty().set(d2);
    }

    public final double getMaxWidth() {
        if (this.maxWidth == null) {
            return Double.MAX_VALUE;
        }
        return this.maxWidth.get();
    }

    public final DoubleProperty maxWidthProperty() {
        if (this.maxWidth == null) {
            this.maxWidth = new Stage$8(this, Double.MAX_VALUE);
        }
        return this.maxWidth;
    }

    public final void setMaxHeight(double d2) {
        this.maxHeightProperty().set(d2);
    }

    public final double getMaxHeight() {
        if (this.maxHeight == null) {
            return Double.MAX_VALUE;
        }
        return this.maxHeight.get();
    }

    public final DoubleProperty maxHeightProperty() {
        if (this.maxHeight == null) {
            this.maxHeight = new Stage$9(this, Double.MAX_VALUE);
        }
        return this.maxHeight;
    }

    private void doVisibleChanging(boolean bl2) {
        Toolkit toolkit = Toolkit.getToolkit();
        if (bl2 && this.getPeer() == null) {
            SecurityManager securityManager;
            Object object = this.getOwner();
            object = object == null ? null : ((Window)object).getPeer();
            Scene scene = this.getScene();
            boolean bl3 = scene != null && scene.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
            StageStyle stageStyle = this.getStyle();
            if (stageStyle == StageStyle.TRANSPARENT && (securityManager = System.getSecurityManager()) != null) {
                try {
                    securityManager.checkPermission(FXPermissions.CREATE_TRANSPARENT_WINDOW_PERMISSION);
                }
                catch (SecurityException securityException) {
                    stageStyle = StageStyle.UNDECORATED;
                }
            }
            Stage stage = this;
            this.setPeer(toolkit.createTKStage(stage, stage.isSecurityDialog(), stageStyle, this.isPrimary(), this.getModality(), (TKStage)object, bl3, this.acc));
            this.getPeer().setMinimumSize((int)Math.ceil(this.getMinWidth()), (int)Math.ceil(this.getMinHeight()));
            this.getPeer().setMaximumSize((int)Math.floor(this.getMaxWidth()), (int)Math.floor(this.getMaxHeight()));
            this.setPeerListener(new StagePeerListener(this, STAGE_ACCESSOR));
        }
    }

    private void doVisibleChanged(boolean bl2) {
        if (bl2) {
            TKStage tKStage = this.getPeer();
            tKStage.setImportant(this.isImportant());
            tKStage.setResizable(this.isResizable());
            tKStage.setFullScreen(this.isFullScreen());
            tKStage.setAlwaysOnTop(this.isAlwaysOnTop());
            tKStage.setIconified(this.isIconified());
            tKStage.setMaximized(this.isMaximized());
            tKStage.setTitle(this.getTitle());
            if (!this.isIconified()) {
                tKStage.requestFocus();
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Image image : this.icons) {
                arrayList.add(Toolkit.getImageAccessor().getPlatformImage(image));
            }
            if (tKStage != null) {
                tKStage.setIcons(arrayList);
            }
        }
        if (!bl2 && this.inNestedEventLoop) {
            this.inNestedEventLoop = false;
            Toolkit.getToolkit().exitNestedEventLoop(this, null);
        }
    }

    public void toFront() {
        if (this.getPeer() != null) {
            this.getPeer().toFront();
        }
    }

    public void toBack() {
        if (this.getPeer() != null) {
            this.getPeer().toBack();
        }
    }

    public void close() {
        this.hide();
    }

    @Override
    Window getWindowOwner() {
        return this.getOwner();
    }

    public final void setFullScreenExitKeyCombination(KeyCombination keyCombination) {
        this.fullScreenExitCombination.set(keyCombination);
    }

    public final KeyCombination getFullScreenExitKeyCombination() {
        return (KeyCombination)this.fullScreenExitCombination.get();
    }

    public final ObjectProperty<KeyCombination> fullScreenExitKeyProperty() {
        return this.fullScreenExitCombination;
    }

    public final void setFullScreenExitHint(String string) {
        this.fullScreenExitHint.set(string);
    }

    public final String getFullScreenExitHint() {
        return (String)this.fullScreenExitHint.get();
    }

    public final ObjectProperty<String> fullScreenExitHintProperty() {
        return this.fullScreenExitHint;
    }

    static {
        StageHelper.setStageAccessor(new Stage$1());
        STAGE_ACCESSOR = new Stage$2();
    }
}

