/*
 * Decompiled with CFR 0.152.
 */
package javafx.stage;

import com.sun.javafx.FXPermissions;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.stage.WindowEventDispatcher;
import com.sun.javafx.stage.WindowHelper;
import com.sun.javafx.stage.WindowPeerListener;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Rectangle2D;
import javafx.scene.Scene;
import javafx.stage.Screen;
import javafx.stage.Window$1;
import javafx.stage.Window$10;
import javafx.stage.Window$11;
import javafx.stage.Window$12;
import javafx.stage.Window$2;
import javafx.stage.Window$3;
import javafx.stage.Window$4;
import javafx.stage.Window$5;
import javafx.stage.Window$6;
import javafx.stage.Window$7;
import javafx.stage.Window$8;
import javafx.stage.Window$9;
import javafx.stage.Window$SceneModel;
import javafx.stage.Window$TKBoundsConfigurator;
import javafx.stage.WindowEvent;

public class Window
implements EventTarget {
    private static ObservableList<Window> windows = FXCollections.observableArrayList();
    private static ObservableList<Window> unmodifiableWindows = FXCollections.unmodifiableObservableList(windows);
    private WindowHelper windowHelper = null;
    final AccessControlContext acc = AccessController.getContext();
    private WindowPeerListener peerListener;
    private TKStage peer;
    private Window$TKBoundsConfigurator peerBoundsConfigurator = new Window$TKBoundsConfigurator(this);
    private boolean sizeToScene = false;
    private static final float CENTER_ON_SCREEN_X_FRACTION = 0.5f;
    private static final float CENTER_ON_SCREEN_Y_FRACTION = 0.33333334f;
    private ReadOnlyDoubleWrapper outputScaleX = new ReadOnlyDoubleWrapper(this, "outputScaleX", 1.0);
    private ReadOnlyDoubleWrapper outputScaleY = new ReadOnlyDoubleWrapper(this, "outputScaleY", 1.0);
    private BooleanProperty forceIntegerRenderScale;
    private DoubleProperty renderScaleX;
    private DoubleProperty renderScaleY;
    private boolean xExplicit;
    private ReadOnlyDoubleWrapper x;
    private boolean yExplicit;
    private ReadOnlyDoubleWrapper y;
    private boolean widthExplicit;
    private ReadOnlyDoubleWrapper width;
    private boolean heightExplicit;
    private ReadOnlyDoubleWrapper height;
    private ReadOnlyBooleanWrapper focused;
    private static final Object USER_DATA_KEY;
    private ObservableMap<Object, Object> properties;
    private Window$SceneModel scene;
    private DoubleProperty opacity;
    private ObjectProperty<EventHandler<WindowEvent>> onCloseRequest;
    private ObjectProperty<EventHandler<WindowEvent>> onShowing;
    private ObjectProperty<EventHandler<WindowEvent>> onShown;
    private ObjectProperty<EventHandler<WindowEvent>> onHiding;
    private ObjectProperty<EventHandler<WindowEvent>> onHidden;
    private ReadOnlyBooleanWrapper showing;
    boolean hasBeenVisible;
    private ObjectProperty<EventDispatcher> eventDispatcher;
    private WindowEventDispatcher internalEventDispatcher;
    private int focusGrabCounter;
    private final ReadOnlyObjectWrapper<Screen> screen;

    public static ObservableList<Window> getWindows() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(FXPermissions.ACCESS_WINDOW_LIST_PERMISSION);
        }
        return unmodifiableWindows;
    }

    protected Window() {
        Window window = this;
        this.forceIntegerRenderScale = new Window$2(window, window, "forceIntegerRenderScale", false);
        Window window2 = this;
        this.renderScaleX = new Window$3(window2, window2, "renderScaleX", 1.0);
        Window window3 = this;
        this.renderScaleY = new Window$4(window3, window3, "renderScaleY", 1.0);
        this.xExplicit = false;
        this.x = new ReadOnlyDoubleWrapper(this, "x", Double.NaN);
        this.yExplicit = false;
        this.y = new ReadOnlyDoubleWrapper(this, "y", Double.NaN);
        this.widthExplicit = false;
        this.width = new ReadOnlyDoubleWrapper(this, "width", Double.NaN);
        this.heightExplicit = false;
        this.height = new ReadOnlyDoubleWrapper(this, "height", Double.NaN);
        this.focused = new Window$5(this);
        this.scene = new Window$SceneModel(this);
        this.showing = new Window$12(this);
        this.hasBeenVisible = false;
        this.screen = new ReadOnlyObjectWrapper<Screen>(Screen.getPrimary());
        this.initializeInternalEventDispatcher();
        WindowHelper.initHelper(this);
    }

    WindowPeerListener getPeerListener() {
        return this.peerListener;
    }

    void setPeerListener(WindowPeerListener windowPeerListener) {
        this.peerListener = windowPeerListener;
    }

    TKStage getPeer() {
        return this.peer;
    }

    void setPeer(TKStage tKStage) {
        this.peer = tKStage;
    }

    public void sizeToScene() {
        if (this.getScene() != null && this.peer != null) {
            SceneHelper.preferredSize(this.getScene());
            this.adjustSize(false);
            return;
        }
        this.sizeToScene = true;
    }

    private void adjustSize(boolean bl2) {
        if (this.getScene() == null) {
            return;
        }
        if (this.peer != null) {
            double d2;
            double d3;
            double d4 = this.getScene().getWidth();
            double d5 = d3 > 0.0 ? d4 : -1.0;
            double d6 = -1.0;
            if (bl2 && this.widthExplicit) {
                d6 = this.getWidth();
            } else if (d5 <= 0.0) {
                d6 = this.widthExplicit ? this.getWidth() : -1.0;
            } else {
                this.widthExplicit = false;
            }
            double d7 = this.getScene().getHeight();
            double d8 = d2 > 0.0 ? d7 : -1.0;
            double d9 = -1.0;
            if (bl2 && this.heightExplicit) {
                d9 = this.getHeight();
            } else if (d8 <= 0.0) {
                d9 = this.heightExplicit ? this.getHeight() : -1.0;
            } else {
                this.heightExplicit = false;
            }
            this.peerBoundsConfigurator.setSize(d6, d9, d5, d8);
            this.applyBounds();
        }
    }

    public void centerOnScreen() {
        this.xExplicit = false;
        this.yExplicit = false;
        if (this.peer != null) {
            Rectangle2D rectangle2D = this.getWindowScreen().getVisualBounds();
            double d2 = rectangle2D.getMinX() + (rectangle2D.getWidth() - this.getWidth()) * 0.5;
            double d3 = rectangle2D.getMinY() + (rectangle2D.getHeight() - this.getHeight()) * 0.3333333432674408;
            this.x.set(d2);
            this.y.set(d3);
            this.peerBoundsConfigurator.setLocation(d2, d3, 0.5f, 0.33333334f);
            this.applyBounds();
        }
    }

    private void updateOutputScales(double d2, double d3) {
        this.updateRenderScales(d2, d3);
        this.outputScaleX.set(d2);
        this.outputScaleY.set(d3);
    }

    void updateRenderScales(double d2, double d3) {
        boolean bl2 = this.forceIntegerRenderScale.get();
        if (!this.renderScaleX.isBound()) {
            this.renderScaleX.set(bl2 ? Math.ceil(d2) : d2);
        }
        if (!this.renderScaleY.isBound()) {
            this.renderScaleY.set(bl2 ? Math.ceil(d3) : d3);
        }
    }

    public final double getOutputScaleX() {
        return this.outputScaleX.get();
    }

    public final ReadOnlyDoubleProperty outputScaleXProperty() {
        return this.outputScaleX.getReadOnlyProperty();
    }

    public final double getOutputScaleY() {
        return this.outputScaleY.get();
    }

    public final ReadOnlyDoubleProperty outputScaleYProperty() {
        return this.outputScaleY.getReadOnlyProperty();
    }

    public final void setForceIntegerRenderScale(boolean bl2) {
        this.forceIntegerRenderScale.set(bl2);
    }

    public final boolean isForceIntegerRenderScale() {
        return this.forceIntegerRenderScale.get();
    }

    public final BooleanProperty forceIntegerRenderScaleProperty() {
        return this.forceIntegerRenderScale;
    }

    public final void setRenderScaleX(double d2) {
        this.renderScaleX.set(d2);
    }

    public final double getRenderScaleX() {
        return this.renderScaleX.get();
    }

    public final DoubleProperty renderScaleXProperty() {
        return this.renderScaleX;
    }

    public final void setRenderScaleY(double d2) {
        this.renderScaleY.set(d2);
    }

    public final double getRenderScaleY() {
        return this.renderScaleY.get();
    }

    public final DoubleProperty renderScaleYProperty() {
        return this.renderScaleY;
    }

    public final void setX(double d2) {
        this.setXInternal(d2);
    }

    public final double getX() {
        return this.x.get();
    }

    public final ReadOnlyDoubleProperty xProperty() {
        return this.x.getReadOnlyProperty();
    }

    void setXInternal(double d2) {
        this.x.set(d2);
        this.peerBoundsConfigurator.setX(d2, 0.0f);
        this.xExplicit = true;
    }

    public final void setY(double d2) {
        this.setYInternal(d2);
    }

    public final double getY() {
        return this.y.get();
    }

    public final ReadOnlyDoubleProperty yProperty() {
        return this.y.getReadOnlyProperty();
    }

    void setYInternal(double d2) {
        this.y.set(d2);
        this.peerBoundsConfigurator.setY(d2, 0.0f);
        this.yExplicit = true;
    }

    void notifyLocationChanged(double d2, double d3) {
        this.x.set(d2);
        this.y.set(d3);
    }

    public final void setWidth(double d2) {
        this.width.set(d2);
        this.peerBoundsConfigurator.setWindowWidth(d2);
        this.widthExplicit = true;
    }

    public final double getWidth() {
        return this.width.get();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.width.getReadOnlyProperty();
    }

    public final void setHeight(double d2) {
        this.height.set(d2);
        this.peerBoundsConfigurator.setWindowHeight(d2);
        this.heightExplicit = true;
    }

    public final double getHeight() {
        return this.height.get();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.height.getReadOnlyProperty();
    }

    void notifySizeChanged(double d2, double d3) {
        this.width.set(d2);
        this.height.set(d3);
    }

    final void setFocused(boolean bl2) {
        this.focused.set(bl2);
    }

    public final void requestFocus() {
        if (this.peer != null) {
            this.peer.requestFocus();
        }
    }

    public final boolean isFocused() {
        return this.focused.get();
    }

    public final ReadOnlyBooleanProperty focusedProperty() {
        return this.focused.getReadOnlyProperty();
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public void setUserData(Object object) {
        this.getProperties().put(USER_DATA_KEY, object);
    }

    public Object getUserData() {
        return this.getProperties().get(USER_DATA_KEY);
    }

    protected void setScene(Scene scene) {
        this.scene.set(scene);
    }

    public final Scene getScene() {
        return (Scene)this.scene.get();
    }

    public final ReadOnlyObjectProperty<Scene> sceneProperty() {
        return this.scene.getReadOnlyProperty();
    }

    public final void setOpacity(double d2) {
        this.opacityProperty().set(d2);
    }

    public final double getOpacity() {
        if (this.opacity == null) {
            return 1.0;
        }
        return this.opacity.get();
    }

    public final DoubleProperty opacityProperty() {
        if (this.opacity == null) {
            this.opacity = new Window$6(this, 1.0);
        }
        return this.opacity;
    }

    public final void setOnCloseRequest(EventHandler<WindowEvent> eventHandler) {
        this.onCloseRequestProperty().set(eventHandler);
    }

    public final EventHandler<WindowEvent> getOnCloseRequest() {
        if (this.onCloseRequest != null) {
            return (EventHandler)this.onCloseRequest.get();
        }
        return null;
    }

    public final ObjectProperty<EventHandler<WindowEvent>> onCloseRequestProperty() {
        if (this.onCloseRequest == null) {
            this.onCloseRequest = new Window$7(this);
        }
        return this.onCloseRequest;
    }

    public final void setOnShowing(EventHandler<WindowEvent> eventHandler) {
        this.onShowingProperty().set(eventHandler);
    }

    public final EventHandler<WindowEvent> getOnShowing() {
        if (this.onShowing == null) {
            return null;
        }
        return (EventHandler)this.onShowing.get();
    }

    public final ObjectProperty<EventHandler<WindowEvent>> onShowingProperty() {
        if (this.onShowing == null) {
            this.onShowing = new Window$8(this);
        }
        return this.onShowing;
    }

    public final void setOnShown(EventHandler<WindowEvent> eventHandler) {
        this.onShownProperty().set(eventHandler);
    }

    public final EventHandler<WindowEvent> getOnShown() {
        if (this.onShown == null) {
            return null;
        }
        return (EventHandler)this.onShown.get();
    }

    public final ObjectProperty<EventHandler<WindowEvent>> onShownProperty() {
        if (this.onShown == null) {
            this.onShown = new Window$9(this);
        }
        return this.onShown;
    }

    public final void setOnHiding(EventHandler<WindowEvent> eventHandler) {
        this.onHidingProperty().set(eventHandler);
    }

    public final EventHandler<WindowEvent> getOnHiding() {
        if (this.onHiding == null) {
            return null;
        }
        return (EventHandler)this.onHiding.get();
    }

    public final ObjectProperty<EventHandler<WindowEvent>> onHidingProperty() {
        if (this.onHiding == null) {
            this.onHiding = new Window$10(this);
        }
        return this.onHiding;
    }

    public final void setOnHidden(EventHandler<WindowEvent> eventHandler) {
        this.onHiddenProperty().set(eventHandler);
    }

    public final EventHandler<WindowEvent> getOnHidden() {
        if (this.onHidden == null) {
            return null;
        }
        return (EventHandler)this.onHidden.get();
    }

    public final ObjectProperty<EventHandler<WindowEvent>> onHiddenProperty() {
        if (this.onHidden == null) {
            this.onHidden = new Window$11(this);
        }
        return this.onHidden;
    }

    private void setShowing(boolean bl2) {
        Toolkit.getToolkit().checkFxUserThread();
        this.showing.set(bl2);
    }

    public final boolean isShowing() {
        return this.showing.get();
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.showing.getReadOnlyProperty();
    }

    protected void show() {
        this.setShowing(true);
    }

    public void hide() {
        this.setShowing(false);
    }

    private void doVisibleChanging(boolean bl2) {
        if (bl2 && this.getScene() != null) {
            NodeHelper.reapplyCSS(this.getScene().getRoot());
        }
    }

    private void doVisibleChanged(boolean bl2) {
        assert (this.peer != null);
        if (!bl2) {
            this.peerListener = null;
            this.peer = null;
        }
    }

    public final void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcherProperty().set(eventDispatcher);
    }

    public final EventDispatcher getEventDispatcher() {
        return (EventDispatcher)this.eventDispatcherProperty().get();
    }

    public final ObjectProperty<EventDispatcher> eventDispatcherProperty() {
        this.initializeInternalEventDispatcher();
        return this.eventDispatcher;
    }

    public final <T extends Event> void addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void addEventFilter(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventFilter(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventFilter(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventFilter(eventType, eventHandler);
    }

    protected final <T extends Event> void setEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().setEventHandler(eventType, eventHandler);
    }

    WindowEventDispatcher getInternalEventDispatcher() {
        this.initializeInternalEventDispatcher();
        return this.internalEventDispatcher;
    }

    private void initializeInternalEventDispatcher() {
        if (this.internalEventDispatcher == null) {
            this.internalEventDispatcher = this.createInternalEventDispatcher();
            this.eventDispatcher = new SimpleObjectProperty<WindowEventDispatcher>(this, "eventDispatcher", this.internalEventDispatcher);
        }
    }

    WindowEventDispatcher createInternalEventDispatcher() {
        return new WindowEventDispatcher(this);
    }

    public final void fireEvent(Event event) {
        Event.fireEvent(this, event);
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        EventDispatcher eventDispatcher;
        if (this.eventDispatcher != null && (eventDispatcher = (EventDispatcher)this.eventDispatcher.get()) != null) {
            eventDispatchChain = eventDispatchChain.prepend(eventDispatcher);
        }
        return eventDispatchChain;
    }

    void increaseFocusGrabCounter() {
        if (++this.focusGrabCounter == 1 && this.peer != null && this.isFocused()) {
            this.peer.grabFocus();
        }
    }

    void decreaseFocusGrabCounter() {
        if (--this.focusGrabCounter == 0 && this.peer != null) {
            this.peer.ungrabFocus();
        }
    }

    private void focusChanged(boolean bl2) {
        if (this.focusGrabCounter > 0 && this.peer != null && bl2) {
            this.peer.grabFocus();
        }
    }

    final void applyBounds() {
        this.peerBoundsConfigurator.apply();
    }

    Window getWindowOwner() {
        return null;
    }

    private Screen getWindowScreen() {
        Window window = this;
        do {
            if (Double.isNaN(window.getX()) || Double.isNaN(window.getY()) || Double.isNaN(window.getWidth()) || Double.isNaN(window.getHeight())) continue;
            return Utils.getScreenForRectangle(new Rectangle2D(window.getX(), window.getY(), window.getWidth(), window.getHeight()));
        } while ((window = window.getWindowOwner()) != null);
        return Screen.getPrimary();
    }

    private ReadOnlyObjectProperty<Screen> screenProperty() {
        return this.screen.getReadOnlyProperty();
    }

    private void notifyScreenChanged(Object object, Object object2) {
        this.screen.set(Screen.getScreenForNative(object2));
    }

    static {
        WindowHelper.setWindowAccessor(new Window$1());
        USER_DATA_KEY = new Object();
    }
}

