/*
 * Decompiled with CFR 0.152.
 */
package javafx.util.converter;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DecimalStyle;
import java.time.format.FormatStyle;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import javafx.util.StringConverter;

class LocalDateTimeStringConverter$LdtConverter<T extends Temporal>
extends StringConverter<T> {
    private Class<T> type;
    Locale locale;
    Chronology chronology;
    DateTimeFormatter formatter;
    DateTimeFormatter parser;
    FormatStyle dateStyle;
    FormatStyle timeStyle;

    LocalDateTimeStringConverter$LdtConverter(Class<T> clazz, DateTimeFormatter dateTimeFormatter, DateTimeFormatter dateTimeFormatter2, FormatStyle formatStyle, FormatStyle formatStyle2, Locale locale, Chronology chronology) {
        this.type = clazz;
        this.formatter = dateTimeFormatter;
        this.parser = dateTimeFormatter2 != null ? dateTimeFormatter2 : dateTimeFormatter;
        this.locale = locale != null ? locale : Locale.getDefault(Locale.Category.FORMAT);
        Chronology chronology2 = this.chronology = chronology != null ? chronology : IsoChronology.INSTANCE;
        if (clazz == LocalDate.class || clazz == LocalDateTime.class) {
            FormatStyle formatStyle3 = this.dateStyle = formatStyle != null ? formatStyle : FormatStyle.SHORT;
        }
        if (clazz == LocalTime.class || clazz == LocalDateTime.class) {
            this.timeStyle = formatStyle2 != null ? formatStyle2 : FormatStyle.SHORT;
        }
    }

    @Override
    public T fromString(String object) {
        if (object == null || ((String)object).isEmpty()) {
            return null;
        }
        object = ((String)object).trim();
        if (this.parser == null) {
            this.parser = this.getDefaultParser();
        }
        object = this.parser.parse((CharSequence)object);
        if (this.type == LocalDate.class) {
            return (T)LocalDate.from((TemporalAccessor)object);
        }
        if (this.type == LocalTime.class) {
            return (T)LocalTime.from((TemporalAccessor)object);
        }
        return (T)LocalDateTime.from((TemporalAccessor)object);
    }

    @Override
    public String toString(T t2) {
        if (t2 == null) {
            return "";
        }
        if (this.formatter == null) {
            this.formatter = this.getDefaultFormatter();
        }
        return this.formatter.format((TemporalAccessor)t2);
    }

    private DateTimeFormatter getDefaultParser() {
        String string = DateTimeFormatterBuilder.getLocalizedDateTimePattern(this.dateStyle, this.timeStyle, this.chronology, this.locale);
        return new DateTimeFormatterBuilder().parseLenient().appendPattern(string).toFormatter().withChronology(this.chronology).withDecimalStyle(DecimalStyle.of(this.locale));
    }

    private DateTimeFormatter getDefaultFormatter() {
        DateTimeFormatter dateTimeFormatter = this.dateStyle != null && this.timeStyle != null ? DateTimeFormatter.ofLocalizedDateTime(this.dateStyle, this.timeStyle) : (this.dateStyle != null ? DateTimeFormatter.ofLocalizedDate(this.dateStyle) : DateTimeFormatter.ofLocalizedTime(this.timeStyle));
        dateTimeFormatter = dateTimeFormatter.withLocale(this.locale).withChronology(this.chronology).withDecimalStyle(DecimalStyle.of(this.locale));
        if (this.dateStyle != null) {
            dateTimeFormatter = this.fixFourDigitYear(dateTimeFormatter, this.dateStyle, this.timeStyle, this.chronology, this.locale);
        }
        return dateTimeFormatter;
    }

    private DateTimeFormatter fixFourDigitYear(DateTimeFormatter object, FormatStyle object2, FormatStyle formatStyle, Chronology chronology, Locale locale) {
        if (((String)(object2 = DateTimeFormatterBuilder.getLocalizedDateTimePattern((FormatStyle)((Object)object2), formatStyle, chronology, locale))).contains("yy") && !((String)object2).contains("yyy")) {
            object = ((String)object2).replace("yy", "yyyy");
            object = DateTimeFormatter.ofPattern((String)object).withDecimalStyle(DecimalStyle.of(locale));
        }
        return object;
    }
}

