/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.cli.Converter;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.Option$1;
import org.apache.commons.cli.Option$Builder;
import org.apache.commons.cli.OptionValidator;
import org.apache.commons.cli.TypeHandler;
import org.apache.commons.cli.Util;

public class Option
implements Serializable,
Cloneable {
    static final Option[] EMPTY_ARRAY = new Option[0];
    private static final long serialVersionUID = 1L;
    public static final int UNINITIALIZED = -1;
    public static final int UNLIMITED_VALUES = -2;
    private int argCount = -1;
    private String argName;
    private transient Converter<?, ?> converter;
    private final transient DeprecatedAttributes deprecated;
    private String description;
    private String longOption;
    private final String option;
    private boolean optionalArg;
    private boolean required;
    private String since;
    private Class<?> type = String.class;
    private List<String> values = new ArrayList<String>();
    private char valueSeparator;

    public static Option$Builder builder() {
        return Option.builder(null);
    }

    public static Option$Builder builder(String string) {
        return new Option$Builder(string, null);
    }

    private Option(Option$Builder option$Builder) {
        if (Option$Builder.access$200(option$Builder) == null && Option$Builder.access$300(option$Builder) == null) {
            throw new IllegalStateException("Either opt or longOpt must be specified");
        }
        this.argName = Option$Builder.access$400(option$Builder);
        this.description = Option$Builder.access$500(option$Builder);
        this.longOption = Option$Builder.access$300(option$Builder);
        this.argCount = Option$Builder.access$600(option$Builder);
        this.option = Option$Builder.access$200(option$Builder);
        this.optionalArg = Option$Builder.access$700(option$Builder);
        this.deprecated = Option$Builder.access$800(option$Builder);
        this.required = Option$Builder.access$900(option$Builder);
        this.since = Option$Builder.access$1000(option$Builder);
        this.type = Option$Builder.access$1100(option$Builder);
        this.valueSeparator = Option$Builder.access$1200(option$Builder);
        this.converter = Option$Builder.access$1300(option$Builder);
    }

    public Option(String string, boolean bl2, String string2) throws IllegalArgumentException {
        this(string, null, bl2, string2);
    }

    public Option(String string, String string2) throws IllegalArgumentException {
        this(string, null, false, string2);
    }

    public Option(String string, String string2, boolean bl2, String string3) throws IllegalArgumentException {
        this.deprecated = null;
        this.option = OptionValidator.validate(string);
        this.longOption = string2;
        if (bl2) {
            this.argCount = 1;
        }
        this.description = string3;
    }

    boolean acceptsArg() {
        return !(!this.hasArg() && !this.hasArgs() && !this.hasOptionalArg() || this.argCount > 0 && this.values.size() >= this.argCount);
    }

    private void add(String string) {
        if (!this.acceptsArg()) {
            throw new IllegalArgumentException("Cannot add value, list full.");
        }
        this.values.add(string);
    }

    @Deprecated
    public boolean addValue(String string) {
        throw new UnsupportedOperationException("The addValue method is not intended for client use. Subclasses should use the processValue method instead.");
    }

    void clearValues() {
        this.values.clear();
    }

    public Object clone() {
        try {
            Option option = (Option)super.clone();
            ((Option)super.clone()).values = new ArrayList<String>(this.values);
            return option;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new UnsupportedOperationException(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Option)) {
            return false;
        }
        object = (Option)object;
        return Objects.equals(this.longOption, ((Option)object).longOption) && Objects.equals(this.option, ((Option)object).option);
    }

    public String getArgName() {
        return this.argName;
    }

    public int getArgs() {
        return this.argCount;
    }

    public Converter<?, ?> getConverter() {
        if (this.converter == null) {
            return TypeHandler.getDefault().getConverter(this.type);
        }
        return this.converter;
    }

    public DeprecatedAttributes getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public int getId() {
        return this.getKey().charAt(0);
    }

    public String getKey() {
        if (this.option == null) {
            return this.longOption;
        }
        return this.option;
    }

    public String getLongOpt() {
        return this.longOption;
    }

    public String getOpt() {
        return this.option;
    }

    public String getSince() {
        return this.since;
    }

    public Object getType() {
        return this.type;
    }

    public String getValue() {
        if (this.hasNoValues()) {
            return null;
        }
        return this.values.get(0);
    }

    public String getValue(int n2) throws IndexOutOfBoundsException {
        if (this.hasNoValues()) {
            return null;
        }
        return this.values.get(n2);
    }

    public String getValue(String string) {
        String string2 = this.getValue();
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public String[] getValues() {
        if (this.hasNoValues()) {
            return null;
        }
        return this.values.toArray(Util.EMPTY_STRING_ARRAY);
    }

    public char getValueSeparator() {
        return this.valueSeparator;
    }

    public List<String> getValuesList() {
        return this.values;
    }

    public boolean hasArg() {
        return this.argCount > 0 || this.argCount == -2;
    }

    public boolean hasArgName() {
        return this.argName != null && !this.argName.isEmpty();
    }

    public boolean hasArgs() {
        return this.argCount > 1 || this.argCount == -2;
    }

    public int hashCode() {
        return Objects.hash(this.longOption, this.option);
    }

    public boolean hasLongOpt() {
        return this.longOption != null;
    }

    private boolean hasNoValues() {
        return this.values.isEmpty();
    }

    public boolean hasOptionalArg() {
        return this.optionalArg;
    }

    public boolean hasValueSeparator() {
        return this.valueSeparator > '\u0000';
    }

    public boolean isDeprecated() {
        return this.deprecated != null;
    }

    public boolean isRequired() {
        return this.required;
    }

    void processValue(String string) {
        if (this.argCount == -1) {
            throw new IllegalStateException("NO_ARGS_ALLOWED");
        }
        string = Objects.requireNonNull(string, "value");
        if (this.hasValueSeparator()) {
            char c2 = this.getValueSeparator();
            int n2 = string.indexOf(c2);
            while (n2 != -1 && this.values.size() != this.argCount - 1) {
                this.add(string.substring(0, n2));
                string = string.substring(n2 + 1);
                n2 = string.indexOf(c2);
            }
        }
        this.add(string);
    }

    boolean requiresArg() {
        if (this.optionalArg) {
            return false;
        }
        if (this.argCount == -2) {
            return this.values.isEmpty();
        }
        return this.acceptsArg();
    }

    public void setArgName(String string) {
        this.argName = string;
    }

    public void setArgs(int n2) {
        this.argCount = n2;
    }

    public void setConverter(Converter<?, ?> converter) {
        this.converter = converter;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setLongOpt(String string) {
        this.longOption = string;
    }

    public void setOptionalArg(boolean bl2) {
        this.optionalArg = bl2;
    }

    public void setRequired(boolean bl2) {
        this.required = bl2;
    }

    public void setType(Class<?> clazz) {
        this.type = Option$Builder.access$1400(clazz);
    }

    @Deprecated
    public void setType(Object object) {
        this.setType((Class)object);
    }

    public void setValueSeparator(char c2) {
        this.valueSeparator = c2;
    }

    String toDeprecatedString() {
        if (!this.isDeprecated()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("Option '").append(this.option).append('\'');
        if (this.longOption != null) {
            stringBuilder.append('\'').append(this.longOption).append('\'');
        }
        stringBuilder.append(": ").append(this.deprecated);
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[ ");
        stringBuilder.append("Option ");
        stringBuilder.append(this.option);
        if (this.longOption != null) {
            stringBuilder.append(' ').append(this.longOption);
        }
        if (this.isDeprecated()) {
            stringBuilder.append(' ');
            stringBuilder.append(this.deprecated.toString());
        }
        if (this.hasArgs()) {
            stringBuilder.append("[ARG...]");
        } else if (this.hasArg()) {
            stringBuilder.append(" [ARG]");
        }
        return stringBuilder.append(" :: ").append(this.description).append(" :: ").append(this.type).append(" ]").toString();
    }

    /* synthetic */ Option(Option$Builder option$Builder, Option$1 option$1) {
        this(option$Builder);
    }
}

