/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

final class OptionValidator {
    static final char[] ADDITIONAL_OPTION_CHARS = new char[]{'?', '@'};
    static final char[] ADDITIONAL_LONG_CHARS = new char[]{'-'};

    OptionValidator() {
    }

    private static boolean isValidChar(char c2) {
        return Character.isJavaIdentifierPart(c2) || OptionValidator.search(ADDITIONAL_LONG_CHARS, c2);
    }

    private static boolean isValidOpt(char c2) {
        return Character.isJavaIdentifierPart(c2) || OptionValidator.search(ADDITIONAL_OPTION_CHARS, c2);
    }

    private static boolean search(char[] cArray, char c2) {
        for (char c3 : cArray) {
            if (c3 != c2) continue;
            return true;
        }
        return false;
    }

    static String validate(String string) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Empty option name.");
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray[0];
        if (!OptionValidator.isValidOpt((char)n2)) {
            throw new IllegalArgumentException(String.format("Illegal option name '%s'.", Character.valueOf((char)n2)));
        }
        if (string.length() > 1) {
            for (n2 = 1; n2 < cArray.length; ++n2) {
                char c2 = cArray[n2];
                if (OptionValidator.isValidChar(c2)) continue;
                throw new IllegalArgumentException(String.format("The option '%s' contains an illegal character : '%s'.", string, Character.valueOf(c2)));
            }
        }
        return string;
    }
}

