/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.help;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.help.AbstractHelpFormatter$Builder;
import org.apache.commons.cli.help.HelpAppendable;
import org.apache.commons.cli.help.OptionFormatter;
import org.apache.commons.cli.help.OptionFormatter$Builder;
import org.apache.commons.cli.help.TableDefinition;
import org.apache.commons.cli.help.Util;

public abstract class AbstractHelpFormatter {
    public static final Comparator<Option> DEFAULT_COMPARATOR = (option, option2) -> option.getKey().compareToIgnoreCase(option2.getKey());
    public static final String DEFAULT_OPTION_GROUP_SEPARATOR = " | ";
    public static final String DEFAULT_SYNTAX_PREFIX = "usage: ";
    private final Comparator<Option> comparator;
    private final HelpAppendable helpAppendable;
    private final OptionFormatter$Builder optionFormatBuilder;
    private final String optionGroupSeparator;
    private String syntaxPrefix = "usage: ";

    protected AbstractHelpFormatter(AbstractHelpFormatter$Builder<?, ?> abstractHelpFormatter$Builder) {
        this.helpAppendable = Objects.requireNonNull(abstractHelpFormatter$Builder.getHelpAppendable(), "helpAppendable");
        this.optionFormatBuilder = Objects.requireNonNull(abstractHelpFormatter$Builder.getOptionFormatBuilder(), "optionFormatBuilder");
        this.comparator = Objects.requireNonNull(abstractHelpFormatter$Builder.getComparator(), "comparator");
        this.optionGroupSeparator = Util.defaultValue(abstractHelpFormatter$Builder.getOptionGroupSeparator(), "");
    }

    protected Comparator<Option> getComparator() {
        return this.comparator;
    }

    protected HelpAppendable getHelpAppendable() {
        return this.helpAppendable;
    }

    protected OptionFormatter$Builder getOptionFormatBuilder() {
        return this.optionFormatBuilder;
    }

    public final OptionFormatter getOptionFormatter(Option option) {
        return this.optionFormatBuilder.build(option);
    }

    protected String getOptionGroupSeparator() {
        return this.optionGroupSeparator;
    }

    public final HelpAppendable getSerializer() {
        return this.helpAppendable;
    }

    public final String getSyntaxPrefix() {
        return this.syntaxPrefix;
    }

    protected abstract TableDefinition getTableDefinition(Iterable<Option> var1);

    public void printHelp(String string, String string2, Iterable<Option> iterable, String string3, boolean bl2) throws IOException {
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("cmdLineSyntax not provided");
        }
        if (bl2) {
            this.helpAppendable.appendParagraphFormat("%s %s %s", this.syntaxPrefix, string, this.toSyntaxOptions(iterable));
        } else {
            this.helpAppendable.appendParagraphFormat("%s %s", this.syntaxPrefix, string);
        }
        if (!Util.isEmpty(string2)) {
            this.helpAppendable.appendParagraph(string2);
        }
        this.helpAppendable.appendTable(this.getTableDefinition(iterable));
        if (!Util.isEmpty(string3)) {
            this.helpAppendable.appendParagraph(string3);
        }
    }

    public final void printHelp(String string, String string2, Options options, String string3, boolean bl2) throws IOException {
        this.printHelp(string, string2, options.getOptions(), string3, bl2);
    }

    public final void printOptions(Iterable<Option> iterable) throws IOException {
        AbstractHelpFormatter abstractHelpFormatter = this;
        abstractHelpFormatter.printOptions(abstractHelpFormatter.getTableDefinition(iterable));
    }

    public final void printOptions(Options options) throws IOException {
        this.printOptions(options.getOptions());
    }

    public final void printOptions(TableDefinition tableDefinition) throws IOException {
        this.helpAppendable.appendTable(tableDefinition);
    }

    public final void setSyntaxPrefix(String string) {
        this.syntaxPrefix = string;
    }

    public List<Option> sort(Iterable<Option> iterable) {
        ArrayList<Option> arrayList = new ArrayList<Option>();
        if (iterable != null) {
            iterable.forEach(arrayList::add);
            arrayList.sort(this.comparator);
        }
        return arrayList;
    }

    public List<Option> sort(Options options) {
        return this.sort(options == null ? null : options.getOptions());
    }

    public final String toArgName(String string) {
        return this.optionFormatBuilder.toArgName(string);
    }

    public String toSyntaxOptions(Iterable<Option> iterable) {
        return this.toSyntaxOptions(iterable, option -> null);
    }

    protected String toSyntaxOptions(Iterable<Option> object, Function<Option, OptionGroup> function) {
        ArrayList<OptionGroup> arrayList = new ArrayList<OptionGroup>();
        object = this.sort((Iterable<Option>)object);
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        object = object.iterator();
        while (object.hasNext()) {
            Option option = (Option)object.next();
            OptionGroup optionGroup = function.apply(option);
            if (optionGroup != null) {
                if (arrayList.contains(optionGroup)) continue;
                arrayList.add(optionGroup);
                stringBuilder.append(string).append(this.toSyntaxOptions(optionGroup));
                string = " ";
                continue;
            }
            stringBuilder.append(string).append(this.optionFormatBuilder.build(option).toSyntaxOption());
            string = " ";
        }
        return stringBuilder.toString();
    }

    public String toSyntaxOptions(OptionGroup optionGroup) {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.sort(optionGroup.getOptions());
        OptionFormatter optionFormatter = null;
        object = object.iterator();
        while (object.hasNext()) {
            optionFormatter = this.optionFormatBuilder.build((Option)object.next());
            stringBuilder.append(optionFormatter.toSyntaxOption(true));
            if (!object.hasNext()) continue;
            stringBuilder.append(this.optionGroupSeparator);
        }
        if (optionFormatter != null) {
            if (optionGroup.isRequired()) {
                return stringBuilder.toString();
            }
            return optionFormatter.toOptional(stringBuilder.toString());
        }
        return "";
    }

    public String toSyntaxOptions(Options options) {
        return this.toSyntaxOptions(options.getOptions(), options::getOptionGroup);
    }
}

