/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.help;

import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.help.OptionFormatter;
import org.apache.commons.cli.help.OptionFormatter$1;
import org.apache.commons.cli.help.Util;

public final class OptionFormatter$Builder
implements Supplier<OptionFormatter> {
    private final String[] argNameDelimiters;
    private String defaultArgName;
    private Function<Option, String> deprecatedFormatFunction;
    private String longOptPrefix;
    private String optPrefix;
    private String optSeparator;
    private String optArgSeparator;
    private final String[] optionalDelimiters;
    private BiFunction<OptionFormatter, Boolean, String> syntaxFormatFunction;

    private OptionFormatter$Builder() {
        this.argNameDelimiters = Arrays.copyOf(OptionFormatter.access$000(), 2);
        this.defaultArgName = "arg";
        this.deprecatedFormatFunction = OptionFormatter.NO_DEPRECATED_FORMAT;
        this.longOptPrefix = "--";
        this.optPrefix = "-";
        this.optSeparator = ", ";
        this.optArgSeparator = " ";
        this.optionalDelimiters = Arrays.copyOf(OptionFormatter.access$100(), 2);
    }

    public OptionFormatter$Builder(OptionFormatter optionFormatter) {
        this.optionalDelimiters = Arrays.copyOf(OptionFormatter.access$200(optionFormatter), 2);
        this.argNameDelimiters = Arrays.copyOf(OptionFormatter.access$300(optionFormatter), 2);
        this.defaultArgName = OptionFormatter.access$400(optionFormatter);
        this.optPrefix = OptionFormatter.access$500(optionFormatter);
        this.longOptPrefix = OptionFormatter.access$600(optionFormatter);
        this.optSeparator = OptionFormatter.access$700(optionFormatter);
        this.deprecatedFormatFunction = OptionFormatter.access$800(optionFormatter);
        this.syntaxFormatFunction = OptionFormatter.access$900(optionFormatter);
    }

    public final OptionFormatter build(Option option) {
        return new OptionFormatter(option, this, null);
    }

    @Override
    public final OptionFormatter get() {
        return null;
    }

    public final OptionFormatter$Builder setArgumentNameDelimiters(String string, String string2) {
        this.argNameDelimiters[0] = Util.defaultValue(string, "");
        this.argNameDelimiters[1] = Util.defaultValue(string2, "");
        return this;
    }

    public final OptionFormatter$Builder setDefaultArgName(String string) {
        this.defaultArgName = Util.defaultValue(string, "arg");
        return this;
    }

    public final OptionFormatter$Builder setDeprecatedFormatFunction(Function<Option, String> function) {
        this.deprecatedFormatFunction = function;
        return this;
    }

    public final OptionFormatter$Builder setLongOptPrefix(String string) {
        this.longOptPrefix = Util.defaultValue(string, "");
        return this;
    }

    public final OptionFormatter$Builder setOptArgSeparator(String string) {
        this.optArgSeparator = Util.defaultValue(string, "");
        return this;
    }

    public final OptionFormatter$Builder setOptionalDelimiters(String string, String string2) {
        this.optionalDelimiters[0] = Util.defaultValue(string, "");
        this.optionalDelimiters[1] = Util.defaultValue(string2, "");
        return this;
    }

    public final OptionFormatter$Builder setOptPrefix(String string) {
        this.optPrefix = Util.defaultValue(string, "");
        return this;
    }

    public final OptionFormatter$Builder setOptSeparator(String string) {
        this.optSeparator = Util.defaultValue(string, "");
        return this;
    }

    public final OptionFormatter$Builder setSyntaxFormatFunction(BiFunction<OptionFormatter, Boolean, String> biFunction) {
        this.syntaxFormatFunction = biFunction;
        return this;
    }

    public final String toArgName(String string) {
        return this.argNameDelimiters[0] + Util.defaultValue(string, "") + this.argNameDelimiters[1];
    }

    /* synthetic */ OptionFormatter$Builder(OptionFormatter$1 optionFormatter$1) {
        this();
    }

    static /* synthetic */ String[] access$1200(OptionFormatter$Builder optionFormatter$Builder) {
        return optionFormatter$Builder.optionalDelimiters;
    }

    static /* synthetic */ String[] access$1300(OptionFormatter$Builder optionFormatter$Builder) {
        return optionFormatter$Builder.argNameDelimiters;
    }

    static /* synthetic */ String access$1400(OptionFormatter$Builder optionFormatter$Builder) {
        return optionFormatter$Builder.defaultArgName;
    }

    static /* synthetic */ String access$1500(OptionFormatter$Builder optionFormatter$Builder) {
        return optionFormatter$Builder.optPrefix;
    }

    static /* synthetic */ String access$1600(OptionFormatter$Builder optionFormatter$Builder) {
        return optionFormatter$Builder.longOptPrefix;
    }

    static /* synthetic */ String access$1700(OptionFormatter$Builder optionFormatter$Builder) {
        return optionFormatter$Builder.optSeparator;
    }

    static /* synthetic */ String access$1800(OptionFormatter$Builder optionFormatter$Builder) {
        return optionFormatter$Builder.optArgSeparator;
    }

    static /* synthetic */ Function access$1900(OptionFormatter$Builder optionFormatter$Builder) {
        return optionFormatter$Builder.deprecatedFormatFunction;
    }

    static /* synthetic */ BiFunction access$2000(OptionFormatter$Builder optionFormatter$Builder) {
        return optionFormatter$Builder.syntaxFormatFunction;
    }
}

