/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.help;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.help.OptionFormatter$1;
import org.apache.commons.cli.help.OptionFormatter$Builder;
import org.apache.commons.cli.help.Util;

public final class OptionFormatter {
    private static final String[] DEFAULT_OPTIONAL_DELIMITERS = new String[]{"[", "]"};
    private static final String[] DEFAULT_ARG_NAME_DELIMITERS = new String[]{"<", ">"};
    public static final String DEFAULT_ARG_NAME = "arg";
    public static final Function<Option, String> SIMPLE_DEPRECATED_FORMAT = option -> "[Deprecated] " + Util.defaultValue(option.getDescription(), "");
    public static final Function<Option, String> COMPLEX_DEPRECATED_FORMAT = option -> {
        StringBuilder stringBuilder = new StringBuilder("[Deprecated");
        DeprecatedAttributes deprecatedAttributes = option.getDeprecated();
        if (deprecatedAttributes.isForRemoval()) {
            stringBuilder.append(" for removal");
        }
        if (!Util.isEmpty(deprecatedAttributes.getSince())) {
            stringBuilder.append(" since ").append(deprecatedAttributes.getSince());
        }
        if (!Util.isEmpty(deprecatedAttributes.getDescription())) {
            stringBuilder.append(". ").append(deprecatedAttributes.getDescription());
        }
        stringBuilder.append("]");
        if (!Util.isEmpty(option.getDescription())) {
            stringBuilder.append(DEFAULT_OPT_ARG_SEPARATOR).append(option.getDescription());
        }
        return stringBuilder.toString();
    };
    public static final Function<Option, String> NO_DEPRECATED_FORMAT = option -> Util.defaultValue(option.getDescription(), "");
    public static final String DEFAULT_SYNTAX_PREFIX = "usage: ";
    public static final String DEFAULT_OPT_PREFIX = "-";
    public static final String DEFAULT_LONG_OPT_PREFIX = "--";
    public static final String DEFAULT_OPT_SEPARATOR = ", ";
    public static final String DEFAULT_OPT_ARG_SEPARATOR = " ";
    private final String[] argNameDelimiters;
    private final String defaultArgName;
    private final Function<Option, String> deprecatedFormatFunction;
    private final String longOptPrefix;
    private final String optPrefix;
    private final String optSeparator;
    private final String optArgSeparator;
    private final String[] optionalDelimiters;
    private final BiFunction<OptionFormatter, Boolean, String> syntaxFormatFunction;
    private final Option option;

    public static OptionFormatter$Builder builder() {
        return new OptionFormatter$Builder(null);
    }

    public static OptionFormatter from(Option option) {
        return new OptionFormatter$Builder(null).build(option);
    }

    private OptionFormatter(Option option, OptionFormatter$Builder optionFormatter$Builder) {
        this.optionalDelimiters = OptionFormatter$Builder.access$1200(optionFormatter$Builder);
        this.argNameDelimiters = OptionFormatter$Builder.access$1300(optionFormatter$Builder);
        this.defaultArgName = OptionFormatter$Builder.access$1400(optionFormatter$Builder);
        this.optPrefix = OptionFormatter$Builder.access$1500(optionFormatter$Builder);
        this.longOptPrefix = OptionFormatter$Builder.access$1600(optionFormatter$Builder);
        this.optSeparator = OptionFormatter$Builder.access$1700(optionFormatter$Builder);
        this.optArgSeparator = OptionFormatter$Builder.access$1800(optionFormatter$Builder);
        this.deprecatedFormatFunction = OptionFormatter$Builder.access$1900(optionFormatter$Builder);
        this.option = option;
        this.syntaxFormatFunction = OptionFormatter$Builder.access$2000(optionFormatter$Builder) != null ? OptionFormatter$Builder.access$2000(optionFormatter$Builder) : (optionFormatter, bl2) -> {
            boolean bl3;
            StringBuilder stringBuilder = new StringBuilder();
            String string = optionFormatter.getArgName();
            stringBuilder.append(Util.defaultValue(optionFormatter.getOpt(), optionFormatter.getLongOpt()));
            if (!Util.isEmpty(string)) {
                stringBuilder.append(this.optArgSeparator).append(string);
            }
            if (bl3 = bl2 == null ? optionFormatter.isRequired() : bl2.booleanValue()) {
                return stringBuilder.toString();
            }
            return optionFormatter.toOptional(stringBuilder.toString());
        };
    }

    public final String getArgName() {
        if (this.option.hasArg()) {
            return this.argNameDelimiters[0] + Util.defaultValue(this.option.getArgName(), this.defaultArgName) + this.argNameDelimiters[1];
        }
        return "";
    }

    public final String getBothOpt() {
        String string = this.getLongOpt();
        StringBuilder stringBuilder = new StringBuilder(this.getOpt());
        if (stringBuilder.length() > 0 && !Util.isEmpty(string)) {
            stringBuilder.append(this.optSeparator);
        }
        return stringBuilder.append(this.getLongOpt()).toString();
    }

    public final String getDescription() {
        if (this.option.isDeprecated()) {
            return this.deprecatedFormatFunction.apply(this.option);
        }
        return Util.defaultValue(this.option.getDescription(), "");
    }

    public final String getLongOpt() {
        if (Util.isEmpty(this.option.getLongOpt())) {
            return "";
        }
        return this.longOptPrefix + this.option.getLongOpt();
    }

    public final String getOpt() {
        if (Util.isEmpty(this.option.getOpt())) {
            return "";
        }
        return this.optPrefix + this.option.getOpt();
    }

    public final String getSince() {
        return Util.defaultValue(this.option.getSince(), DEFAULT_LONG_OPT_PREFIX);
    }

    public final boolean isRequired() {
        return this.option.isRequired();
    }

    public final String toOptional(String string) {
        if (Util.isEmpty(string)) {
            return "";
        }
        return this.optionalDelimiters[0] + string + this.optionalDelimiters[1];
    }

    public final String toSyntaxOption() {
        OptionFormatter optionFormatter = this;
        return optionFormatter.toSyntaxOption(optionFormatter.isRequired());
    }

    public final String toSyntaxOption(boolean bl2) {
        return this.syntaxFormatFunction.apply(this, bl2);
    }

    static /* synthetic */ String[] access$000() {
        return DEFAULT_ARG_NAME_DELIMITERS;
    }

    static /* synthetic */ String[] access$100() {
        return DEFAULT_OPTIONAL_DELIMITERS;
    }

    static /* synthetic */ String[] access$200(OptionFormatter optionFormatter) {
        return optionFormatter.optionalDelimiters;
    }

    static /* synthetic */ String[] access$300(OptionFormatter optionFormatter) {
        return optionFormatter.argNameDelimiters;
    }

    static /* synthetic */ String access$400(OptionFormatter optionFormatter) {
        return optionFormatter.defaultArgName;
    }

    static /* synthetic */ String access$500(OptionFormatter optionFormatter) {
        return optionFormatter.optPrefix;
    }

    static /* synthetic */ String access$600(OptionFormatter optionFormatter) {
        return optionFormatter.longOptPrefix;
    }

    static /* synthetic */ String access$700(OptionFormatter optionFormatter) {
        return optionFormatter.optSeparator;
    }

    static /* synthetic */ Function access$800(OptionFormatter optionFormatter) {
        return optionFormatter.deprecatedFormatFunction;
    }

    static /* synthetic */ BiFunction access$900(OptionFormatter optionFormatter) {
        return optionFormatter.syntaxFormatFunction;
    }

    /* synthetic */ OptionFormatter(Option option, OptionFormatter$Builder optionFormatter$Builder, OptionFormatter$1 optionFormatter$1) {
        this(option, optionFormatter$Builder);
    }
}

