/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.help;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.cli.help.FilterHelpAppendable;
import org.apache.commons.cli.help.TableDefinition;
import org.apache.commons.cli.help.TextStyle;
import org.apache.commons.cli.help.TextStyle$Alignment;
import org.apache.commons.cli.help.TextStyle$Builder;
import org.apache.commons.cli.help.Util;

public class TextHelpAppendable
extends FilterHelpAppendable {
    public static final int DEFAULT_WIDTH = 74;
    public static final int DEFAULT_LEFT_PAD = 1;
    public static final int DEFAULT_INDENT = 3;
    public static final int DEFAULT_LIST_INDENT = 7;
    private static final String BLANK_LINE = "";
    private static final Set<Character> BREAK_CHAR_SET = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\f'), Character.valueOf('\r'), Character.valueOf('\r'), Character.valueOf('\u000e'), Character.valueOf('\u000b'), Character.valueOf('\u001c'), Character.valueOf('\u001d'), Character.valueOf('\u001e'), Character.valueOf('\u001f'))));
    private final TextStyle$Builder textStyleBuilder = TextStyle.builder().setMaxWidth(74).setLeftPad(1).setIndent(3);

    public static int indexOfWrap(CharSequence charSequence, int n2, int n3) {
        int n4;
        if (n2 <= 0) {
            throw new IllegalArgumentException("Width must be greater than 0");
        }
        int n5 = Math.min(n3 + n2, charSequence.length() - 1);
        for (n4 = n3; n4 < n5; ++n4) {
            if (!BREAK_CHAR_SET.contains(Character.valueOf(charSequence.charAt(n4)))) continue;
            return n4;
        }
        if (n3 + n2 >= charSequence.length()) {
            return charSequence.length();
        }
        for (n4 = n5; n4 >= n3 && !Util.isWhitespace(charSequence.charAt(n4)); --n4) {
        }
        if (n4 > n3) {
            return n4;
        }
        return n5 - 1;
    }

    protected static TextHelpAppendable systemOut() {
        return new TextHelpAppendable(System.out);
    }

    public TextHelpAppendable(Appendable appendable) {
        super(appendable);
    }

    /*
     * WARNING - void declaration
     */
    protected TableDefinition adjustTableFormat(TableDefinition tableDefinition) {
        void textStyle$Builder;
        int n2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n2 = 0; n2 < tableDefinition.columnTextStyles().size(); ++n2) {
            TextStyle n3 = tableDefinition.columnTextStyles().get(n2);
            TextStyle$Builder textStyle$Builder2 = TextStyle.builder().setTextStyle(n3);
            arrayList.add(textStyle$Builder2);
            Object object = tableDefinition.headers().get(n2);
            if (n3.getMaxWidth() < ((String)object).length() || n3.getMaxWidth() == Integer.MAX_VALUE) {
                textStyle$Builder2.setMaxWidth(((String)object).length());
            }
            if (n3.getMinWidth() < ((String)object).length()) {
                textStyle$Builder2.setMinWidth(((String)object).length());
            }
            for (List<String> list : tableDefinition.rows()) {
                object = list.get(n2);
                if (((String)object).length() <= textStyle$Builder2.getMaxWidth()) continue;
                textStyle$Builder2.setMaxWidth(((String)object).length());
            }
        }
        n2 = 0;
        int n3 = this.textStyleBuilder.getMaxWidth();
        for (Object object : arrayList) {
            textStyle$Builder -= ((TextStyle$Builder)object).getLeftPad();
            if (((TextStyle$Builder)object).isScalable()) {
                n2 += ((TextStyle$Builder)object).getMaxWidth();
                continue;
            }
            textStyle$Builder -= ((TextStyle$Builder)object).getMaxWidth();
        }
        if (n2 > textStyle$Builder) {
            void var4_9;
            double d2 = (double)textStyle$Builder / (double)n2;
            boolean bl2 = false;
            while (var4_9 < arrayList.size()) {
                TextStyle$Builder textStyle$Builder3 = (TextStyle$Builder)arrayList.get((int)var4_9);
                if (textStyle$Builder3.isScalable()) {
                    arrayList.set((int)var4_9, this.resize(textStyle$Builder3, d2));
                }
                ++var4_9;
            }
        }
        ArrayList<TextStyle> arrayList2 = new ArrayList<TextStyle>();
        for (TextStyle$Builder textStyle$Builder4 : arrayList) {
            arrayList2.add(textStyle$Builder4.get());
        }
        return TableDefinition.from(tableDefinition.caption(), arrayList2, tableDefinition.headers(), tableDefinition.rows());
    }

    @Override
    public void appendHeader(int n2, CharSequence charSequence) throws IOException {
        if (!Util.isEmpty(charSequence)) {
            if (n2 <= 0) {
                throw new IllegalArgumentException("level must be at least 1");
            }
            char[] cArray = new char[]{'=', '%', '+', '_'};
            n2 = Math.min(n2, cArray.length) - 1;
            TextStyle textStyle = this.textStyleBuilder.get();
            Queue<String> queue = this.makeColumnQueue(charSequence, textStyle);
            queue.add(Util.repeatSpace(textStyle.getLeftPad()) + Util.repeat(Math.min(charSequence.length(), textStyle.getMaxWidth()), cArray[n2]));
            queue.add(BLANK_LINE);
            this.printQueue(queue);
        }
    }

    @Override
    public void appendList(boolean bl2, Collection<CharSequence> object) throws IOException {
        if (object != null && !object.isEmpty()) {
            TextStyle$Builder textStyle$Builder = TextStyle.builder().setLeftPad(this.textStyleBuilder.getLeftPad()).setIndent(7);
            int n2 = 1;
            object = object.iterator();
            while (object.hasNext()) {
                CharSequence charSequence = (CharSequence)object.next();
                charSequence = bl2 ? String.format(" %s. %s", n2++, Util.defaultValue(charSequence, BLANK_LINE)) : String.format(" * %s", Util.defaultValue(charSequence, BLANK_LINE));
                textStyle$Builder.setMaxWidth(Math.min(this.textStyleBuilder.getMaxWidth(), ((String)charSequence).length()));
                TextHelpAppendable textHelpAppendable = this;
                textHelpAppendable.printQueue(textHelpAppendable.makeColumnQueue(charSequence, textStyle$Builder.get()));
            }
            this.output.append(System.lineSeparator());
        }
    }

    @Override
    public void appendParagraph(CharSequence object) throws IOException {
        if (!Util.isEmpty((CharSequence)object)) {
            object = this.makeColumnQueue((CharSequence)object, this.textStyleBuilder.get());
            object.add((String)BLANK_LINE);
            this.printQueue((Queue<String>)object);
        }
    }

    @Override
    public void appendTable(TableDefinition tableDefinition) throws IOException {
        tableDefinition = this.adjustTableFormat(tableDefinition);
        this.appendParagraph(tableDefinition.caption());
        ArrayList<TextStyle> arrayList = new ArrayList<TextStyle>();
        for (TextStyle object : tableDefinition.columnTextStyles()) {
            arrayList.add(TextStyle.builder().setTextStyle(object).setAlignment(TextStyle$Alignment.CENTER).get());
        }
        TextHelpAppendable textHelpAppendable = this;
        textHelpAppendable.writeColumnQueues(textHelpAppendable.makeColumnQueues(tableDefinition.headers(), arrayList), arrayList);
        for (List list : tableDefinition.rows()) {
            TextHelpAppendable textHelpAppendable2 = this;
            textHelpAppendable2.writeColumnQueues(textHelpAppendable2.makeColumnQueues(list, tableDefinition.columnTextStyles()), tableDefinition.columnTextStyles());
        }
        this.output.append(System.lineSeparator());
    }

    @Override
    public void appendTitle(CharSequence charSequence) throws IOException {
        if (!Util.isEmpty(charSequence)) {
            TextStyle textStyle = this.textStyleBuilder.get();
            Queue<String> queue = this.makeColumnQueue(charSequence, textStyle);
            queue.add(Util.repeatSpace(textStyle.getLeftPad()) + Util.repeat(Math.min(charSequence.length(), textStyle.getMaxWidth()), '#'));
            queue.add(BLANK_LINE);
            this.printQueue(queue);
        }
    }

    public int getIndent() {
        return this.textStyleBuilder.getIndent();
    }

    public int getLeftPad() {
        return this.textStyleBuilder.getLeftPad();
    }

    public int getMaxWidth() {
        return this.textStyleBuilder.getMaxWidth();
    }

    public TextStyle$Builder getTextStyleBuilder() {
        return this.textStyleBuilder;
    }

    protected Queue<String> makeColumnQueue(CharSequence charSequence, TextStyle textStyle) {
        String string = Util.repeatSpace(textStyle.getLeftPad());
        String string2 = Util.repeatSpace(textStyle.getIndent());
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = 0;
        int n3 = textStyle.getMaxWidth() - string2.length();
        while (n2 < charSequence.length()) {
            int n4 = n2 == 0 ? textStyle.getMaxWidth() : n3;
            n4 = TextHelpAppendable.indexOfWrap(charSequence, n4, n2);
            CharSequence charSequence2 = charSequence.subSequence(n2, n4);
            linkedList.add(string + textStyle.pad(n2 > 0, charSequence2));
            n2 = Util.indexOfNonWhitespace(charSequence, n4);
            n2 = n2 == -1 ? n4 : n2;
        }
        return linkedList;
    }

    protected List<Queue<String>> makeColumnQueues(List<String> list, List<TextStyle> list2) {
        ArrayList<Queue<String>> arrayList = new ArrayList<Queue<String>>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            arrayList.add(this.makeColumnQueue(list.get(i2), list2.get(i2)));
        }
        return arrayList;
    }

    private void printQueue(Queue<String> object) throws IOException {
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            this.appendFormat("%s%n", Util.rtrim(string));
        }
    }

    public void printWrapped(String string) throws IOException {
        TextHelpAppendable textHelpAppendable = this;
        textHelpAppendable.printQueue(textHelpAppendable.makeColumnQueue(string, this.textStyleBuilder.get()));
    }

    public void printWrapped(String string, TextStyle textStyle) throws IOException {
        TextHelpAppendable textHelpAppendable = this;
        textHelpAppendable.printQueue(textHelpAppendable.makeColumnQueue(string, textStyle));
    }

    private int resize(int n2, double d2) {
        return (int)((double)n2 * d2);
    }

    protected TextStyle$Builder resize(TextStyle$Builder textStyle$Builder, double d2) {
        double d3 = (double)textStyle$Builder.getIndent() / (double)textStyle$Builder.getMaxWidth();
        textStyle$Builder.setMaxWidth(Math.max(this.resize(textStyle$Builder.getMaxWidth(), d2), textStyle$Builder.getMinWidth()));
        int n2 = textStyle$Builder.getMaxWidth() / 3;
        int n3 = textStyle$Builder.getMaxWidth() == 1 ? 0 : textStyle$Builder.getIndent();
        if (n3 > n2) {
            n3 = Math.min(this.resize(textStyle$Builder.getIndent(), d3), n2);
        }
        textStyle$Builder.setIndent(n3);
        return textStyle$Builder;
    }

    public void setIndent(int n2) {
        this.textStyleBuilder.setIndent(n2);
    }

    public void setLeftPad(int n2) {
        this.textStyleBuilder.setLeftPad(n2);
    }

    public void setMaxWidth(int n2) {
        this.textStyleBuilder.setMaxWidth(n2);
    }

    protected void writeColumnQueues(List<Queue<String>> list, List<TextStyle> list2) throws IOException {
        boolean bl2 = true;
        String string = Util.repeatSpace(this.textStyleBuilder.get().getLeftPad());
        while (bl2) {
            this.output.append(string);
            bl2 = false;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                TextStyle textStyle = list2.get(i2);
                Queue<String> queue = list.get(i2);
                String string2 = queue.poll();
                if (Util.isEmpty(string2)) {
                    this.output.append(Util.repeatSpace(textStyle.getMaxWidth() + textStyle.getLeftPad()));
                } else {
                    this.output.append(string2);
                }
                bl2 |= !queue.isEmpty();
            }
            this.output.append(System.lineSeparator());
        }
    }
}

