/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.MurmurHash;

public final class MurmurHash2 {
    private static final int M32 = 1540483477;
    private static final int R32 = 24;
    private static final long M64 = -4132994306676758123L;
    private static final int R64 = 47;

    public static int hash32(byte[] byArray, int n2) {
        return MurmurHash2.hash32(byArray, n2, -1756908916);
    }

    public static int hash32(byte[] byArray, int n2, int n3) {
        int n4;
        n3 ^= n2;
        int n5 = n2 >> 2;
        for (n4 = 0; n4 < n5; ++n4) {
            int n6 = n4 << 2;
            n6 = MurmurHash.getLittleEndianInt(byArray, n6);
            n6 *= 1540483477;
            n6 ^= n6 >>> 24;
            n3 *= 1540483477;
            n3 ^= (n6 *= 1540483477);
        }
        n4 = n5 << 2;
        switch (n2 - n4) {
            case 3: {
                n3 ^= (byArray[n4 + 2] & 0xFF) << 16;
            }
            case 2: {
                n3 ^= (byArray[n4 + 1] & 0xFF) << 8;
            }
            case 1: {
                n3 ^= byArray[n4] & 0xFF;
                n3 *= 1540483477;
            }
        }
        int n7 = n3;
        n3 = n7 ^ n7 >>> 13;
        n3 *= 1540483477;
        n3 ^= n3 >>> 15;
        return n3;
    }

    public static int hash32(String object) {
        byte[] byArray = StringUtils.getBytesUtf8((String)object);
        object = byArray;
        return MurmurHash2.hash32(byArray, ((Object)object).length);
    }

    public static int hash32(String string, int n2, int n3) {
        int n4 = n2;
        return MurmurHash2.hash32(string.substring(n4, n4 + n3));
    }

    public static long hash64(byte[] byArray, int n2) {
        return MurmurHash2.hash64(byArray, n2, -512093083);
    }

    public static long hash64(byte[] byArray, int n2, int n3) {
        int n4;
        long l2 = (long)n3 & 0xFFFFFFFFL ^ (long)n2 * -4132994306676758123L;
        n3 = n2 >> 3;
        for (n4 = 0; n4 < n3; ++n4) {
            int n5 = n4 << 3;
            long l3 = MurmurHash.getLittleEndianLong(byArray, n5);
            l3 *= -4132994306676758123L;
            l3 ^= l3 >>> 47;
            l2 ^= (l3 *= -4132994306676758123L);
            l2 *= -4132994306676758123L;
        }
        n4 = n3 << 3;
        switch (n2 - n4) {
            case 7: {
                l2 ^= ((long)byArray[n4 + 6] & 0xFFL) << 48;
            }
            case 6: {
                l2 ^= ((long)byArray[n4 + 5] & 0xFFL) << 40;
            }
            case 5: {
                l2 ^= ((long)byArray[n4 + 4] & 0xFFL) << 32;
            }
            case 4: {
                l2 ^= ((long)byArray[n4 + 3] & 0xFFL) << 24;
            }
            case 3: {
                l2 ^= ((long)byArray[n4 + 2] & 0xFFL) << 16;
            }
            case 2: {
                l2 ^= ((long)byArray[n4 + 1] & 0xFFL) << 8;
            }
            case 1: {
                l2 ^= (long)byArray[n4] & 0xFFL;
                l2 *= -4132994306676758123L;
            }
        }
        long l4 = l2;
        l2 = l4 ^ l4 >>> 47;
        l2 *= -4132994306676758123L;
        l2 ^= l2 >>> 47;
        return l2;
    }

    public static long hash64(String object) {
        byte[] byArray = StringUtils.getBytesUtf8((String)object);
        object = byArray;
        return MurmurHash2.hash64(byArray, ((Object)object).length);
    }

    public static long hash64(String string, int n2, int n3) {
        int n4 = n2;
        return MurmurHash2.hash64(string.substring(n4, n4 + n3));
    }

    private MurmurHash2() {
    }
}

