/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import java.util.Locale;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.language.DoubleMetaphone$DoubleMetaphoneResult;

public class DoubleMetaphone
implements StringEncoder {
    private static final String VOWELS = "AEIOUY";
    private static final String[] SILENT_START = new String[]{"GN", "KN", "PN", "WR", "PS"};
    private static final String[] L_R_N_M_B_H_F_V_W_SPACE = new String[]{"L", "R", "N", "M", "B", "H", "F", "V", "W", " "};
    private static final String[] ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER = new String[]{"ES", "EP", "EB", "EL", "EY", "IB", "IL", "IN", "IE", "EI", "ER"};
    private static final String[] L_T_K_S_N_M_B_Z = new String[]{"L", "T", "K", "S", "N", "M", "B", "Z"};
    private int maxCodeLen = 4;

    protected static boolean contains(String string, int n2, int n3, String ... stringArray) {
        boolean bl2 = false;
        if (n2 >= 0 && n2 + n3 <= string.length()) {
            int n4 = n2;
            string = string.substring(n4, n4 + n3);
            String[] stringArray2 = stringArray;
            n3 = stringArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                String string2 = stringArray2[i2];
                if (!string.equals(string2)) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    protected char charAt(String string, int n2) {
        if (n2 < 0 || n2 >= string.length()) {
            return '\u0000';
        }
        return string.charAt(n2);
    }

    private String cleanInput(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).isEmpty()) {
            return null;
        }
        return string.toUpperCase(Locale.ENGLISH);
    }

    private boolean conditionC0(String string, int n2) {
        if (DoubleMetaphone.contains(string, n2, 4, "CHIA")) {
            return true;
        }
        if (n2 <= 1) {
            return false;
        }
        DoubleMetaphone doubleMetaphone = this;
        if (doubleMetaphone.isVowel(doubleMetaphone.charAt(string, n2 - 2))) {
            return false;
        }
        if (!DoubleMetaphone.contains(string, n2 - 1, 3, "ACH")) {
            return false;
        }
        char c2 = this.charAt(string, n2 + 2);
        return c2 != 'I' && c2 != 'E' || DoubleMetaphone.contains(string, n2 - 2, 6, "BACHER", "MACHER");
    }

    private boolean conditionCH0(String string, int n2) {
        if (n2 != 0) {
            return false;
        }
        if (!DoubleMetaphone.contains(string, n2 + 1, 5, "HARAC", "HARIS") && !DoubleMetaphone.contains(string, n2 + 1, 3, "HOR", "HYM", "HIA", "HEM")) {
            return false;
        }
        return !DoubleMetaphone.contains(string, 0, 5, "CHORE");
    }

    private boolean conditionCH1(String string, int n2) {
        return DoubleMetaphone.contains(string, 0, 4, "VAN ", "VON ") || DoubleMetaphone.contains(string, 0, 3, "SCH") || DoubleMetaphone.contains(string, n2 - 2, 6, "ORCHES", "ARCHIT", "ORCHID") || DoubleMetaphone.contains(string, n2 + 2, 1, "T", "S") || (DoubleMetaphone.contains(string, n2 - 1, 1, "A", "O", "U", "E") || n2 == 0) && (DoubleMetaphone.contains(string, n2 + 2, 1, L_R_N_M_B_H_F_V_W_SPACE) || n2 + 1 == string.length() - 1);
    }

    private boolean conditionL0(String string, int n2) {
        block6: {
            block5: {
                if (n2 == string.length() - 3 && DoubleMetaphone.contains(string, n2 - 1, 4, "ILLO", "ILLA", "ALLE")) {
                    return true;
                }
                String string2 = string;
                if (DoubleMetaphone.contains(string2, string2.length() - 2, 2, "AS", "OS")) break block5;
                String string3 = string;
                if (!DoubleMetaphone.contains(string3, string3.length() - 1, 1, "A", "O")) break block6;
            }
            if (DoubleMetaphone.contains(string, n2 - 1, 4, "ALLE")) {
                return true;
            }
        }
        return false;
    }

    private boolean conditionM0(String string, int n2) {
        if (this.charAt(string, n2 + 1) == 'M') {
            return true;
        }
        return DoubleMetaphone.contains(string, n2 - 1, 3, "UMB") && (n2 + 1 == string.length() - 1 || DoubleMetaphone.contains(string, n2 + 2, 2, "ER"));
    }

    public String doubleMetaphone(String string) {
        return this.doubleMetaphone(string, false);
    }

    public String doubleMetaphone(String string, boolean bl2) {
        if ((string = this.cleanInput(string)) == null) {
            return null;
        }
        boolean bl3 = this.isSlavoGermanic(string);
        int n2 = this.isSilentStart(string) ? 1 : 0;
        DoubleMetaphone doubleMetaphone = this;
        DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult = new DoubleMetaphone$DoubleMetaphoneResult(doubleMetaphone, doubleMetaphone.getMaxCodeLen());
        block25: while (!doubleMetaphone$DoubleMetaphoneResult.isComplete() && n2 <= string.length() - 1) {
            switch (string.charAt(n2)) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'Y': {
                    n2 = this.handleAEIOUY(doubleMetaphone$DoubleMetaphoneResult, n2);
                    continue block25;
                }
                case 'B': {
                    doubleMetaphone$DoubleMetaphoneResult.append('P');
                    n2 = this.charAt(string, n2 + 1) == 'B' ? n2 + 2 : n2 + 1;
                    continue block25;
                }
                case '\u00c7': {
                    doubleMetaphone$DoubleMetaphoneResult.append('S');
                    ++n2;
                    continue block25;
                }
                case 'C': {
                    n2 = this.handleC(string, doubleMetaphone$DoubleMetaphoneResult, n2);
                    continue block25;
                }
                case 'D': {
                    n2 = this.handleD(string, doubleMetaphone$DoubleMetaphoneResult, n2);
                    continue block25;
                }
                case 'F': {
                    doubleMetaphone$DoubleMetaphoneResult.append('F');
                    n2 = this.charAt(string, n2 + 1) == 'F' ? n2 + 2 : n2 + 1;
                    continue block25;
                }
                case 'G': {
                    n2 = this.handleG(string, doubleMetaphone$DoubleMetaphoneResult, n2, bl3);
                    continue block25;
                }
                case 'H': {
                    n2 = this.handleH(string, doubleMetaphone$DoubleMetaphoneResult, n2);
                    continue block25;
                }
                case 'J': {
                    n2 = this.handleJ(string, doubleMetaphone$DoubleMetaphoneResult, n2, bl3);
                    continue block25;
                }
                case 'K': {
                    doubleMetaphone$DoubleMetaphoneResult.append('K');
                    n2 = this.charAt(string, n2 + 1) == 'K' ? n2 + 2 : n2 + 1;
                    continue block25;
                }
                case 'L': {
                    n2 = this.handleL(string, doubleMetaphone$DoubleMetaphoneResult, n2);
                    continue block25;
                }
                case 'M': {
                    doubleMetaphone$DoubleMetaphoneResult.append('M');
                    n2 = this.conditionM0(string, n2) ? n2 + 2 : n2 + 1;
                    continue block25;
                }
                case 'N': {
                    doubleMetaphone$DoubleMetaphoneResult.append('N');
                    n2 = this.charAt(string, n2 + 1) == 'N' ? n2 + 2 : n2 + 1;
                    continue block25;
                }
                case '\u00d1': {
                    doubleMetaphone$DoubleMetaphoneResult.append('N');
                    ++n2;
                    continue block25;
                }
                case 'P': {
                    n2 = this.handleP(string, doubleMetaphone$DoubleMetaphoneResult, n2);
                    continue block25;
                }
                case 'Q': {
                    doubleMetaphone$DoubleMetaphoneResult.append('K');
                    n2 = this.charAt(string, n2 + 1) == 'Q' ? n2 + 2 : n2 + 1;
                    continue block25;
                }
                case 'R': {
                    n2 = this.handleR(string, doubleMetaphone$DoubleMetaphoneResult, n2, bl3);
                    continue block25;
                }
                case 'S': {
                    n2 = this.handleS(string, doubleMetaphone$DoubleMetaphoneResult, n2, bl3);
                    continue block25;
                }
                case 'T': {
                    n2 = this.handleT(string, doubleMetaphone$DoubleMetaphoneResult, n2);
                    continue block25;
                }
                case 'V': {
                    doubleMetaphone$DoubleMetaphoneResult.append('F');
                    n2 = this.charAt(string, n2 + 1) == 'V' ? n2 + 2 : n2 + 1;
                    continue block25;
                }
                case 'W': {
                    n2 = this.handleW(string, doubleMetaphone$DoubleMetaphoneResult, n2);
                    continue block25;
                }
                case 'X': {
                    n2 = this.handleX(string, doubleMetaphone$DoubleMetaphoneResult, n2);
                    continue block25;
                }
                case 'Z': {
                    n2 = this.handleZ(string, doubleMetaphone$DoubleMetaphoneResult, n2, bl3);
                    continue block25;
                }
            }
            ++n2;
        }
        if (bl2) {
            return doubleMetaphone$DoubleMetaphoneResult.getAlternate();
        }
        return doubleMetaphone$DoubleMetaphoneResult.getPrimary();
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof String)) {
            throw new EncoderException("DoubleMetaphone encode parameter is not of type String");
        }
        return this.doubleMetaphone((String)object);
    }

    @Override
    public String encode(String string) {
        return this.doubleMetaphone(string);
    }

    public int getMaxCodeLen() {
        return this.maxCodeLen;
    }

    private int handleAEIOUY(DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n2) {
        if (n2 == 0) {
            doubleMetaphone$DoubleMetaphoneResult.append('A');
        }
        return n2 + 1;
    }

    private int handleC(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n2) {
        if (this.conditionC0(string, n2)) {
            doubleMetaphone$DoubleMetaphoneResult.append('K');
            n2 += 2;
        } else if (n2 == 0 && DoubleMetaphone.contains(string, n2, 6, "CAESAR")) {
            doubleMetaphone$DoubleMetaphoneResult.append('S');
            n2 += 2;
        } else if (DoubleMetaphone.contains(string, n2, 2, "CH")) {
            n2 = this.handleCH(string, doubleMetaphone$DoubleMetaphoneResult, n2);
        } else if (DoubleMetaphone.contains(string, n2, 2, "CZ") && !DoubleMetaphone.contains(string, n2 - 2, 4, "WICZ")) {
            doubleMetaphone$DoubleMetaphoneResult.append('S', 'X');
            n2 += 2;
        } else if (DoubleMetaphone.contains(string, n2 + 1, 3, "CIA")) {
            doubleMetaphone$DoubleMetaphoneResult.append('X');
            n2 += 3;
        } else {
            if (DoubleMetaphone.contains(string, n2, 2, "CC") && (n2 != 1 || this.charAt(string, 0) != 'M')) {
                return this.handleCC(string, doubleMetaphone$DoubleMetaphoneResult, n2);
            }
            if (DoubleMetaphone.contains(string, n2, 2, "CK", "CG", "CQ")) {
                doubleMetaphone$DoubleMetaphoneResult.append('K');
                n2 += 2;
            } else if (DoubleMetaphone.contains(string, n2, 2, "CI", "CE", "CY")) {
                if (DoubleMetaphone.contains(string, n2, 3, "CIO", "CIE", "CIA")) {
                    doubleMetaphone$DoubleMetaphoneResult.append('S', 'X');
                } else {
                    doubleMetaphone$DoubleMetaphoneResult.append('S');
                }
                n2 += 2;
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('K');
                n2 = DoubleMetaphone.contains(string, n2 + 1, 2, " C", " Q", " G") ? (n2 += 3) : (DoubleMetaphone.contains(string, n2 + 1, 1, "C", "K", "Q") && !DoubleMetaphone.contains(string, n2 + 1, 2, "CE", "CI") ? (n2 += 2) : ++n2);
            }
        }
        return n2;
    }

    private int handleCC(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n2) {
        if (DoubleMetaphone.contains(string, n2 + 2, 1, "I", "E", "H") && !DoubleMetaphone.contains(string, n2 + 2, 2, "HU")) {
            if (n2 == 1 && this.charAt(string, n2 - 1) == 'A' || DoubleMetaphone.contains(string, n2 - 1, 5, "UCCEE", "UCCES")) {
                doubleMetaphone$DoubleMetaphoneResult.append("KS");
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('X');
            }
            n2 += 3;
        } else {
            doubleMetaphone$DoubleMetaphoneResult.append('K');
            n2 += 2;
        }
        return n2;
    }

    private int handleCH(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n2) {
        if (n2 > 0 && DoubleMetaphone.contains(string, n2, 4, "CHAE")) {
            doubleMetaphone$DoubleMetaphoneResult.append('K', 'X');
            return n2 + 2;
        }
        if (this.conditionCH0(string, n2)) {
            doubleMetaphone$DoubleMetaphoneResult.append('K');
            return n2 + 2;
        }
        if (this.conditionCH1(string, n2)) {
            doubleMetaphone$DoubleMetaphoneResult.append('K');
            return n2 + 2;
        }
        if (n2 > 0) {
            if (DoubleMetaphone.contains(string, 0, 2, "MC")) {
                doubleMetaphone$DoubleMetaphoneResult.append('K');
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('X', 'K');
            }
        } else {
            doubleMetaphone$DoubleMetaphoneResult.append('X');
        }
        return n2 + 2;
    }

    private int handleD(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n2) {
        if (DoubleMetaphone.contains(string, n2, 2, "DG")) {
            if (DoubleMetaphone.contains(string, n2 + 2, 1, "I", "E", "Y")) {
                doubleMetaphone$DoubleMetaphoneResult.append('J');
                n2 += 3;
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append("TK");
                n2 += 2;
            }
        } else if (DoubleMetaphone.contains(string, n2, 2, "DT", "DD")) {
            doubleMetaphone$DoubleMetaphoneResult.append('T');
            n2 += 2;
        } else {
            doubleMetaphone$DoubleMetaphoneResult.append('T');
            ++n2;
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    private int handleG(String var1_1, DoubleMetaphone$DoubleMetaphoneResult var2_2, int var3_3, boolean var4_4) {
        block17: {
            block18: {
                block16: {
                    if (this.charAt(var1_1, var3_3 + 1) != 'H') break block16;
                    var3_3 = this.handleGH(var1_1, var2_2, var3_3);
                    break block17;
                }
                if (this.charAt(var1_1, var3_3 + 1) != 'N') break block18;
                if (var3_3 != 1) ** GOTO lbl-1000
                v0 = this;
                if (v0.isVowel(v0.charAt(var1_1, 0)) && !var4_4) {
                    var2_2.append("KN", "N");
                } else if (!DoubleMetaphone.contains(var1_1, var3_3 + 2, 2, new String[]{"EY"}) && this.charAt(var1_1, var3_3 + 1) != 'Y' && !var4_4) {
                    var2_2.append("N", "KN");
                } else {
                    var2_2.append("KN");
                }
                var3_3 += 2;
                break block17;
            }
            if (DoubleMetaphone.contains(var1_1, var3_3 + 1, 2, new String[]{"LI"}) && !var4_4) {
                var2_2.append("KL", "L");
                var3_3 += 2;
            } else if (var3_3 == 0 && (this.charAt(var1_1, var3_3 + 1) == 'Y' || DoubleMetaphone.contains(var1_1, var3_3 + 1, 2, DoubleMetaphone.ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER))) {
                var2_2.append('K', 'J');
                var3_3 += 2;
            } else if (!(!DoubleMetaphone.contains(var1_1, var3_3 + 1, 2, new String[]{"ER"}) && this.charAt(var1_1, var3_3 + 1) != 'Y' || DoubleMetaphone.contains(var1_1, 0, 6, new String[]{"DANGER", "RANGER", "MANGER"}) || DoubleMetaphone.contains(var1_1, var3_3 - 1, 1, new String[]{"E", "I"}) || DoubleMetaphone.contains(var1_1, var3_3 - 1, 3, new String[]{"RGY", "OGY"}))) {
                var2_2.append('K', 'J');
                var3_3 += 2;
            } else if (DoubleMetaphone.contains(var1_1, var3_3 + 1, 1, new String[]{"E", "I", "Y"}) || DoubleMetaphone.contains(var1_1, var3_3 - 1, 4, new String[]{"AGGI", "OGGI"})) {
                if (DoubleMetaphone.contains(var1_1, 0, 4, new String[]{"VAN ", "VON "}) || DoubleMetaphone.contains(var1_1, 0, 3, new String[]{"SCH"}) || DoubleMetaphone.contains(var1_1, var3_3 + 1, 2, new String[]{"ET"})) {
                    var2_2.append('K');
                } else if (DoubleMetaphone.contains(var1_1, var3_3 + 1, 3, new String[]{"IER"})) {
                    var2_2.append('J');
                } else {
                    var2_2.append('J', 'K');
                }
                var3_3 += 2;
            } else {
                var3_3 = this.charAt(var1_1, var3_3 + 1) == 'G' ? (var3_3 += 2) : ++var3_3;
                var2_2.append('K');
            }
        }
        return var3_3;
    }

    /*
     * Unable to fully structure code
     */
    private int handleGH(String var1_1, DoubleMetaphone$DoubleMetaphoneResult var2_2, int var3_3) {
        block9: {
            if (var3_3 <= 0) break block9;
            v0 = this;
            if (v0.isVowel(v0.charAt(var1_1, var3_3 - 1))) break block9;
            var2_2.append('K');
            ** GOTO lbl22
        }
        if (var3_3 == 0) {
            if (this.charAt(var1_1, var3_3 + 2) == 'I') {
                var2_2.append('J');
            } else {
                var2_2.append('K');
            }
            var3_3 += 2;
        } else if (var3_3 > 1 && DoubleMetaphone.contains(var1_1, var3_3 - 2, 1, new String[]{"B", "H", "D"}) != false || var3_3 > 2 && DoubleMetaphone.contains(var1_1, var3_3 - 3, 1, new String[]{"B", "H", "D"}) != false || var3_3 > 3 && DoubleMetaphone.contains(var1_1, var3_3 - 4, 1, new String[]{"B", "H"})) {
            var3_3 += 2;
        } else {
            if (var3_3 > 2 && this.charAt(var1_1, var3_3 - 1) == 'U' && DoubleMetaphone.contains(var1_1, var3_3 - 3, 1, new String[]{"C", "G", "L", "R", "T"})) {
                var2_2.append('F');
            } else if (var3_3 > 0 && this.charAt(var1_1, var3_3 - 1) != 'I') {
                var2_2.append('K');
            }
lbl22:
            // 5 sources

            var3_3 += 2;
        }
        return var3_3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int handleH(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n2) {
        block5: {
            block4: {
                if (n2 == 0) break block4;
                DoubleMetaphone doubleMetaphone = this;
                if (!doubleMetaphone.isVowel(doubleMetaphone.charAt(string, n2 - 1))) break block5;
            }
            DoubleMetaphone doubleMetaphone = this;
            if (doubleMetaphone.isVowel(doubleMetaphone.charAt(string, n2 + 1))) {
                doubleMetaphone$DoubleMetaphoneResult.append('H');
                return n2 += 2;
            }
        }
        ++n2;
        return n2;
    }

    private int handleJ(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n2, boolean bl2) {
        if (DoubleMetaphone.contains(string, n2, 4, "JOSE") || DoubleMetaphone.contains(string, 0, 4, "SAN ")) {
            if (n2 == 0 && this.charAt(string, n2 + 4) == ' ' || string.length() == 4 || DoubleMetaphone.contains(string, 0, 4, "SAN ")) {
                doubleMetaphone$DoubleMetaphoneResult.append('H');
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('J', 'H');
            }
            ++n2;
        } else {
            if (n2 == 0 && !DoubleMetaphone.contains(string, n2, 4, "JOSE")) {
                doubleMetaphone$DoubleMetaphoneResult.append('J', 'A');
            } else {
                DoubleMetaphone doubleMetaphone = this;
                if (doubleMetaphone.isVowel(doubleMetaphone.charAt(string, n2 - 1)) && !bl2 && (this.charAt(string, n2 + 1) == 'A' || this.charAt(string, n2 + 1) == 'O')) {
                    doubleMetaphone$DoubleMetaphoneResult.append('J', 'H');
                } else if (n2 == string.length() - 1) {
                    doubleMetaphone$DoubleMetaphoneResult.append('J', ' ');
                } else if (!DoubleMetaphone.contains(string, n2 + 1, 1, L_T_K_S_N_M_B_Z) && !DoubleMetaphone.contains(string, n2 - 1, 1, "S", "K", "L")) {
                    doubleMetaphone$DoubleMetaphoneResult.append('J');
                }
            }
            n2 = this.charAt(string, n2 + 1) == 'J' ? (n2 += 2) : ++n2;
        }
        return n2;
    }

    private int handleL(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n2) {
        if (this.charAt(string, n2 + 1) == 'L') {
            if (this.conditionL0(string, n2)) {
                doubleMetaphone$DoubleMetaphoneResult.appendPrimary('L');
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('L');
            }
            n2 += 2;
        } else {
            ++n2;
            doubleMetaphone$DoubleMetaphoneResult.append('L');
        }
        return n2;
    }

    private int handleP(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n2) {
        if (this.charAt(string, n2 + 1) == 'H') {
            doubleMetaphone$DoubleMetaphoneResult.append('F');
            n2 += 2;
        } else {
            doubleMetaphone$DoubleMetaphoneResult.append('P');
            n2 = DoubleMetaphone.contains(string, n2 + 1, 1, "P", "B") ? n2 + 2 : n2 + 1;
        }
        return n2;
    }

    private int handleR(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n2, boolean bl2) {
        if (n2 == string.length() - 1 && !bl2 && DoubleMetaphone.contains(string, n2 - 2, 2, "IE") && !DoubleMetaphone.contains(string, n2 - 4, 2, "ME", "MA")) {
            doubleMetaphone$DoubleMetaphoneResult.appendAlternate('R');
        } else {
            doubleMetaphone$DoubleMetaphoneResult.append('R');
        }
        if (this.charAt(string, n2 + 1) == 'R') {
            return n2 + 2;
        }
        return n2 + 1;
    }

    private int handleS(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n2, boolean bl2) {
        if (DoubleMetaphone.contains(string, n2 - 1, 3, "ISL", "YSL")) {
            ++n2;
        } else if (n2 == 0 && DoubleMetaphone.contains(string, n2, 5, "SUGAR")) {
            doubleMetaphone$DoubleMetaphoneResult.append('X', 'S');
            ++n2;
        } else if (DoubleMetaphone.contains(string, n2, 2, "SH")) {
            if (DoubleMetaphone.contains(string, n2 + 1, 4, "HEIM", "HOEK", "HOLM", "HOLZ")) {
                doubleMetaphone$DoubleMetaphoneResult.append('S');
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('X');
            }
            n2 += 2;
        } else if (DoubleMetaphone.contains(string, n2, 3, "SIO", "SIA") || DoubleMetaphone.contains(string, n2, 4, "SIAN")) {
            if (bl2) {
                doubleMetaphone$DoubleMetaphoneResult.append('S');
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('S', 'X');
            }
            n2 += 3;
        } else if (n2 == 0 && DoubleMetaphone.contains(string, n2 + 1, 1, "M", "N", "L", "W") || DoubleMetaphone.contains(string, n2 + 1, 1, "Z")) {
            doubleMetaphone$DoubleMetaphoneResult.append('S', 'X');
            n2 = DoubleMetaphone.contains(string, n2 + 1, 1, "Z") ? n2 + 2 : n2 + 1;
        } else {
            int n3;
            if (DoubleMetaphone.contains(string, n2, 2, "SC")) {
                n3 = this.handleSC(string, doubleMetaphone$DoubleMetaphoneResult, n2);
            } else {
                if (n2 == string.length() - 1 && DoubleMetaphone.contains(string, n2 - 2, 2, "AI", "OI")) {
                    doubleMetaphone$DoubleMetaphoneResult.appendAlternate('S');
                } else {
                    doubleMetaphone$DoubleMetaphoneResult.append('S');
                }
                n3 = DoubleMetaphone.contains(string, n2 + 1, 1, "S", "Z") ? n2 + 2 : n2 + 1;
            }
            n2 = n3;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int handleSC(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n2) {
        if (this.charAt(string, n2 + 2) == 'H') {
            if (DoubleMetaphone.contains(string, n2 + 3, 2, "OO", "ER", "EN", "UY", "ED", "EM")) {
                if (DoubleMetaphone.contains(string, n2 + 3, 2, "ER", "EN")) {
                    doubleMetaphone$DoubleMetaphoneResult.append("X", "SK");
                    return n2 + 3;
                }
                doubleMetaphone$DoubleMetaphoneResult.append("SK");
                return n2 + 3;
            }
            if (n2 == 0) {
                DoubleMetaphone doubleMetaphone = this;
                if (!doubleMetaphone.isVowel(doubleMetaphone.charAt(string, 3)) && this.charAt(string, 3) != 'W') {
                    doubleMetaphone$DoubleMetaphoneResult.append('X', 'S');
                    return n2 + 3;
                }
            }
            doubleMetaphone$DoubleMetaphoneResult.append('X');
            return n2 + 3;
        }
        if (DoubleMetaphone.contains(string, n2 + 2, 1, "I", "E", "Y")) {
            doubleMetaphone$DoubleMetaphoneResult.append('S');
            return n2 + 3;
        }
        doubleMetaphone$DoubleMetaphoneResult.append("SK");
        return n2 + 3;
    }

    private int handleT(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n2) {
        if (DoubleMetaphone.contains(string, n2, 4, "TION") || DoubleMetaphone.contains(string, n2, 3, "TIA", "TCH")) {
            doubleMetaphone$DoubleMetaphoneResult.append('X');
            n2 += 3;
        } else if (DoubleMetaphone.contains(string, n2, 2, "TH") || DoubleMetaphone.contains(string, n2, 3, "TTH")) {
            if (DoubleMetaphone.contains(string, n2 + 2, 2, "OM", "AM") || DoubleMetaphone.contains(string, 0, 4, "VAN ", "VON ") || DoubleMetaphone.contains(string, 0, 3, "SCH")) {
                doubleMetaphone$DoubleMetaphoneResult.append('T');
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('0', 'T');
            }
            n2 += 2;
        } else {
            doubleMetaphone$DoubleMetaphoneResult.append('T');
            n2 = DoubleMetaphone.contains(string, n2 + 1, 1, "T", "D") ? n2 + 2 : n2 + 1;
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    private int handleW(String var1_1, DoubleMetaphone$DoubleMetaphoneResult var2_2, int var3_3) {
        block5: {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                if (!DoubleMetaphone.contains(var1_1, var3_3, 2, new String[]{"WR"})) break block4;
                                var2_2.append('R');
                                var3_3 += 2;
                                break block5;
                            }
                            if (var3_3 != 0) break block6;
                            v0 = this;
                            if (!v0.isVowel(v0.charAt(var1_1, var3_3 + 1)) && !DoubleMetaphone.contains(var1_1, var3_3, 2, new String[]{"WH"})) break block6;
                            v1 = this;
                            if (v1.isVowel(v1.charAt(var1_1, var3_3 + 1))) {
                                var2_2.append('A', 'F');
                            } else {
                                var2_2.append('A');
                            }
                            ++var3_3;
                            break block5;
                        }
                        if (var3_3 != var1_1.length() - 1) break block7;
                        v2 = this;
                        if (v2.isVowel(v2.charAt(var1_1, var3_3 - 1))) break block8;
                    }
                    if (!DoubleMetaphone.contains(var1_1, var3_3 - 1, 5, new String[]{"EWSKI", "EWSKY", "OWSKI", "OWSKY"}) && !DoubleMetaphone.contains(var1_1, 0, 3, new String[]{"SCH"})) break block9;
                }
                var2_2.appendAlternate('F');
                ** GOTO lbl-1000
            }
            if (DoubleMetaphone.contains(var1_1, var3_3, 4, new String[]{"WICZ", "WITZ"})) {
                var2_2.append("TS", "FX");
                var3_3 += 4;
            } else lbl-1000:
            // 2 sources

            {
                ++var3_3;
            }
        }
        return var3_3;
    }

    private int handleX(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n2) {
        if (n2 == 0) {
            doubleMetaphone$DoubleMetaphoneResult.append('S');
            ++n2;
        } else {
            if (n2 != string.length() - 1 || !DoubleMetaphone.contains(string, n2 - 3, 3, "IAU", "EAU") && !DoubleMetaphone.contains(string, n2 - 2, 2, "AU", "OU")) {
                doubleMetaphone$DoubleMetaphoneResult.append("KS");
            }
            n2 = DoubleMetaphone.contains(string, n2 + 1, 1, "C", "X") ? n2 + 2 : n2 + 1;
        }
        return n2;
    }

    private int handleZ(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n2, boolean bl2) {
        if (this.charAt(string, n2 + 1) == 'H') {
            doubleMetaphone$DoubleMetaphoneResult.append('J');
            n2 += 2;
        } else {
            if (DoubleMetaphone.contains(string, n2 + 1, 2, "ZO", "ZI", "ZA") || bl2 && n2 > 0 && this.charAt(string, n2 - 1) != 'T') {
                doubleMetaphone$DoubleMetaphoneResult.append("S", "TS");
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('S');
            }
            n2 = this.charAt(string, n2 + 1) == 'Z' ? n2 + 2 : n2 + 1;
        }
        return n2;
    }

    public boolean isDoubleMetaphoneEqual(String string, String string2) {
        return this.isDoubleMetaphoneEqual(string, string2, false);
    }

    public boolean isDoubleMetaphoneEqual(String string, String string2, boolean bl2) {
        return StringUtils.equals(this.doubleMetaphone(string, bl2), this.doubleMetaphone(string2, bl2));
    }

    private boolean isSilentStart(String string) {
        boolean bl2 = false;
        String[] stringArray = SILENT_START;
        int n2 = SILENT_START.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (!string.startsWith(string2)) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    private boolean isSlavoGermanic(String string) {
        return string.indexOf(87) >= 0 || string.indexOf(75) >= 0 || string.contains("CZ") || string.contains("WITZ");
    }

    private boolean isVowel(char c2) {
        return VOWELS.indexOf(c2) != -1;
    }

    public void setMaxCodeLen(int n2) {
        this.maxCodeLen = n2;
    }
}

