/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import java.util.regex.Pattern;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.language.SoundexUtils;

public class Nysiis
implements StringEncoder {
    private static final char[] CHARS_A = new char[]{'A'};
    private static final char[] CHARS_AF = new char[]{'A', 'F'};
    private static final char[] CHARS_C = new char[]{'C'};
    private static final char[] CHARS_FF = new char[]{'F', 'F'};
    private static final char[] CHARS_G = new char[]{'G'};
    private static final char[] CHARS_N = new char[]{'N'};
    private static final char[] CHARS_NN = new char[]{'N', 'N'};
    private static final char[] CHARS_S = new char[]{'S'};
    private static final char[] CHARS_SSS = new char[]{'S', 'S', 'S'};
    private static final Pattern PAT_MAC = Pattern.compile("^MAC");
    private static final Pattern PAT_KN = Pattern.compile("^KN");
    private static final Pattern PAT_K = Pattern.compile("^K");
    private static final Pattern PAT_PH_PF = Pattern.compile("^(PH|PF)");
    private static final Pattern PAT_SCH = Pattern.compile("^SCH");
    private static final Pattern PAT_EE_IE = Pattern.compile("(EE|IE)$");
    private static final Pattern PAT_DT_ETC = Pattern.compile("(DT|RT|RD|NT|ND)$");
    private static final char SPACE = ' ';
    private static final int TRUE_LENGTH = 6;
    private final boolean strict;

    private static boolean isVowel(char c2) {
        return c2 == 'A' || c2 == 'E' || c2 == 'I' || c2 == 'O' || c2 == 'U';
    }

    private static char[] transcodeRemaining(char c2, char c3, char c4, char c5) {
        if (c3 == 'E' && c4 == 'V') {
            return CHARS_AF;
        }
        if (Nysiis.isVowel(c3)) {
            return CHARS_A;
        }
        switch (c3) {
            case 'Q': {
                return CHARS_G;
            }
            case 'Z': {
                return CHARS_S;
            }
            case 'M': {
                return CHARS_N;
            }
            case 'K': {
                if (c4 == 'N') {
                    return CHARS_NN;
                }
                return CHARS_C;
            }
        }
        if (c3 == 'S' && c4 == 'C' && c5 == 'H') {
            return CHARS_SSS;
        }
        if (c3 == 'P' && c4 == 'H') {
            return CHARS_FF;
        }
        if (!(c3 != 'H' || Nysiis.isVowel(c2) && Nysiis.isVowel(c4))) {
            return new char[]{c2};
        }
        if (c3 == 'W' && Nysiis.isVowel(c2)) {
            return new char[]{c2};
        }
        return new char[]{c3};
    }

    public Nysiis() {
        this(true);
    }

    public Nysiis(boolean bl2) {
        this.strict = bl2;
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof String)) {
            throw new EncoderException("Parameter supplied to Nysiis encode is not of type java.lang.String");
        }
        return this.nysiis((String)object);
    }

    @Override
    public String encode(String string) {
        return this.nysiis(string);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public String nysiis(String object) {
        int n2;
        if (object == null) {
            return null;
        }
        if (((String)(object = SoundexUtils.clean((String)object))).isEmpty()) {
            return object;
        }
        object = PAT_MAC.matcher((CharSequence)object).replaceFirst("MCC");
        object = PAT_KN.matcher((CharSequence)object).replaceFirst("NN");
        object = PAT_K.matcher((CharSequence)object).replaceFirst("C");
        object = PAT_PH_PF.matcher((CharSequence)object).replaceFirst("FF");
        object = PAT_SCH.matcher((CharSequence)object).replaceFirst("SSS");
        object = PAT_EE_IE.matcher((CharSequence)object).replaceFirst("Y");
        object = PAT_DT_ETC.matcher((CharSequence)object).replaceFirst("D");
        StringBuilder stringBuilder = new StringBuilder(((String)object).length());
        stringBuilder.append(((String)object).charAt(0));
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n3 = cArray.length;
        for (n2 = 1; n2 < n3; ++n2) {
            char c2 = n2 < n3 - 1 ? (char)object[n2 + 1] : (char)' ';
            char c3 = n2 < n3 - 2 ? (char)object[n2 + 2] : (char)' ';
            char[] cArray2 = Nysiis.transcodeRemaining((char)object[n2 - 1], (char)object[n2], c2, c3);
            System.arraycopy(cArray2, 0, object, n2, cArray2.length);
            if (object[n2] == object[n2 - 1]) continue;
            stringBuilder.append((char)object[n2]);
        }
        if (stringBuilder.length() > 1) {
            StringBuilder stringBuilder2 = stringBuilder;
            char c4 = stringBuilder2.charAt(stringBuilder2.length() - 1);
            n2 = c4;
            if (c4 == 'S') {
                StringBuilder stringBuilder3 = stringBuilder;
                stringBuilder3.deleteCharAt(stringBuilder3.length() - 1);
                StringBuilder stringBuilder4 = stringBuilder;
                n2 = stringBuilder4.charAt(stringBuilder4.length() - 1);
            }
            if (stringBuilder.length() > 2) {
                StringBuilder stringBuilder5 = stringBuilder;
                char c5 = stringBuilder5.charAt(stringBuilder5.length() - 2);
                if (c5 == 'A' && n2 == 89) {
                    StringBuilder stringBuilder6 = stringBuilder;
                    stringBuilder6.deleteCharAt(stringBuilder6.length() - 2);
                }
            }
            if (n2 == 65) {
                StringBuilder stringBuilder7 = stringBuilder;
                stringBuilder7.deleteCharAt(stringBuilder7.length() - 1);
            }
        }
        String string = stringBuilder.toString();
        if (this.isStrict()) {
            return string.substring(0, Math.min(6, string.length()));
        }
        return string;
    }
}

