/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.Utils;

public class PercentCodec
implements BinaryDecoder,
BinaryEncoder {
    private static final byte ESCAPE_CHAR = 37;
    private final BitSet alwaysEncodeChars = new BitSet();
    private final boolean plusForSpace;
    private int alwaysEncodeCharsMin = Integer.MAX_VALUE;
    private int alwaysEncodeCharsMax = Integer.MIN_VALUE;

    public PercentCodec() {
        this.plusForSpace = false;
        this.insertAlwaysEncodeChar((byte)37);
    }

    public PercentCodec(byte[] byArray, boolean bl2) {
        this.plusForSpace = bl2;
        this.insertAlwaysEncodeChars(byArray);
    }

    private boolean canEncode(byte by2) {
        return !this.isAsciiChar(by2) || this.inAlwaysEncodeCharsRange(by2) && this.alwaysEncodeChars.get(by2);
    }

    private boolean containsSpace(byte[] byArray) {
        for (byte by2 : byArray) {
            if (by2 != 32) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] decode(byte[] byArray) throws DecoderException {
        if (byArray == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.expectedDecodingBytes(byArray));
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2];
            if (n2 == 37) {
                try {
                    n2 = Utils.digit16(byArray[++i2]);
                    int n3 = Utils.digit16(byArray[++i2]);
                    byteBuffer.put((byte)((n2 << 4) + n3));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new DecoderException("Invalid percent decoding: ", arrayIndexOutOfBoundsException);
                }
            }
            if (this.plusForSpace && n2 == 43) {
                byteBuffer.put((byte)32);
                continue;
            }
            byteBuffer.put((byte)n2);
        }
        return byteBuffer.array();
    }

    @Override
    public Object decode(Object object) throws DecoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return this.decode((byte[])object);
        }
        throw new DecoderException("Objects of type " + object.getClass().getName() + " cannot be Percent decoded");
    }

    private byte[] doEncode(byte[] byArray, int n2, boolean bl2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        for (char c2 : byArray) {
            if (bl2 && this.canEncode((byte)c2)) {
                if (c2 < '\u0000') {
                    c2 = (byte)(c2 + 256);
                }
                char c3 = Utils.hexChar(c2 >> 4);
                c2 = Utils.hexChar(c2);
                byteBuffer.put((byte)37);
                byteBuffer.put((byte)c3);
                byteBuffer.put((byte)c2);
                continue;
            }
            if (this.plusForSpace && c2 == ' ') {
                byteBuffer.put((byte)43);
                continue;
            }
            byteBuffer.put((byte)c2);
        }
        return byteBuffer.array();
    }

    @Override
    public byte[] encode(byte[] byArray) throws EncoderException {
        if (byArray == null) {
            return null;
        }
        int n2 = this.expectedEncodingBytes(byArray);
        boolean bl2 = n2 != byArray.length;
        if (bl2 || this.plusForSpace && this.containsSpace(byArray)) {
            return this.doEncode(byArray, n2, bl2);
        }
        return byArray;
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return this.encode((byte[])object);
        }
        throw new EncoderException("Objects of type " + object.getClass().getName() + " cannot be Percent encoded");
    }

    private int expectedDecodingBytes(byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            byte by2;
            n3 += (by2 = byArray[n3]) == 37 ? 3 : 1;
            ++n2;
        }
        return n2;
    }

    private int expectedEncodingBytes(byte[] byArray) {
        int n2 = 0;
        for (byte by2 : byArray) {
            n2 += this.canEncode(by2) ? 3 : 1;
        }
        return n2;
    }

    private boolean inAlwaysEncodeCharsRange(byte by2) {
        return by2 >= this.alwaysEncodeCharsMin && by2 <= this.alwaysEncodeCharsMax;
    }

    private void insertAlwaysEncodeChar(byte by2) {
        if (by2 < 0) {
            throw new IllegalArgumentException("byte must be >= 0");
        }
        this.alwaysEncodeChars.set(by2);
        if (by2 < this.alwaysEncodeCharsMin) {
            this.alwaysEncodeCharsMin = by2;
        }
        if (by2 > this.alwaysEncodeCharsMax) {
            this.alwaysEncodeCharsMax = by2;
        }
    }

    private void insertAlwaysEncodeChars(byte[] byArray) {
        if (byArray != null) {
            for (byte by2 : byArray) {
                this.insertAlwaysEncodeChar(by2);
            }
        }
        this.insertAlwaysEncodeChar((byte)37);
    }

    private boolean isAsciiChar(byte by2) {
        return by2 >= 0;
    }
}

