/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.BitSet;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringDecoder;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.net.Utils;

public class QuotedPrintableCodec
implements BinaryDecoder,
BinaryEncoder,
StringDecoder,
StringEncoder {
    private static final BitSet PRINTABLE_CHARS;
    private static final byte ESCAPE_CHAR = 61;
    private static final byte TAB = 9;
    private static final byte SPACE = 32;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final int MIN_BYTES = 3;
    private static final int SAFE_LENGTH = 73;
    private final Charset charset;
    private final boolean strict;

    public static final byte[] decodeQuotedPrintable(byte[] byArray) throws DecoderException {
        if (byArray == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2];
            if (n2 == 61) {
                try {
                    if (byArray[++i2] == 13) continue;
                    n2 = Utils.digit16(byArray[i2]);
                    int n3 = Utils.digit16(byArray[++i2]);
                    byteArrayOutputStream.write((char)((n2 << 4) + n3));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new DecoderException("Invalid quoted-printable encoding", arrayIndexOutOfBoundsException);
                }
            }
            if (n2 == 13 || n2 == 10) continue;
            byteArrayOutputStream.write(n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static int encodeByte(int n2, boolean bl2, ByteArrayOutputStream byteArrayOutputStream) {
        if (bl2) {
            return QuotedPrintableCodec.encodeQuotedPrintable(n2, byteArrayOutputStream);
        }
        byteArrayOutputStream.write(n2);
        return 1;
    }

    public static final byte[] encodeQuotedPrintable(BitSet bitSet, byte[] byArray) {
        return QuotedPrintableCodec.encodeQuotedPrintable(bitSet, byArray, false);
    }

    /*
     * WARNING - void declaration
     */
    public static final byte[] encodeQuotedPrintable(BitSet bitSet, byte[] byArray, boolean n2) {
        if (byArray == null) {
            return null;
        }
        if (bitSet == null) {
            bitSet = PRINTABLE_CHARS;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = byArray.length;
        if (n2 != 0) {
            boolean i3;
            int n4;
            if (n3 < 3) {
                return null;
            }
            n2 = 1;
            for (n4 = 0; n4 < n3 - 3; ++n4) {
                int bl2 = QuotedPrintableCodec.getUnsignedOctet(n4, byArray);
                if (n2 < 73) {
                    n2 += QuotedPrintableCodec.encodeByte(bl2, !bitSet.get(bl2), byteArrayOutputStream);
                    continue;
                }
                QuotedPrintableCodec.encodeByte(bl2, !bitSet.get(bl2) || QuotedPrintableCodec.isWhitespace(bl2), byteArrayOutputStream);
                byteArrayOutputStream.write(61);
                byteArrayOutputStream.write(13);
                byteArrayOutputStream.write(10);
                n2 = 1;
            }
            n4 = QuotedPrintableCodec.getUnsignedOctet(n3 - 3, byArray);
            boolean bl2 = i3 = !bitSet.get(n4) || QuotedPrintableCodec.isWhitespace(n4) && n2 > 68;
            if ((n2 += QuotedPrintableCodec.encodeByte(n4, i3, byteArrayOutputStream)) > 71) {
                byteArrayOutputStream.write(61);
                byteArrayOutputStream.write(13);
                byteArrayOutputStream.write(10);
            }
            for (int i2 = n3 - 2; i2 < n3; ++i2) {
                n4 = QuotedPrintableCodec.getUnsignedOctet(i2, byArray);
                boolean bl3 = !bitSet.get(n4) || i2 > n3 - 2 && QuotedPrintableCodec.isWhitespace(n4);
                QuotedPrintableCodec.encodeByte(n4, bl3, byteArrayOutputStream);
            }
        } else {
            void var6_13;
            byte[] byArray2 = byArray;
            int n5 = byArray.length;
            boolean bl4 = false;
            while (var6_13 < n5) {
                int n4;
                int n7 = n4 = byArray2[var6_13];
                if (n4 < 0) {
                    n7 += 256;
                }
                if (bitSet.get(n7)) {
                    byteArrayOutputStream.write(n7);
                } else {
                    QuotedPrintableCodec.encodeQuotedPrintable(n7, byteArrayOutputStream);
                }
                ++var6_13;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static int encodeQuotedPrintable(int n2, ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write(61);
        char c2 = Utils.hexChar(n2 >> 4);
        n2 = Utils.hexChar(n2);
        byteArrayOutputStream.write(c2);
        byteArrayOutputStream.write(n2);
        return 3;
    }

    private static int getUnsignedOctet(int n2, byte[] byArray) {
        if ((n2 = byArray[n2]) < 0) {
            n2 += 256;
        }
        return n2;
    }

    private static boolean isWhitespace(int n2) {
        return n2 == 32 || n2 == 9;
    }

    public QuotedPrintableCodec() {
        this(StandardCharsets.UTF_8, false);
    }

    public QuotedPrintableCodec(boolean bl2) {
        this(StandardCharsets.UTF_8, bl2);
    }

    public QuotedPrintableCodec(Charset charset) {
        this(charset, false);
    }

    public QuotedPrintableCodec(Charset charset, boolean bl2) {
        this.charset = charset;
        this.strict = bl2;
    }

    public QuotedPrintableCodec(String string) throws IllegalCharsetNameException, IllegalArgumentException, UnsupportedCharsetException {
        this(Charset.forName(string), false);
    }

    @Override
    public byte[] decode(byte[] byArray) throws DecoderException {
        return QuotedPrintableCodec.decodeQuotedPrintable(byArray);
    }

    @Override
    public Object decode(Object object) throws DecoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return this.decode((byte[])object);
        }
        if (object instanceof String) {
            return this.decode((String)object);
        }
        throw new DecoderException("Objects of type " + object.getClass().getName() + " cannot be quoted-printable decoded");
    }

    @Override
    public String decode(String string) throws DecoderException {
        return this.decode(string, this.getCharset());
    }

    public String decode(String string, Charset charset) throws DecoderException {
        if (string == null) {
            return null;
        }
        return new String(this.decode(StringUtils.getBytesUsAscii(string)), charset);
    }

    public String decode(String string, String string2) throws DecoderException, UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return new String(this.decode(StringUtils.getBytesUsAscii(string)), string2);
    }

    @Override
    public byte[] encode(byte[] byArray) {
        return QuotedPrintableCodec.encodeQuotedPrintable(PRINTABLE_CHARS, byArray, this.strict);
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return this.encode((byte[])object);
        }
        if (object instanceof String) {
            return this.encode((String)object);
        }
        throw new EncoderException("Objects of type " + object.getClass().getName() + " cannot be quoted-printable encoded");
    }

    @Override
    public String encode(String string) throws EncoderException {
        return this.encode(string, this.getCharset());
    }

    public String encode(String string, Charset charset) {
        if (string == null) {
            return null;
        }
        return StringUtils.newStringUsAscii(this.encode(string.getBytes(charset)));
    }

    public String encode(String string, String string2) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return StringUtils.newStringUsAscii(this.encode(string.getBytes(string2)));
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getDefaultCharset() {
        return this.charset.name();
    }

    static {
        int n2;
        PRINTABLE_CHARS = new BitSet(256);
        for (n2 = 33; n2 <= 60; ++n2) {
            PRINTABLE_CHARS.set(n2);
        }
        for (n2 = 62; n2 <= 126; ++n2) {
            PRINTABLE_CHARS.set(n2);
        }
        PRINTABLE_CHARS.set(9);
        PRINTABLE_CHARS.set(32);
    }
}

