/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.io.DirectoryWalker$CancelException;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

@Deprecated
public abstract class DirectoryWalker<T> {
    private final FileFilter filter;
    private final int depthLimit;

    protected DirectoryWalker() {
        this(null, -1);
    }

    protected DirectoryWalker(FileFilter fileFilter, int n2) {
        this.filter = fileFilter;
        this.depthLimit = n2;
    }

    protected DirectoryWalker(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2, int n2) {
        if (iOFileFilter == null && iOFileFilter2 == null) {
            this.filter = null;
        } else {
            iOFileFilter = iOFileFilter != null ? iOFileFilter : TrueFileFilter.TRUE;
            iOFileFilter2 = iOFileFilter2 != null ? iOFileFilter2 : TrueFileFilter.TRUE;
            iOFileFilter = FileFilterUtils.makeDirectoryOnly(iOFileFilter);
            iOFileFilter2 = FileFilterUtils.makeFileOnly(iOFileFilter2);
            this.filter = iOFileFilter.or(iOFileFilter2);
        }
        this.depthLimit = n2;
    }

    protected final void checkIfCancelled(File file, int n2, Collection<T> collection) throws IOException {
        if (this.handleIsCancelled(file, n2, collection)) {
            throw new DirectoryWalker$CancelException(file, n2);
        }
    }

    protected File[] filterDirectoryContents(File file, int n2, File ... fileArray) throws IOException {
        return fileArray;
    }

    protected void handleCancelled(File file, Collection<T> collection, DirectoryWalker$CancelException directoryWalker$CancelException) throws IOException {
        throw directoryWalker$CancelException;
    }

    protected boolean handleDirectory(File file, int n2, Collection<T> collection) throws IOException {
        return true;
    }

    protected void handleDirectoryEnd(File file, int n2, Collection<T> collection) throws IOException {
    }

    protected void handleDirectoryStart(File file, int n2, Collection<T> collection) throws IOException {
    }

    protected void handleEnd(Collection<T> collection) throws IOException {
    }

    protected void handleFile(File file, int n2, Collection<T> collection) throws IOException {
    }

    protected boolean handleIsCancelled(File file, int n2, Collection<T> collection) throws IOException {
        return false;
    }

    protected void handleRestricted(File file, int n2, Collection<T> collection) throws IOException {
    }

    protected void handleStart(File file, Collection<T> collection) throws IOException {
    }

    protected final void walk(File file, Collection<T> collection) throws IOException {
        Objects.requireNonNull(file, "startDirectory");
        try {
            this.handleStart(file, collection);
            this.walk(file, 0, collection);
            this.handleEnd(collection);
            return;
        }
        catch (DirectoryWalker$CancelException directoryWalker$CancelException) {
            this.handleCancelled(file, collection, directoryWalker$CancelException);
            return;
        }
    }

    private void walk(File file, int n2, Collection<T> collection) throws IOException {
        this.checkIfCancelled(file, n2, collection);
        if (this.handleDirectory(file, n2, collection)) {
            this.handleDirectoryStart(file, n2, collection);
            int n3 = n2 + 1;
            if (this.depthLimit < 0 || n3 <= this.depthLimit) {
                this.checkIfCancelled(file, n2, collection);
                File[] fileArray = file.listFiles(this.filter);
                fileArray = this.filterDirectoryContents(file, n2, fileArray);
                if (fileArray == null) {
                    this.handleRestricted(file, n3, collection);
                } else {
                    for (File file2 : fileArray) {
                        if (file2.isDirectory()) {
                            this.walk(file2, n3, collection);
                            continue;
                        }
                        this.checkIfCancelled(file2, n3, collection);
                        this.handleFile(file2, n3, collection);
                        this.checkIfCancelled(file2, n3, collection);
                    }
                }
            }
            this.handleDirectoryEnd(file, n2, collection);
        }
        this.checkIfCancelled(file, n2, collection);
    }
}

