/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.CloseableURLConnection;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.StreamIterator;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.AccumulatorPathVisitor$Builder;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.Counters$PathCounters;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.StandardDeleteOption;
import org.apache.commons.io.filefilter.FileEqualsFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.Uncheck;

public class FileUtils {
    private static final String PROTOCOL_FILE = "file";
    public static final long ONE_KB = 1024L;
    public static final BigInteger ONE_KB_BI = BigInteger.valueOf(1024L);
    public static final long ONE_MB = 0x100000L;
    public static final BigInteger ONE_MB_BI = ONE_KB_BI.multiply(ONE_KB_BI);
    public static final long ONE_GB = 0x40000000L;
    public static final BigInteger ONE_GB_BI = ONE_KB_BI.multiply(ONE_MB_BI);
    public static final long ONE_TB = 0x10000000000L;
    public static final BigInteger ONE_TB_BI = ONE_KB_BI.multiply(ONE_GB_BI);
    public static final long ONE_PB = 0x4000000000000L;
    public static final BigInteger ONE_PB_BI = ONE_KB_BI.multiply(ONE_TB_BI);
    public static final long ONE_EB = 0x1000000000000000L;
    public static final BigInteger ONE_EB_BI = ONE_KB_BI.multiply(ONE_PB_BI);
    public static final BigInteger ONE_ZB = BigInteger.valueOf(1024L).multiply(BigInteger.valueOf(0x1000000000000000L));
    public static final BigInteger ONE_YB = ONE_KB_BI.multiply(ONE_ZB);
    public static final File[] EMPTY_FILE_ARRAY = new File[0];

    public static String byteCountToDisplaySize(BigInteger object) {
        Objects.requireNonNull(object, "size");
        object = ((BigInteger)object).divide(ONE_EB_BI).compareTo(BigInteger.ZERO) > 0 ? ((BigInteger)object).divide(ONE_EB_BI) + " EB" : (((BigInteger)object).divide(ONE_PB_BI).compareTo(BigInteger.ZERO) > 0 ? ((BigInteger)object).divide(ONE_PB_BI) + " PB" : (((BigInteger)object).divide(ONE_TB_BI).compareTo(BigInteger.ZERO) > 0 ? ((BigInteger)object).divide(ONE_TB_BI) + " TB" : (((BigInteger)object).divide(ONE_GB_BI).compareTo(BigInteger.ZERO) > 0 ? ((BigInteger)object).divide(ONE_GB_BI) + " GB" : (((BigInteger)object).divide(ONE_MB_BI).compareTo(BigInteger.ZERO) > 0 ? ((BigInteger)object).divide(ONE_MB_BI) + " MB" : (((BigInteger)object).divide(ONE_KB_BI).compareTo(BigInteger.ZERO) > 0 ? ((BigInteger)object).divide(ONE_KB_BI) + " KB" : object + " bytes")))));
        return object;
    }

    public static String byteCountToDisplaySize(long l2) {
        return FileUtils.byteCountToDisplaySize(BigInteger.valueOf(l2));
    }

    public static String byteCountToDisplaySize(Number number) {
        return FileUtils.byteCountToDisplaySize(number.longValue());
    }

    private static void checkExists(File file, boolean bl2) throws FileNotFoundException {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        if (bl2 && !file.exists() && !FileUtils.isSymlink(file)) {
            throw new FileNotFoundException(file.toString());
        }
    }

    private static void checkFileExists(File file, String string) throws FileNotFoundException {
        Objects.requireNonNull(file, string);
        if (!file.isFile()) {
            if (file.exists()) {
                throw new IllegalArgumentException("Parameter '" + string + "' is not a file: " + file);
            }
            if (!Files.isSymbolicLink(file.toPath())) {
                throw new FileNotFoundException("Source '" + file + "' does not exist");
            }
        }
    }

    private static File checkIsFile(File file, String string) {
        if (file.isFile()) {
            return file;
        }
        throw new IllegalArgumentException(String.format("Parameter '%s' is not a file: %s", string, file));
    }

    public static Checksum checksum(File object, Checksum checksum) throws IOException {
        FileUtils.checkFileExists((File)object, PROTOCOL_FILE);
        Objects.requireNonNull(checksum, "checksum");
        object = new CheckedInputStream(Files.newInputStream(((File)object).toPath(), new OpenOption[0]), checksum);
        try {
            IOUtils.consume((InputStream)object);
        }
        finally {
            ((InputStream)object).close();
        }
        return checksum;
    }

    public static long checksumCRC32(File file) throws IOException {
        return FileUtils.checksum(file, new CRC32()).getValue();
    }

    public static void cleanDirectory(File file2) throws IOException {
        IOConsumer.forAll(file -> FileUtils.forceDelete(file, false), FileUtils.listFiles(file2, null));
    }

    private static void cleanDirectoryOnExit(File file) throws IOException {
        IOConsumer.forAll(FileUtils::forceDeleteOnExit, FileUtils.listFiles(file, null));
    }

    public static boolean contentEquals(File file, File file2) throws IOException {
        if (file == null && file2 == null) {
            return true;
        }
        if (file == null || file2 == null) {
            return false;
        }
        boolean bl2 = file.exists();
        if (bl2 != file2.exists()) {
            return false;
        }
        if (!bl2) {
            return true;
        }
        FileUtils.checkIsFile(file, "file1");
        FileUtils.checkIsFile(file2, "file2");
        if (file.length() != file2.length()) {
            return false;
        }
        if (file.getCanonicalFile().equals(file2.getCanonicalFile())) {
            return true;
        }
        return PathUtils.fileContentEquals(file.toPath(), file2.toPath());
    }

    public static boolean contentEqualsIgnoreEOL(File object, File object2, String object3) throws IOException {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        boolean bl2 = ((File)object).exists();
        if (bl2 != ((File)object2).exists()) {
            return false;
        }
        if (!bl2) {
            return true;
        }
        FileUtils.checkFileExists((File)object, "file1");
        FileUtils.checkFileExists((File)object2, "file2");
        if (((File)object).getCanonicalFile().equals(((File)object2).getCanonicalFile())) {
            return true;
        }
        object3 = Charsets.toCharset((String)object3);
        object = new InputStreamReader(Files.newInputStream(((File)object).toPath(), new OpenOption[0]), (Charset)object3);
        try {
            boolean bl3;
            object2 = new InputStreamReader(Files.newInputStream(((File)object2).toPath(), new OpenOption[0]), (Charset)object3);
            try {
                bl3 = IOUtils.contentEqualsIgnoreEOL((Reader)object, (Reader)object2);
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)object2).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ((Reader)object2).close();
            return bl3;
        }
        finally {
            ((Reader)object).close();
        }
    }

    public static File[] convertFileCollectionToFileArray(Collection<File> collection) {
        return collection.toArray(EMPTY_FILE_ARRAY);
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        FileUtils.copyDirectory(file, file2, true);
    }

    public static void copyDirectory(File file, File file2, boolean bl2) throws IOException {
        FileUtils.copyDirectory(file, file2, null, bl2);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter) throws IOException {
        FileUtils.copyDirectory(file, file2, fileFilter, true);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter, boolean bl2) throws IOException {
        FileUtils.copyDirectory(file, file2, fileFilter, bl2, StandardCopyOption.REPLACE_EXISTING, LinkOption.NOFOLLOW_LINKS);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter, boolean bl2, CopyOption ... copyOptionArray) throws IOException {
        Objects.requireNonNull(file2, "destination");
        FileUtils.requireDirectoryExists(file, "srcDir");
        FileUtils.requireCanonicalPathsNotEquals(file, file2);
        ArrayList<String> arrayList = null;
        File[] fileArray = file.getCanonicalPath();
        String string = file2.getCanonicalPath();
        if (string.startsWith((String)fileArray) && (fileArray = FileUtils.listFiles(file, fileFilter)).length > 0) {
            arrayList = new ArrayList<String>(fileArray.length);
            for (File file3 : fileArray) {
                arrayList.add(new File(file2, file3.getName()).getCanonicalPath());
            }
        }
        FileUtils.doCopyDirectory(file, file2, fileFilter, arrayList, bl2, copyOptionArray);
    }

    public static void copyDirectoryToDirectory(File file, File file2) throws IOException {
        Objects.requireNonNull(file, "sourceDir");
        FileUtils.requireDirectoryIfExists(file2, "destinationDir");
        FileUtils.copyDirectory(file, new File(file2, file.getName()), true);
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileUtils.copyFile(file, file2, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyFile(File file, File file2, boolean bl2) throws IOException {
        FileUtils.copyFile(file, file2, bl2, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyFile(File file, File file2, boolean bl2, CopyOption ... copyOptionArray) throws IOException {
        Objects.requireNonNull(file2, "destination");
        FileUtils.checkFileExists(file, "srcFile");
        FileUtils.requireCanonicalPathsNotEquals(file, file2);
        FileUtils.createParentDirectories(file2);
        if (file2.exists()) {
            FileUtils.checkFileExists(file2, "destFile");
        }
        Path path = file.toPath();
        Files.copy(path, file2.toPath(), copyOptionArray);
        if (bl2 && !Files.isSymbolicLink(path) && !FileUtils.setTimes(file, file2)) {
            throw new IOException("Cannot set the file time.");
        }
    }

    public static void copyFile(File file, File file2, CopyOption ... copyOptionArray) throws IOException {
        FileUtils.copyFile(file, file2, true, copyOptionArray);
    }

    public static long copyFile(File object, OutputStream outputStream) throws IOException {
        object = Files.newInputStream(((File)object).toPath(), new OpenOption[0]);
        try {
            long l2 = IOUtils.copyLarge((InputStream)object, outputStream);
            return l2;
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
    }

    public static void copyFileToDirectory(File file, File file2) throws IOException {
        FileUtils.copyFileToDirectory(file, file2, true);
    }

    public static void copyFileToDirectory(File file, File file2, boolean bl2) throws IOException {
        Objects.requireNonNull(file, "sourceFile");
        FileUtils.requireDirectoryIfExists(file2, "destinationDir");
        FileUtils.copyFile(file, new File(file2, file.getName()), bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyInputStreamToFile(InputStream inputStream, File file) throws IOException {
        try {
            FileUtils.copyToFile(inputStream, file);
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        inputStream.close();
    }

    public static void copyToDirectory(File file, File file2) throws IOException {
        Objects.requireNonNull(file, "sourceFile");
        if (file.isFile()) {
            FileUtils.copyFileToDirectory(file, file2);
            return;
        }
        if (file.isDirectory()) {
            FileUtils.copyDirectoryToDirectory(file, file2);
            return;
        }
        throw new FileNotFoundException("The source " + file + " does not exist");
    }

    public static void copyToDirectory(Iterable<File> object, File file) throws IOException {
        Objects.requireNonNull(object, "sourceIterable");
        object = object.iterator();
        while (object.hasNext()) {
            File file2 = (File)object.next();
            FileUtils.copyFileToDirectory(file2, file);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyToFile(InputStream inputStream, File object) throws IOException {
        object = FileUtils.newOutputStream((File)object, false);
        try {
            IOUtils.copy(inputStream, (OutputStream)object);
            if (object == null) return;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            try {
                ((OutputStream)object).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((OutputStream)object).close();
    }

    public static void copyURLToFile(URL uRL, File comparable) throws IOException {
        comparable = comparable.toPath();
        PathUtils.createParentDirectories((Path)comparable, new FileAttribute[0]);
        PathUtils.copy(uRL::openStream, (Path)comparable, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyURLToFile(URL object, File file, int n2, int n3) throws IOException {
        object = CloseableURLConnection.open((URL)object);
        try {
            ((CloseableURLConnection)object).setConnectTimeout(n2);
            ((CloseableURLConnection)object).setReadTimeout(n3);
            try (InputStream inputStream = ((CloseableURLConnection)object).getInputStream();){
                FileUtils.copyInputStreamToFile(inputStream, file);
            }
            if (object != null) {
                ((CloseableURLConnection)object).close();
                return;
            }
        }
        catch (Throwable throwable) {
            if (object != null) {
                try {
                    ((CloseableURLConnection)object).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    public static File createParentDirectories(File file) throws IOException {
        return FileUtils.mkdirs(FileUtils.getParentFile(file));
    }

    public static File current() {
        return PathUtils.current().toFile();
    }

    static String decodeUrl(String string) {
        String string2 = string;
        if (string != null && string.indexOf(37) >= 0) {
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder();
            ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
            int n3 = 0;
            while (n3 < n2) {
                if (string.charAt(n3) == '%') {
                    try {
                        do {
                            byte by2 = (byte)Integer.parseInt(string.substring(n3 + 1, n3 + 3), 16);
                            byteBuffer.put(by2);
                        } while ((n3 += 3) < n2 && string.charAt(n3) == '%');
                        continue;
                    }
                    catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                    }
                    finally {
                        if (byteBuffer.position() <= 0) continue;
                        byteBuffer.flip();
                        stringBuilder.append(StandardCharsets.UTF_8.decode(byteBuffer).toString());
                        byteBuffer.clear();
                        continue;
                    }
                }
                stringBuilder.append(string.charAt(n3++));
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public static File delete(File file) throws IOException {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        Files.delete(file.toPath());
        return file;
    }

    public static void deleteDirectory(File file) throws IOException {
        Objects.requireNonNull(file, "directory");
        if (!file.exists()) {
            return;
        }
        if (!FileUtils.isSymlink(file)) {
            FileUtils.cleanDirectory(file);
        }
        FileUtils.delete(file);
    }

    private static void deleteDirectoryOnExit(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        file.deleteOnExit();
        if (!FileUtils.isSymlink(file)) {
            FileUtils.cleanDirectoryOnExit(file);
        }
    }

    public static boolean deleteQuietly(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (file.isDirectory()) {
                FileUtils.cleanDirectory(file);
            }
        }
        catch (Exception exception) {}
        try {
            return file.delete();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean directoryContains(File file, File file2) throws IOException {
        FileUtils.requireDirectoryExists(file, "directory");
        if (file2 == null || !file2.exists()) {
            return false;
        }
        return FilenameUtils.directoryContains(file.getCanonicalPath(), file2.getCanonicalPath());
    }

    private static void doCopyDirectory(File file, File file2, FileFilter fileFilter, List<String> list, boolean bl2, CopyOption ... copyOptionArray) throws IOException {
        File[] fileArray = FileUtils.listFiles(file, fileFilter);
        FileUtils.requireDirectoryIfExists(file2, "destDir");
        FileUtils.mkdirs(file2);
        for (File file3 : fileArray) {
            File file4 = new File(file2, file3.getName());
            if (list != null && list.contains(file3.getCanonicalPath())) continue;
            if (file3.isDirectory()) {
                FileUtils.doCopyDirectory(file3, file4, fileFilter, list, bl2, copyOptionArray);
                continue;
            }
            FileUtils.copyFile(file3, file4, bl2, copyOptionArray);
        }
        if (bl2) {
            FileUtils.setTimes(file, file2);
        }
    }

    public static void forceDelete(File file) throws IOException {
        FileUtils.forceDelete(file, true);
    }

    private static void forceDelete(File serializable, boolean bl2) throws IOException {
        Counters$PathCounters counters$PathCounters;
        FileUtils.checkExists(serializable, bl2);
        try {
            counters$PathCounters = PathUtils.delete(serializable.toPath(), PathUtils.EMPTY_LINK_OPTION_ARRAY, StandardDeleteOption.OVERRIDE_READ_ONLY);
        }
        catch (NoSuchFileException noSuchFileException) {
            serializable = new FileNotFoundException("Cannot delete file: " + serializable);
            ((Throwable)serializable).initCause(noSuchFileException);
            throw serializable;
        }
        catch (IOException iOException) {
            throw new IOException("Cannot delete file: " + serializable, iOException);
        }
        if (counters$PathCounters.getFileCounter().get() < 1L && counters$PathCounters.getDirectoryCounter().get() < 1L) {
            throw new FileNotFoundException("File does not exist: " + serializable);
        }
    }

    public static void forceDeleteOnExit(File file) throws IOException {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        if (file.isDirectory()) {
            FileUtils.deleteDirectoryOnExit(file);
            return;
        }
        file.deleteOnExit();
    }

    public static void forceMkdir(File file) throws IOException {
        FileUtils.mkdirs(file);
    }

    public static void forceMkdirParent(File file) throws IOException {
        FileUtils.forceMkdir(FileUtils.getParentFile(Objects.requireNonNull(file, PROTOCOL_FILE)));
    }

    public static File getFile(File file, String ... stringArray) {
        Objects.requireNonNull(file, "directory");
        Objects.requireNonNull(stringArray, "names");
        for (String string : stringArray) {
            file = new File(file, string);
        }
        return file;
    }

    public static File getFile(String ... stringArray) {
        Objects.requireNonNull(stringArray, "names");
        File file = null;
        for (String string : stringArray) {
            file = file == null ? new File(string) : new File(file, string);
        }
        return file;
    }

    private static File getParentFile(File file) {
        if (file == null) {
            return null;
        }
        return file.getParentFile();
    }

    public static File getTempDirectory() {
        return new File(FileUtils.getTempDirectoryPath());
    }

    public static String getTempDirectoryPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getUserDirectory() {
        return new File(FileUtils.getUserDirectoryPath());
    }

    public static String getUserDirectoryPath() {
        return System.getProperty("user.home");
    }

    public static boolean isDirectory(File file, LinkOption ... linkOptionArray) {
        return file != null && Files.isDirectory(file.toPath(), linkOptionArray);
    }

    public static boolean isEmptyDirectory(File file) throws IOException {
        return PathUtils.isEmptyDirectory(file.toPath());
    }

    public static boolean isFileNewer(File file, ChronoLocalDate chronoLocalDate) {
        return FileUtils.isFileNewer(file, chronoLocalDate, LocalTime.MAX);
    }

    public static boolean isFileNewer(File file, ChronoLocalDate chronoLocalDate, LocalTime localTime) {
        Objects.requireNonNull(chronoLocalDate, "chronoLocalDate");
        Objects.requireNonNull(localTime, "localTime");
        return FileUtils.isFileNewer(file, chronoLocalDate.atTime(localTime));
    }

    public static boolean isFileNewer(File file, ChronoLocalDate chronoLocalDate, OffsetTime offsetTime) {
        Objects.requireNonNull(chronoLocalDate, "chronoLocalDate");
        Objects.requireNonNull(offsetTime, "offsetTime");
        return FileUtils.isFileNewer(file, chronoLocalDate.atTime(offsetTime.toLocalTime()));
    }

    public static boolean isFileNewer(File file, ChronoLocalDateTime<?> chronoLocalDateTime) {
        return FileUtils.isFileNewer(file, chronoLocalDateTime, ZoneId.systemDefault());
    }

    public static boolean isFileNewer(File file, ChronoLocalDateTime<?> chronoLocalDateTime, ZoneId zoneId) {
        Objects.requireNonNull(chronoLocalDateTime, "chronoLocalDateTime");
        Objects.requireNonNull(zoneId, "zoneId");
        return FileUtils.isFileNewer(file, chronoLocalDateTime.atZone(zoneId));
    }

    public static boolean isFileNewer(File file, ChronoZonedDateTime<?> chronoZonedDateTime) {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        Objects.requireNonNull(chronoZonedDateTime, "chronoZonedDateTime");
        return Uncheck.getAsBoolean(() -> PathUtils.isNewer(file.toPath(), chronoZonedDateTime, new LinkOption[0]));
    }

    public static boolean isFileNewer(File file, Date date) {
        Objects.requireNonNull(date, "date");
        return FileUtils.isFileNewer(file, date.getTime());
    }

    public static boolean isFileNewer(File file, File file2) {
        return Uncheck.getAsBoolean(() -> PathUtils.isNewer(file.toPath(), file2.toPath()));
    }

    public static boolean isFileNewer(File file, FileTime fileTime) throws IOException {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        return PathUtils.isNewer(file.toPath(), fileTime, new LinkOption[0]);
    }

    public static boolean isFileNewer(File file, Instant instant) {
        Objects.requireNonNull(instant, "instant");
        return Uncheck.getAsBoolean(() -> PathUtils.isNewer(file.toPath(), instant, new LinkOption[0]));
    }

    public static boolean isFileNewer(File file, long l2) {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        return Uncheck.getAsBoolean(() -> PathUtils.isNewer(file.toPath(), l2, new LinkOption[0]));
    }

    public static boolean isFileNewer(File file, OffsetDateTime offsetDateTime) {
        Objects.requireNonNull(offsetDateTime, "offsetDateTime");
        return FileUtils.isFileNewer(file, offsetDateTime.toInstant());
    }

    public static boolean isFileOlder(File file, ChronoLocalDate chronoLocalDate) {
        return FileUtils.isFileOlder(file, chronoLocalDate, LocalTime.MAX);
    }

    public static boolean isFileOlder(File file, ChronoLocalDate chronoLocalDate, LocalTime localTime) {
        Objects.requireNonNull(chronoLocalDate, "chronoLocalDate");
        Objects.requireNonNull(localTime, "localTime");
        return FileUtils.isFileOlder(file, chronoLocalDate.atTime(localTime));
    }

    public static boolean isFileOlder(File file, ChronoLocalDate chronoLocalDate, OffsetTime offsetTime) {
        Objects.requireNonNull(chronoLocalDate, "chronoLocalDate");
        Objects.requireNonNull(offsetTime, "offsetTime");
        return FileUtils.isFileOlder(file, chronoLocalDate.atTime(offsetTime.toLocalTime()));
    }

    public static boolean isFileOlder(File file, ChronoLocalDateTime<?> chronoLocalDateTime) {
        return FileUtils.isFileOlder(file, chronoLocalDateTime, ZoneId.systemDefault());
    }

    public static boolean isFileOlder(File file, ChronoLocalDateTime<?> chronoLocalDateTime, ZoneId zoneId) {
        Objects.requireNonNull(chronoLocalDateTime, "chronoLocalDateTime");
        Objects.requireNonNull(zoneId, "zoneId");
        return FileUtils.isFileOlder(file, chronoLocalDateTime.atZone(zoneId));
    }

    public static boolean isFileOlder(File file, ChronoZonedDateTime<?> chronoZonedDateTime) {
        Objects.requireNonNull(chronoZonedDateTime, "chronoZonedDateTime");
        return FileUtils.isFileOlder(file, chronoZonedDateTime.toInstant());
    }

    public static boolean isFileOlder(File file, Date date) {
        Objects.requireNonNull(date, "date");
        return FileUtils.isFileOlder(file, date.getTime());
    }

    public static boolean isFileOlder(File file, File file2) throws FileNotFoundException {
        return Uncheck.getAsBoolean(() -> PathUtils.isOlder(file.toPath(), file2.toPath()));
    }

    public static boolean isFileOlder(File file, FileTime fileTime) throws IOException {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        return PathUtils.isOlder(file.toPath(), fileTime, new LinkOption[0]);
    }

    public static boolean isFileOlder(File file, Instant instant) {
        Objects.requireNonNull(instant, "instant");
        return Uncheck.getAsBoolean(() -> PathUtils.isOlder(file.toPath(), instant, new LinkOption[0]));
    }

    public static boolean isFileOlder(File file, long l2) {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        return Uncheck.getAsBoolean(() -> PathUtils.isOlder(file.toPath(), l2, new LinkOption[0]));
    }

    public static boolean isFileOlder(File file, OffsetDateTime offsetDateTime) {
        Objects.requireNonNull(offsetDateTime, "offsetDateTime");
        return FileUtils.isFileOlder(file, offsetDateTime.toInstant());
    }

    private static boolean isFileProtocol(URL uRL) {
        return PROTOCOL_FILE.equalsIgnoreCase(uRL.getProtocol());
    }

    public static boolean isRegularFile(File file, LinkOption ... linkOptionArray) {
        return file != null && Files.isRegularFile(file.toPath(), linkOptionArray);
    }

    public static boolean isSymlink(File file) {
        return file != null && Files.isSymbolicLink(file.toPath());
    }

    public static Iterator<File> iterateFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.listFiles(file, iOFileFilter, iOFileFilter2).iterator();
    }

    public static Iterator<File> iterateFiles(File file, String[] stringArray, boolean bl2) {
        return StreamIterator.iterator(Uncheck.get(() -> FileUtils.streamFiles(file, bl2, stringArray)));
    }

    public static Iterator<File> iterateFilesAndDirs(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.listFilesAndDirs(file, iOFileFilter, iOFileFilter2).iterator();
    }

    public static long lastModified(File file) throws IOException {
        return FileUtils.lastModifiedFileTime(file).toMillis();
    }

    public static FileTime lastModifiedFileTime(File file) throws IOException {
        return Files.getLastModifiedTime(Objects.requireNonNull(file, PROTOCOL_FILE).toPath(), new LinkOption[0]);
    }

    public static long lastModifiedUnchecked(File file) {
        return Uncheck.apply(FileUtils::lastModified, file);
    }

    public static LineIterator lineIterator(File file) throws IOException {
        return FileUtils.lineIterator(file, null);
    }

    public static LineIterator lineIterator(File file, String string) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            return IOUtils.lineIterator(inputStream, string);
        }
        catch (IOException | RuntimeException exception) {
            IOUtils.closeQuietly((Closeable)inputStream, exception::addSuppressed);
            throw exception;
        }
    }

    private static AccumulatorPathVisitor listAccumulate(File file, IOFileFilter object, IOFileFilter object2, FileVisitOption ... fileVisitOptionArray) throws IOException {
        boolean bl2 = object2 != null;
        FileEqualsFileFilter fileEqualsFileFilter = new FileEqualsFileFilter(file);
        object2 = bl2 ? fileEqualsFileFilter.or((IOFileFilter)object2) : fileEqualsFileFilter;
        object = ((AccumulatorPathVisitor$Builder)((AccumulatorPathVisitor$Builder)((AccumulatorPathVisitor$Builder)((AccumulatorPathVisitor$Builder)AccumulatorPathVisitor.builder().setPathCounters(Counters.noopPathCounters())).setFileFilter((PathFilter)object)).setDirectoryFilter((PathFilter)object2)).setVisitFileFailedFunction((path, iOException) -> FileVisitResult.CONTINUE)).get();
        object2 = new HashSet();
        if (fileVisitOptionArray != null) {
            Collections.addAll(object2, fileVisitOptionArray);
        }
        Files.walkFileTree(file.toPath(), (Set<FileVisitOption>)object2, FileUtils.toMaxDepth(bl2), (FileVisitor<? super Path>)object);
        return object;
    }

    private static File[] listFiles(File file, FileFilter fileArray) throws IOException {
        FileUtils.requireDirectoryExists(file, "directory");
        fileArray = file.listFiles((FileFilter)fileArray);
        if (fileArray == null) {
            throw new IOException("Unknown I/O error listing contents of directory: " + file);
        }
        return fileArray;
    }

    public static Collection<File> listFiles(File object, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        object = Uncheck.apply(file -> FileUtils.listAccumulate(file, FileFileFilter.INSTANCE.and(iOFileFilter), iOFileFilter2, FileVisitOption.FOLLOW_LINKS), object);
        return FileUtils.toList(((AccumulatorPathVisitor)object).getFileList().stream().map(Path::toFile));
    }

    private static void listFiles(File file3, List<File> list, boolean bl2, FilenameFilter filenameFilter) {
        File[] fileArray = file3.listFiles();
        if (fileArray != null) {
            ArrayList arrayList = bl2 ? new ArrayList() : null;
            Arrays.stream(fileArray).forEach(file2 -> {
                if (bl2 && file2.isDirectory()) {
                    arrayList.add(file2);
                    return;
                }
                if (file2.isFile() && filenameFilter.accept(file3, file2.getName())) {
                    list.add((File)file2);
                }
            });
            if (bl2) {
                arrayList.forEach(file -> FileUtils.listFiles(file, list, true, filenameFilter));
            }
        }
    }

    public static Collection<File> listFiles(File file, String[] object, boolean bl2) {
        ArrayList<File> arrayList = new ArrayList<File>();
        object = object != null ? FileUtils.toSuffixFileFilter(object) : TrueFileFilter.INSTANCE;
        FileUtils.listFiles(file, arrayList, bl2, (FilenameFilter)object);
        return arrayList;
    }

    public static Collection<File> listFilesAndDirs(File object, IOFileFilter object2, IOFileFilter iOFileFilter) {
        object = Uncheck.apply(arg_0 -> FileUtils.lambda$listFilesAndDirs$13((IOFileFilter)object2, iOFileFilter, arg_0), object);
        object2 = ((AccumulatorPathVisitor)object).getFileList();
        object2.addAll(((AccumulatorPathVisitor)object).getDirList());
        return FileUtils.toList(object2.stream().map(Path::toFile));
    }

    private static File mkdirs(File file) throws IOException {
        if (file != null && !file.mkdirs() && !file.isDirectory()) {
            throw new IOException("Cannot create directory '" + file + "'.");
        }
        return file;
    }

    public static void moveDirectory(File file, File file2) throws IOException {
        Objects.requireNonNull(file2, "destination");
        FileUtils.requireDirectoryExists(file, "srcDir");
        FileUtils.requireAbsent(file2, "destDir");
        if (!file.renameTo(file2)) {
            if (file2.getCanonicalPath().startsWith(file.getCanonicalPath() + File.separator)) {
                throw new IOException("Cannot move directory: " + file + " to a subdirectory of itself: " + file2);
            }
            FileUtils.copyDirectory(file, file2);
            FileUtils.deleteDirectory(file);
            if (file.exists()) {
                throw new IOException("Failed to delete original directory '" + file + "' after copy to '" + file2 + "'");
            }
        }
    }

    public static void moveDirectoryToDirectory(File file, File file2, boolean bl2) throws IOException {
        FileUtils.validateMoveParameters(file, file2);
        if (!file2.isDirectory()) {
            if (file2.exists()) {
                throw new IOException("Destination '" + file2 + "' is not a directory");
            }
            if (!bl2) {
                throw new FileNotFoundException("Destination directory '" + file2 + "' does not exist [createDestDir=false" + "]");
            }
            FileUtils.mkdirs(file2);
        }
        FileUtils.moveDirectory(file, new File(file2, file.getName()));
    }

    public static void moveFile(File file, File file2) throws IOException {
        FileUtils.moveFile(file, file2, StandardCopyOption.COPY_ATTRIBUTES);
    }

    public static void moveFile(File file, File file2, CopyOption ... copyOptionArray) throws IOException {
        Objects.requireNonNull(file2, "destFile");
        FileUtils.checkFileExists(file, "srcFile");
        FileUtils.requireAbsent(file2, "destFile");
        boolean bl2 = file.renameTo(file2);
        if (!bl2) {
            FileUtils.copyFile(file, file2, false, copyOptionArray);
            if (!file.delete()) {
                FileUtils.deleteQuietly(file2);
                throw new IOException("Failed to delete original file '" + file + "' after copy to '" + file2 + "'");
            }
        }
    }

    public static void moveFileToDirectory(File file, File file2, boolean bl2) throws IOException {
        FileUtils.validateMoveParameters(file, file2);
        if (!file2.exists() && bl2) {
            FileUtils.mkdirs(file2);
        }
        FileUtils.requireDirectoryExists(file2, "destDir");
        FileUtils.moveFile(file, new File(file2, file.getName()));
    }

    public static void moveToDirectory(File file, File file2, boolean bl2) throws IOException {
        FileUtils.validateMoveParameters(file, file2);
        if (file.isDirectory()) {
            FileUtils.moveDirectoryToDirectory(file, file2, bl2);
            return;
        }
        FileUtils.moveFileToDirectory(file, file2, bl2);
    }

    public static OutputStream newOutputStream(File file, boolean bl2) throws IOException {
        return PathUtils.newOutputStream(Objects.requireNonNull(file, PROTOCOL_FILE).toPath(), bl2);
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        return FileUtils.openOutputStream(file, false);
    }

    public static FileOutputStream openOutputStream(File file, boolean bl2) throws IOException {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        if (file.exists()) {
            FileUtils.checkIsFile(file, PROTOCOL_FILE);
        } else {
            FileUtils.createParentDirectories(file);
        }
        return new FileOutputStream(file, bl2);
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        return Files.readAllBytes(file.toPath());
    }

    @Deprecated
    public static String readFileToString(File file) throws IOException {
        return FileUtils.readFileToString(file, Charset.defaultCharset());
    }

    public static String readFileToString(File file, Charset charset) throws IOException {
        return IOUtils.toString(() -> Files.newInputStream(file.toPath(), new OpenOption[0]), Charsets.toCharset(charset));
    }

    public static String readFileToString(File file, String string) throws IOException {
        return FileUtils.readFileToString(file, Charsets.toCharset(string));
    }

    @Deprecated
    public static List<String> readLines(File file) throws IOException {
        return FileUtils.readLines(file, Charset.defaultCharset());
    }

    public static List<String> readLines(File file, Charset charset) throws IOException {
        return Files.readAllLines(file.toPath(), Charsets.toCharset(charset));
    }

    public static List<String> readLines(File file, String string) throws IOException {
        return FileUtils.readLines(file, Charsets.toCharset(string));
    }

    private static void requireAbsent(File file, String string) throws FileExistsException {
        if (file.exists()) {
            throw new FileExistsException(String.format("File element in parameter '%s' already exists: '%s'", string, file));
        }
    }

    private static void requireCanonicalPathsNotEquals(File file, File file2) throws IOException {
        String string = file.getCanonicalPath();
        if (string.equals(file2.getCanonicalPath())) {
            throw new IllegalArgumentException(String.format("File canonical paths are equal: '%s' (file1='%s', file2='%s')", string, file, file2));
        }
    }

    private static void requireDirectoryExists(File file, String string) throws FileNotFoundException {
        Objects.requireNonNull(file, string);
        if (!file.isDirectory()) {
            if (file.exists()) {
                throw new IllegalArgumentException("Parameter '" + string + "' is not a directory: '" + file + "'");
            }
            throw new FileNotFoundException("Directory '" + file + "' does not exist.");
        }
    }

    private static void requireDirectoryIfExists(File file, String string) {
        Objects.requireNonNull(file, string);
        if (file.exists() && !file.isDirectory()) {
            throw new IllegalArgumentException("Parameter '" + string + "' is not a directory: '" + file + "'");
        }
    }

    private static boolean setTimes(File file, File file2) {
        Objects.requireNonNull(file, "sourceFile");
        Objects.requireNonNull(file2, "targetFile");
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            BasicFileAttributeView basicFileAttributeView = Files.getFileAttributeView(file2.toPath(), BasicFileAttributeView.class, new LinkOption[0]);
            basicFileAttributeView.setTimes(basicFileAttributes.lastModifiedTime(), basicFileAttributes.lastAccessTime(), basicFileAttributes.creationTime());
            return true;
        }
        catch (IOException iOException) {
            return file2.setLastModified(file.lastModified());
        }
    }

    public static long sizeOf(File file) {
        return Uncheck.getAsLong(() -> PathUtils.sizeOf(file.toPath()));
    }

    public static BigInteger sizeOfAsBigInteger(File file) {
        return Uncheck.get(() -> PathUtils.sizeOfAsBigInteger(file.toPath()));
    }

    public static long sizeOfDirectory(File file) {
        try {
            FileUtils.requireDirectoryExists(file, "directory");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UncheckedIOException(fileNotFoundException);
        }
        return Uncheck.getAsLong(() -> PathUtils.sizeOfDirectory(file.toPath()));
    }

    public static BigInteger sizeOfDirectoryAsBigInteger(File file) {
        try {
            FileUtils.requireDirectoryExists(file, "directory");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UncheckedIOException(fileNotFoundException);
        }
        return Uncheck.get(() -> PathUtils.sizeOfDirectoryAsBigInteger(file.toPath()));
    }

    public static Stream<File> streamFiles(File file, boolean bl2, String ... object) throws IOException {
        object = object == null ? FileFileFilter.INSTANCE : FileFileFilter.INSTANCE.and(FileUtils.toSuffixFileFilter(object));
        return PathUtils.walk(file.toPath(), (PathFilter)object, FileUtils.toMaxDepth(bl2), false, FileVisitOption.FOLLOW_LINKS).map(Path::toFile);
    }

    public static File toFile(URL object) {
        if (object == null || !FileUtils.isFileProtocol((URL)object)) {
            return null;
        }
        object = ((URL)object).getFile().replace('/', File.separatorChar);
        return new File(FileUtils.decodeUrl((String)object));
    }

    public static File[] toFiles(URL ... uRLArray) {
        if (IOUtils.length(uRLArray) == 0) {
            return EMPTY_FILE_ARRAY;
        }
        File[] fileArray = new File[uRLArray.length];
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            URL uRL = uRLArray[i2];
            if (uRL == null) continue;
            if (!FileUtils.isFileProtocol(uRL)) {
                throw new IllegalArgumentException("Can only convert file URL to a File: " + uRL);
            }
            fileArray[i2] = FileUtils.toFile(uRL);
        }
        return fileArray;
    }

    private static List<File> toList(Stream<File> stream) {
        return stream.collect(Collectors.toList());
    }

    private static int toMaxDepth(boolean bl2) {
        if (bl2) {
            return Integer.MAX_VALUE;
        }
        return 1;
    }

    private static String[] toSuffixes(String ... stringArray) {
        return (String[])Stream.of(Objects.requireNonNull(stringArray, "extensions")).map(string -> {
            if (string.charAt(0) == '.') {
                return string;
            }
            return "." + string;
        }).toArray(String[]::new);
    }

    private static SuffixFileFilter toSuffixFileFilter(String ... stringArray) {
        return new SuffixFileFilter(FileUtils.toSuffixes(stringArray));
    }

    public static void touch(File file) throws IOException {
        PathUtils.touch(Objects.requireNonNull(file, PROTOCOL_FILE).toPath());
    }

    public static URL[] toURLs(File ... fileArray) throws IOException {
        Objects.requireNonNull(fileArray, "files");
        URL[] uRLArray = new URL[fileArray.length];
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            uRLArray[i2] = fileArray[i2].toURI().toURL();
        }
        return uRLArray;
    }

    private static void validateMoveParameters(File file, File file2) throws FileNotFoundException {
        Objects.requireNonNull(file, "source");
        Objects.requireNonNull(file2, "destination");
        if (!file.exists()) {
            throw new FileNotFoundException("Source '" + file + "' does not exist");
        }
    }

    public static boolean waitFor(File file, int n2) {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        return PathUtils.waitFor(file.toPath(), Duration.ofSeconds(n2), PathUtils.EMPTY_LINK_OPTION_ARRAY);
    }

    @Deprecated
    public static void write(File file, CharSequence charSequence) throws IOException {
        FileUtils.write(file, charSequence, Charset.defaultCharset(), false);
    }

    @Deprecated
    public static void write(File file, CharSequence charSequence, boolean bl2) throws IOException {
        FileUtils.write(file, charSequence, Charset.defaultCharset(), bl2);
    }

    public static void write(File file, CharSequence charSequence, Charset charset) throws IOException {
        FileUtils.write(file, charSequence, charset, false);
    }

    public static void write(File file, CharSequence charSequence, Charset charset, boolean bl2) throws IOException {
        FileUtils.writeStringToFile(file, Objects.toString(charSequence, null), charset, bl2);
    }

    public static void write(File file, CharSequence charSequence, String string) throws IOException {
        FileUtils.write(file, charSequence, string, false);
    }

    public static void write(File file, CharSequence charSequence, String string, boolean bl2) throws IOException {
        FileUtils.write(file, charSequence, Charsets.toCharset(string), bl2);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray) throws IOException {
        FileUtils.writeByteArrayToFile(file, byArray, false);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray, boolean bl2) throws IOException {
        FileUtils.writeByteArrayToFile(file, byArray, 0, byArray.length, bl2);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray, int n2, int n3) throws IOException {
        FileUtils.writeByteArrayToFile(file, byArray, n2, n3, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeByteArrayToFile(File object, byte[] byArray, int n2, int n3, boolean bl2) throws IOException {
        object = FileUtils.newOutputStream((File)object, bl2);
        try {
            ((OutputStream)object).write(byArray, n2, n3);
            if (object == null) return;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            try {
                ((OutputStream)object).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((OutputStream)object).close();
    }

    public static void writeLines(File file, Collection<?> collection) throws IOException {
        FileUtils.writeLines(file, null, collection, null, false);
    }

    public static void writeLines(File file, Collection<?> collection, boolean bl2) throws IOException {
        FileUtils.writeLines(file, null, collection, null, bl2);
    }

    public static void writeLines(File file, Collection<?> collection, String string) throws IOException {
        FileUtils.writeLines(file, null, collection, string, false);
    }

    public static void writeLines(File file, Collection<?> collection, String string, boolean bl2) throws IOException {
        FileUtils.writeLines(file, null, collection, string, bl2);
    }

    public static void writeLines(File file, String string, Collection<?> collection) throws IOException {
        FileUtils.writeLines(file, string, collection, null, false);
    }

    public static void writeLines(File file, String string, Collection<?> collection, boolean bl2) throws IOException {
        FileUtils.writeLines(file, string, collection, null, bl2);
    }

    public static void writeLines(File file, String string, Collection<?> collection, String string2) throws IOException {
        FileUtils.writeLines(file, string, collection, string2, false);
    }

    public static void writeLines(File object, String string, Collection<?> collection, String string2, boolean bl2) throws IOException {
        object = new BufferedOutputStream(FileUtils.newOutputStream((File)object, bl2));
        try {
            IOUtils.writeLines(collection, string2, (OutputStream)object, string);
            return;
        }
        finally {
            ((OutputStream)object).close();
        }
    }

    @Deprecated
    public static void writeStringToFile(File file, String string) throws IOException {
        FileUtils.writeStringToFile(file, string, Charset.defaultCharset(), false);
    }

    @Deprecated
    public static void writeStringToFile(File file, String string, boolean bl2) throws IOException {
        FileUtils.writeStringToFile(file, string, Charset.defaultCharset(), bl2);
    }

    public static void writeStringToFile(File file, String string, Charset charset) throws IOException {
        FileUtils.writeStringToFile(file, string, charset, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeStringToFile(File object, String string, Charset charset, boolean bl2) throws IOException {
        object = FileUtils.newOutputStream((File)object, bl2);
        try {
            IOUtils.write(string, (OutputStream)object, charset);
            if (object == null) return;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            try {
                ((OutputStream)object).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((OutputStream)object).close();
    }

    public static void writeStringToFile(File file, String string, String string2) throws IOException {
        FileUtils.writeStringToFile(file, string, string2, false);
    }

    public static void writeStringToFile(File file, String string, String string2, boolean bl2) throws IOException {
        FileUtils.writeStringToFile(file, string, Charsets.toCharset(string2), bl2);
    }

    @Deprecated
    public FileUtils() {
    }

    private static /* synthetic */ AccumulatorPathVisitor lambda$listFilesAndDirs$13(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2, File file) throws IOException {
        return FileUtils.listAccumulate(file, iOFileFilter, iOFileFilter2, FileVisitOption.FOLLOW_LINKS);
    }
}

