/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.io.output.CloseShieldOutputStream;

public class HexDump {
    @Deprecated
    public static final String EOL = System.lineSeparator();
    private static final char[] HEX_CODES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] SHIFTS = new int[]{28, 24, 20, 16, 12, 8, 4, 0};

    public static void dump(byte[] byArray, Appendable appendable) throws IOException {
        HexDump.dump(byArray, 0L, appendable, 0, byArray.length);
    }

    public static void dump(byte[] byArray, long l2, Appendable appendable, int n2, int n3) throws IOException, ArrayIndexOutOfBoundsException {
        Objects.requireNonNull(appendable, "appendable");
        if (n2 < 0 || n2 >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + n2 + " into array of length " + byArray.length);
        }
        long l3 = l2 + (long)n2;
        StringBuilder stringBuilder = new StringBuilder(74);
        if (n3 < 0 || n2 + n3 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException(String.format("Range [%s, %<s + %s) out of bounds for length %s", n2, n3, byArray.length));
        }
        int n4 = n2 + n3;
        while (n2 < n4) {
            int n5;
            n3 = n4 - n2;
            if (n3 > 16) {
                n3 = 16;
            }
            HexDump.dump(stringBuilder, l3).append(' ');
            for (n5 = 0; n5 < 16; ++n5) {
                if (n5 < n3) {
                    HexDump.dump(stringBuilder, byArray[n5 + n2]);
                } else {
                    stringBuilder.append("  ");
                }
                stringBuilder.append(' ');
            }
            for (n5 = 0; n5 < n3; ++n5) {
                if (byArray[n5 + n2] >= 32 && byArray[n5 + n2] < 127) {
                    stringBuilder.append((char)byArray[n5 + n2]);
                    continue;
                }
                stringBuilder.append('.');
            }
            stringBuilder.append(System.lineSeparator());
            appendable.append(stringBuilder);
            stringBuilder.setLength(0);
            l3 += (long)n3;
            n2 += 16;
        }
    }

    public static void dump(byte[] byArray, long l2, OutputStream closeable, int n2) throws IOException, ArrayIndexOutOfBoundsException {
        Objects.requireNonNull(closeable, "stream");
        closeable = new OutputStreamWriter((OutputStream)CloseShieldOutputStream.wrap((OutputStream)closeable), Charset.defaultCharset());
        try {
            HexDump.dump(byArray, l2, (Appendable)((Object)closeable), n2, byArray.length - n2);
            return;
        }
        finally {
            ((OutputStreamWriter)closeable).close();
        }
    }

    private static StringBuilder dump(StringBuilder stringBuilder, byte by2) {
        for (int i2 = 0; i2 < 2; ++i2) {
            stringBuilder.append(HEX_CODES[by2 >> SHIFTS[i2 + 6] & 0xF]);
        }
        return stringBuilder;
    }

    private static StringBuilder dump(StringBuilder stringBuilder, long l2) {
        for (int i2 = 0; i2 < 8; ++i2) {
            stringBuilder.append(HEX_CODES[(int)(l2 >> SHIFTS[i2]) & 0xF]);
        }
        return stringBuilder;
    }
}

