/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.FileSystem;

public enum IOCase {
    SENSITIVE("Sensitive", true),
    INSENSITIVE("Insensitive", false),
    SYSTEM("System", FileSystem.getCurrent().isCaseSensitive());

    private static final long serialVersionUID = -6343169151696340687L;
    private final String name;
    private final transient boolean sensitive;

    public static IOCase forName(String string) {
        return Stream.of(IOCase.values()).filter(iOCase -> iOCase.getName().equals(string)).findFirst().orElseThrow(() -> new IllegalArgumentException("Illegal IOCase name: " + string));
    }

    public static boolean isCaseSensitive(IOCase iOCase) {
        return iOCase != null && iOCase.isCaseSensitive();
    }

    public static IOCase value(IOCase iOCase, IOCase iOCase2) {
        if (iOCase != null) {
            return iOCase;
        }
        return iOCase2;
    }

    private IOCase(String string2, boolean bl2) {
        this.name = string2;
        this.sensitive = bl2;
    }

    public final int checkCompareTo(String string, String string2) {
        Objects.requireNonNull(string, "str1");
        Objects.requireNonNull(string2, "str2");
        if (this.sensitive) {
            return string.compareTo(string2);
        }
        return string.compareToIgnoreCase(string2);
    }

    public final boolean checkEndsWith(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n2 = string2.length();
        return string.regionMatches(!this.sensitive, string.length() - n2, string2, 0, n2);
    }

    public final boolean checkEquals(String string, String string2) {
        return string == string2 || string != null && (this.sensitive ? string.equals(string2) : string.equalsIgnoreCase(string2));
    }

    public final int checkIndexOf(String string, int n2, String string2) {
        int n3;
        if (string != null && string2 != null && (n3 = string.length() - string2.length()) >= n2) {
            while (n2 <= n3) {
                if (this.checkRegionMatches(string, n2, string2)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public final boolean checkRegionMatches(String string, int n2, String string2) {
        return string != null && string2 != null && string.regionMatches(!this.sensitive, n2, string2, 0, string2.length());
    }

    public final boolean checkStartsWith(String string, String string2) {
        return string != null && string2 != null && string.regionMatches(!this.sensitive, 0, string2, 0, string2.length());
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isCaseSensitive() {
        return this.sensitive;
    }

    private Object readResolve() {
        return IOCase.forName(this.name);
    }

    public final String toString() {
        return this.name;
    }
}

