/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.apache.commons.io.IORandomAccessFile;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOFunction;

public enum RandomAccessFileMode {
    READ_ONLY("r", 1),
    READ_WRITE("rw", 2),
    READ_WRITE_SYNC_ALL("rws", 4),
    READ_WRITE_SYNC_CONTENT("rwd", 3);

    private static final String R = "r";
    private static final String RW = "rw";
    private static final String RWD = "rwd";
    private static final String RWS = "rws";
    private final int level;
    private final String mode;

    public static RandomAccessFileMode valueOf(OpenOption ... openOptionArray) {
        RandomAccessFileMode randomAccessFileMode = READ_ONLY;
        block5: for (OpenOption openOption : openOptionArray) {
            if (!(openOption instanceof StandardOpenOption)) continue;
            switch ((StandardOpenOption)openOption) {
                case WRITE: {
                    if (randomAccessFileMode.implies(READ_WRITE)) continue block5;
                    randomAccessFileMode = READ_WRITE;
                    continue block5;
                }
                case DSYNC: {
                    if (randomAccessFileMode.implies(READ_WRITE_SYNC_CONTENT)) continue block5;
                    randomAccessFileMode = READ_WRITE_SYNC_CONTENT;
                    continue block5;
                }
                case SYNC: {
                    if (randomAccessFileMode.implies(READ_WRITE_SYNC_ALL)) continue block5;
                    randomAccessFileMode = READ_WRITE_SYNC_ALL;
                }
            }
        }
        return randomAccessFileMode;
    }

    public static RandomAccessFileMode valueOfMode(String string) {
        switch (string) {
            case "r": {
                return READ_ONLY;
            }
            case "rw": {
                return READ_WRITE;
            }
            case "rwd": {
                return READ_WRITE_SYNC_CONTENT;
            }
            case "rws": {
                return READ_WRITE_SYNC_ALL;
            }
        }
        throw new IllegalArgumentException(string);
    }

    private RandomAccessFileMode(String string2, int n3) {
        this.mode = string2;
        this.level = n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void accept(Path object, IOConsumer<RandomAccessFile> iOConsumer) throws IOException {
        object = this.create((Path)object);
        try {
            iOConsumer.accept((RandomAccessFile)object);
            if (object == null) return;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            try {
                ((RandomAccessFile)object).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((RandomAccessFile)object).close();
    }

    public final <T> T apply(Path object, IOFunction<RandomAccessFile, T> iOFunction) throws IOException {
        object = this.create((Path)object);
        try {
            iOFunction = iOFunction.apply((RandomAccessFile)object);
            return (T)iOFunction;
        }
        finally {
            if (object != null) {
                ((RandomAccessFile)object).close();
            }
        }
    }

    public final RandomAccessFile create(File file) throws FileNotFoundException {
        return new IORandomAccessFile(file, this.mode);
    }

    public final RandomAccessFile create(Path path) throws FileNotFoundException {
        return this.create(Objects.requireNonNull(path.toFile(), "file"));
    }

    public final RandomAccessFile create(String string) throws FileNotFoundException {
        return new IORandomAccessFile(string, this.mode);
    }

    private int getLevel() {
        return this.level;
    }

    public final String getMode() {
        return this.mode;
    }

    public final boolean implies(RandomAccessFileMode randomAccessFileMode) {
        return this.getLevel() >= randomAccessFileMode.getLevel();
    }

    public final IORandomAccessFile io(String string) throws FileNotFoundException {
        return new IORandomAccessFile(string, this.mode);
    }
}

