/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.IntUnaryOperator;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.build.AbstractOriginSupplier;
import org.apache.commons.io.file.PathUtils;

public abstract class AbstractStreamBuilder<T, B extends AbstractStreamBuilder<T, B>>
extends AbstractOriginSupplier<T, B> {
    private static final int DEFAULT_MAX_VALUE = Integer.MAX_VALUE;
    private static final OpenOption[] DEFAULT_OPEN_OPTIONS = PathUtils.EMPTY_OPEN_OPTION_ARRAY;
    private int bufferSize = 8192;
    private int bufferSizeDefault = 8192;
    private int bufferSizeMax = Integer.MAX_VALUE;
    private Charset charset = Charset.defaultCharset();
    private Charset charsetDefault = Charset.defaultCharset();
    private OpenOption[] openOptions = DEFAULT_OPEN_OPTIONS;
    private final IntUnaryOperator defaultSizeChecker;
    private IntUnaryOperator bufferSizeChecker = this.defaultSizeChecker = n2 -> {
        if (n2 > this.bufferSizeMax) {
            return this.throwIae(n2, this.bufferSizeMax);
        }
        return n2;
    };

    private int checkBufferSize(int n2) {
        return this.bufferSizeChecker.applyAsInt(n2);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getBufferSizeDefault() {
        return this.bufferSizeDefault;
    }

    public CharSequence getCharSequence() throws IOException {
        return this.checkOrigin().getCharSequence(this.getCharset());
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Charset getCharsetDefault() {
        return this.charsetDefault;
    }

    public File getFile() {
        return this.checkOrigin().getFile();
    }

    public InputStream getInputStream() throws IOException {
        return this.checkOrigin().getInputStream(this.getOpenOptions());
    }

    public OpenOption[] getOpenOptions() {
        return this.openOptions;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.checkOrigin().getOutputStream(this.getOpenOptions());
    }

    public Path getPath() {
        return this.checkOrigin().getPath();
    }

    public RandomAccessFile getRandomAccessFile() throws IOException {
        return this.checkOrigin().getRandomAccessFile(this.getOpenOptions());
    }

    public Reader getReader() throws IOException {
        return this.checkOrigin().getReader(this.getCharset());
    }

    public Writer getWriter() throws IOException {
        return this.checkOrigin().getWriter(this.getCharset(), this.getOpenOptions());
    }

    public B setBufferSize(int n2) {
        this.bufferSize = this.checkBufferSize(n2 > 0 ? n2 : this.bufferSizeDefault);
        return (B)((AbstractStreamBuilder)this.asThis());
    }

    public B setBufferSize(Integer n2) {
        this.setBufferSize(n2 != null ? n2 : this.bufferSizeDefault);
        return (B)((AbstractStreamBuilder)this.asThis());
    }

    public B setBufferSizeChecker(IntUnaryOperator intUnaryOperator) {
        this.bufferSizeChecker = intUnaryOperator != null ? intUnaryOperator : this.defaultSizeChecker;
        return (B)((AbstractStreamBuilder)this.asThis());
    }

    protected B setBufferSizeDefault(int n2) {
        this.bufferSizeDefault = n2;
        return (B)((AbstractStreamBuilder)this.asThis());
    }

    public B setBufferSizeMax(int n2) {
        this.bufferSizeMax = n2 > 0 ? n2 : Integer.MAX_VALUE;
        return (B)((AbstractStreamBuilder)this.asThis());
    }

    public B setCharset(Charset charset) {
        this.charset = Charsets.toCharset(charset, this.charsetDefault);
        return (B)((AbstractStreamBuilder)this.asThis());
    }

    public B setCharset(String string) {
        return this.setCharset(Charsets.toCharset(string, this.charsetDefault));
    }

    protected B setCharsetDefault(Charset charset) {
        this.charsetDefault = charset;
        return (B)((AbstractStreamBuilder)this.asThis());
    }

    public B setOpenOptions(OpenOption ... openOptionArray) {
        this.openOptions = openOptionArray != null ? openOptionArray : DEFAULT_OPEN_OPTIONS;
        return (B)((AbstractStreamBuilder)this.asThis());
    }

    private int throwIae(int n2, int n3) {
        throw new IllegalArgumentException(String.format("Request %,d exceeds maximum %,d", n2, n3));
    }
}

