/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.comparator.AbstractFileComparator;

public class CompositeFileComparator
extends AbstractFileComparator
implements Serializable {
    private static final Comparator<?>[] EMPTY_COMPARATOR_ARRAY = new Comparator[0];
    private static final long serialVersionUID = -2224170307287243428L;
    private final Comparator<File>[] delegates;

    public CompositeFileComparator(Comparator<File> ... comparatorArray) {
        this.delegates = comparatorArray == null ? this.emptyArray() : (Comparator[])comparatorArray.clone();
    }

    public CompositeFileComparator(Iterable<Comparator<File>> iterable) {
        this.delegates = iterable == null ? this.emptyArray() : (Comparator[])StreamSupport.stream(iterable.spliterator(), false).toArray(Comparator[]::new);
    }

    @Override
    public int compare(File file, File file2) {
        return Stream.of(this.delegates).map(comparator -> comparator.compare(file, file2)).filter(n2 -> n2 != 0).findFirst().orElse(0);
    }

    private Comparator<File>[] emptyArray() {
        return EMPTY_COMPARATOR_ARRAY;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append(Arrays.toString(this.delegates));
        return stringBuilder.toString();
    }
}

