/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.file.AccumulatorPathVisitor$1;
import org.apache.commons.io.file.AccumulatorPathVisitor$Builder;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.Counters$PathCounters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.function.IOBiFunction;

public class AccumulatorPathVisitor
extends CountingPathVisitor {
    private final List<Path> dirList = new ArrayList<Path>();
    private final List<Path> fileList = new ArrayList<Path>();

    public static AccumulatorPathVisitor$Builder builder() {
        return new AccumulatorPathVisitor$Builder();
    }

    public static AccumulatorPathVisitor withBigIntegerCounters() {
        return ((AccumulatorPathVisitor$Builder)AccumulatorPathVisitor.builder().setPathCounters(Counters.bigIntegerPathCounters())).get();
    }

    public static AccumulatorPathVisitor withBigIntegerCounters(PathFilter pathFilter, PathFilter pathFilter2) {
        return ((AccumulatorPathVisitor$Builder)((AccumulatorPathVisitor$Builder)((AccumulatorPathVisitor$Builder)AccumulatorPathVisitor.builder().setPathCounters(Counters.bigIntegerPathCounters())).setFileFilter(pathFilter)).setDirectoryFilter(pathFilter2)).get();
    }

    public static AccumulatorPathVisitor withLongCounters() {
        return ((AccumulatorPathVisitor$Builder)AccumulatorPathVisitor.builder().setPathCounters(Counters.longPathCounters())).get();
    }

    public static AccumulatorPathVisitor withLongCounters(PathFilter pathFilter, PathFilter pathFilter2) {
        return ((AccumulatorPathVisitor$Builder)((AccumulatorPathVisitor$Builder)((AccumulatorPathVisitor$Builder)AccumulatorPathVisitor.builder().setPathCounters(Counters.longPathCounters())).setFileFilter(pathFilter)).setDirectoryFilter(pathFilter2)).get();
    }

    @Deprecated
    public AccumulatorPathVisitor() {
        super(Counters.noopPathCounters());
    }

    private AccumulatorPathVisitor(AccumulatorPathVisitor$Builder accumulatorPathVisitor$Builder) {
        super(accumulatorPathVisitor$Builder);
    }

    @Deprecated
    public AccumulatorPathVisitor(Counters$PathCounters counters$PathCounters) {
        super(counters$PathCounters);
    }

    @Deprecated
    public AccumulatorPathVisitor(Counters$PathCounters counters$PathCounters, PathFilter pathFilter, PathFilter pathFilter2) {
        super(counters$PathCounters, pathFilter, pathFilter2);
    }

    @Deprecated
    public AccumulatorPathVisitor(Counters$PathCounters counters$PathCounters, PathFilter pathFilter, PathFilter pathFilter2, IOBiFunction<Path, IOException, FileVisitResult> iOBiFunction) {
        super(counters$PathCounters, pathFilter, pathFilter2, iOBiFunction);
    }

    private void add(List<Path> list, Path path) {
        list.add(path.normalize());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof AccumulatorPathVisitor)) {
            return false;
        }
        object = (AccumulatorPathVisitor)object;
        return Objects.equals(this.dirList, ((AccumulatorPathVisitor)object).dirList) && Objects.equals(this.fileList, ((AccumulatorPathVisitor)object).fileList);
    }

    public List<Path> getDirList() {
        return new ArrayList<Path>(this.dirList);
    }

    public List<Path> getFileList() {
        return new ArrayList<Path>(this.fileList);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = n2 * 31 + Objects.hash(this.dirList, this.fileList);
        return n2;
    }

    public List<Path> relativizeDirectories(Path path, boolean bl2, Comparator<? super Path> comparator) {
        return PathUtils.relativize(this.getDirList(), path, bl2, comparator);
    }

    public List<Path> relativizeFiles(Path path, boolean bl2, Comparator<? super Path> comparator) {
        return PathUtils.relativize(this.getFileList(), path, bl2, comparator);
    }

    @Override
    protected void updateDirCounter(Path path, IOException iOException) {
        super.updateDirCounter(path, iOException);
        AccumulatorPathVisitor accumulatorPathVisitor = this;
        accumulatorPathVisitor.add(accumulatorPathVisitor.dirList, path);
    }

    @Override
    protected void updateFileCounters(Path path, BasicFileAttributes basicFileAttributes) {
        super.updateFileCounters(path, basicFileAttributes);
        AccumulatorPathVisitor accumulatorPathVisitor = this;
        accumulatorPathVisitor.add(accumulatorPathVisitor.fileList, path);
    }

    /* synthetic */ AccumulatorPathVisitor(AccumulatorPathVisitor$Builder accumulatorPathVisitor$Builder, AccumulatorPathVisitor$1 accumulatorPathVisitor$1) {
        this(accumulatorPathVisitor$Builder);
    }
}

