/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.apache.commons.io.function.Uncheck;

public final class FilesUncheck {
    public static long copy(InputStream inputStream, Path path, CopyOption ... copyOptionArray) {
        return Uncheck.apply(Files::copy, inputStream, path, copyOptionArray);
    }

    public static long copy(Path path, OutputStream outputStream) {
        return Uncheck.apply(Files::copy, path, outputStream);
    }

    public static Path copy(Path path, Path path2, CopyOption ... copyOptionArray) {
        return Uncheck.apply(Files::copy, path, path2, copyOptionArray);
    }

    public static Path createDirectories(Path path, FileAttribute<?> ... fileAttributeArray) {
        return Uncheck.apply(Files::createDirectories, path, fileAttributeArray);
    }

    public static Path createDirectory(Path path, FileAttribute<?> ... fileAttributeArray) {
        return Uncheck.apply(Files::createDirectory, path, fileAttributeArray);
    }

    public static Path createFile(Path path, FileAttribute<?> ... fileAttributeArray) {
        return Uncheck.apply(Files::createFile, path, fileAttributeArray);
    }

    public static Path createLink(Path path, Path path2) {
        return Uncheck.apply(Files::createLink, path, path2);
    }

    public static Path createSymbolicLink(Path path, Path path2, FileAttribute<?> ... fileAttributeArray) {
        return Uncheck.apply(Files::createSymbolicLink, path, path2, fileAttributeArray);
    }

    public static Path createTempDirectory(Path path, String string, FileAttribute<?> ... fileAttributeArray) {
        return Uncheck.apply(Files::createTempDirectory, path, string, fileAttributeArray);
    }

    public static Path createTempDirectory(String string, FileAttribute<?> ... fileAttributeArray) {
        return Uncheck.apply(Files::createTempDirectory, string, fileAttributeArray);
    }

    public static Path createTempFile(Path path, String string, String string2, FileAttribute<?> ... fileAttributeArray) {
        return Uncheck.apply(Files::createTempFile, path, string, string2, fileAttributeArray);
    }

    public static Path createTempFile(String string, String string2, FileAttribute<?> ... fileAttributeArray) {
        return Uncheck.apply(Files::createTempFile, string, string2, fileAttributeArray);
    }

    public static void delete(Path path) {
        Uncheck.accept(Files::delete, path);
    }

    public static boolean deleteIfExists(Path path) {
        return Uncheck.apply(Files::deleteIfExists, path);
    }

    public static Stream<Path> find(Path path, int n2, BiPredicate<Path, BasicFileAttributes> biPredicate, FileVisitOption ... fileVisitOptionArray) {
        return Uncheck.apply(Files::find, path, n2, biPredicate, fileVisitOptionArray);
    }

    public static Object getAttribute(Path path, String string, LinkOption ... linkOptionArray) {
        return Uncheck.apply(Files::getAttribute, path, string, linkOptionArray);
    }

    public static FileStore getFileStore(Path path) {
        return Uncheck.apply(Files::getFileStore, path);
    }

    public static FileTime getLastModifiedTime(Path path, LinkOption ... linkOptionArray) {
        return Uncheck.apply(Files::getLastModifiedTime, path, linkOptionArray);
    }

    public static UserPrincipal getOwner(Path path, LinkOption ... linkOptionArray) {
        return Uncheck.apply(Files::getOwner, path, linkOptionArray);
    }

    public static Set<PosixFilePermission> getPosixFilePermissions(Path path, LinkOption ... linkOptionArray) {
        return Uncheck.apply(Files::getPosixFilePermissions, path, linkOptionArray);
    }

    public static boolean isHidden(Path path) {
        return Uncheck.apply(Files::isHidden, path);
    }

    public static boolean isSameFile(Path path, Path path2) {
        return Uncheck.apply(Files::isSameFile, path, path2);
    }

    public static Stream<String> lines(Path path) {
        return Uncheck.apply(Files::lines, path);
    }

    public static Stream<String> lines(Path path, Charset charset) {
        return Uncheck.apply(Files::lines, path, charset);
    }

    public static Stream<Path> list(Path path) {
        return Uncheck.apply(Files::list, path);
    }

    public static Path move(Path path, Path path2, CopyOption ... copyOptionArray) {
        return Uncheck.apply(Files::move, path, path2, copyOptionArray);
    }

    public static BufferedReader newBufferedReader(Path path) {
        return Uncheck.apply(Files::newBufferedReader, path);
    }

    public static BufferedReader newBufferedReader(Path path, Charset charset) {
        return Uncheck.apply(Files::newBufferedReader, path, charset);
    }

    public static BufferedWriter newBufferedWriter(Path path, Charset charset, OpenOption ... openOptionArray) {
        return Uncheck.apply(Files::newBufferedWriter, path, charset, openOptionArray);
    }

    public static BufferedWriter newBufferedWriter(Path path, OpenOption ... openOptionArray) {
        return Uncheck.apply(Files::newBufferedWriter, path, openOptionArray);
    }

    public static SeekableByteChannel newByteChannel(Path path, OpenOption ... openOptionArray) {
        return Uncheck.apply(Files::newByteChannel, path, openOptionArray);
    }

    public static SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) {
        return Uncheck.apply(Files::newByteChannel, path, set, fileAttributeArray);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path path) {
        return Uncheck.apply(Files::newDirectoryStream, path);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<? super Path> filter) {
        return Uncheck.apply(Files::newDirectoryStream, path, filter);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path path, String string) {
        return Uncheck.apply(Files::newDirectoryStream, path, string);
    }

    public static InputStream newInputStream(Path path, OpenOption ... openOptionArray) {
        return Uncheck.apply(Files::newInputStream, path, openOptionArray);
    }

    public static OutputStream newOutputStream(Path path, OpenOption ... openOptionArray) {
        return Uncheck.apply(Files::newOutputStream, path, openOptionArray);
    }

    public static String probeContentType(Path path) {
        return Uncheck.apply(Files::probeContentType, path);
    }

    public static byte[] readAllBytes(Path path) {
        return Uncheck.apply(Files::readAllBytes, path);
    }

    public static List<String> readAllLines(Path path) {
        return Uncheck.apply(Files::readAllLines, path);
    }

    public static List<String> readAllLines(Path path, Charset charset) {
        return Uncheck.apply(Files::readAllLines, path, charset);
    }

    public static <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> clazz, LinkOption ... linkOptionArray) {
        return (A)Uncheck.apply(Files::readAttributes, path, clazz, linkOptionArray);
    }

    public static Map<String, Object> readAttributes(Path path, String string, LinkOption ... linkOptionArray) {
        return Uncheck.apply(Files::readAttributes, path, string, linkOptionArray);
    }

    public static Path readSymbolicLink(Path path) {
        return Uncheck.apply(Files::readSymbolicLink, path);
    }

    public static Path setAttribute(Path path, String string, Object object, LinkOption ... linkOptionArray) {
        return Uncheck.apply(Files::setAttribute, path, string, object, linkOptionArray);
    }

    public static Path setLastModifiedTime(Path path, FileTime fileTime) {
        return Uncheck.apply(Files::setLastModifiedTime, path, fileTime);
    }

    public static Path setOwner(Path path, UserPrincipal userPrincipal) {
        return Uncheck.apply(Files::setOwner, path, userPrincipal);
    }

    public static Path setPosixFilePermissions(Path path, Set<PosixFilePermission> set) {
        return Uncheck.apply(Files::setPosixFilePermissions, path, set);
    }

    public static long size(Path path) {
        return Uncheck.apply(Files::size, path);
    }

    public static Stream<Path> walk(Path path, FileVisitOption ... fileVisitOptionArray) {
        return Uncheck.apply(Files::walk, path, fileVisitOptionArray);
    }

    public static Stream<Path> walk(Path path, int n2, FileVisitOption ... fileVisitOptionArray) {
        return Uncheck.apply(Files::walk, path, n2, fileVisitOptionArray);
    }

    public static Path walkFileTree(Path path, FileVisitor<? super Path> fileVisitor) {
        return Uncheck.apply(Files::walkFileTree, path, fileVisitor);
    }

    public static Path walkFileTree(Path path, Set<FileVisitOption> set, int n2, FileVisitor<? super Path> fileVisitor) {
        return Uncheck.apply(Files::walkFileTree, path, set, n2, fileVisitor);
    }

    public static Path write(Path path, byte[] byArray, OpenOption ... openOptionArray) {
        return Uncheck.apply(Files::write, path, byArray, openOptionArray);
    }

    public static Path write(Path path, Iterable<? extends CharSequence> iterable, Charset charset, OpenOption ... openOptionArray) {
        return Uncheck.apply(Files::write, path, iterable, charset, openOptionArray);
    }

    public static Path write(Path path, Iterable<? extends CharSequence> iterable, OpenOption ... openOptionArray) {
        return Uncheck.apply(Files::write, path, iterable, openOptionArray);
    }

    private FilesUncheck() {
    }
}

