/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file.attribute;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class FileTimes {
    private static final BigDecimal LONG_MIN_VALUE_BD = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal LONG_MAX_VALUE_BD = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final MathContext MATH_CONTEXT = new MathContext(0, RoundingMode.FLOOR);
    public static final FileTime EPOCH = FileTime.from(Instant.EPOCH);
    static final long UNIX_TO_NTFS_OFFSET = -116444736000000000L;
    private static final BigDecimal UNIX_TO_NTFS_OFFSET_BD = BigDecimal.valueOf(-116444736000000000L);
    private static final long HUNDRED_NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L) / 100L;
    private static final BigDecimal HUNDRED_NANOS_PER_SECOND_BD = BigDecimal.valueOf(HUNDRED_NANOS_PER_SECOND);
    static final long HUNDRED_NANOS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L) / 100L;
    static final BigDecimal HUNDRED_NANOS_PER_MILLISECOND_BD = BigDecimal.valueOf(HUNDRED_NANOS_PER_MILLISECOND);
    private static final long HUNDRED = 100L;
    private static final BigDecimal HUNDRED_BD = BigDecimal.valueOf(100L);

    public static FileTime fromUnixTime(long l2) {
        return FileTime.from(l2, TimeUnit.SECONDS);
    }

    public static boolean isUnixTime(FileTime fileTime) {
        return FileTimes.isUnixTime(FileTimes.toUnixTime(fileTime));
    }

    public static boolean isUnixTime(long l2) {
        return Integer.MIN_VALUE <= l2 && l2 <= Integer.MAX_VALUE;
    }

    public static FileTime minusMillis(FileTime fileTime, long l2) {
        return FileTime.from(fileTime.toInstant().minusMillis(l2));
    }

    public static FileTime minusNanos(FileTime fileTime, long l2) {
        return FileTime.from(fileTime.toInstant().minusNanos(l2));
    }

    public static FileTime minusSeconds(FileTime fileTime, long l2) {
        return FileTime.from(fileTime.toInstant().minusSeconds(l2));
    }

    public static FileTime now() {
        return FileTime.from(Instant.now());
    }

    static Date ntfsTimeToDate(BigDecimal bigDecimal) {
        return new Date(FileTimes.ntfsTimeToInstant(bigDecimal).toEpochMilli());
    }

    public static Date ntfsTimeToDate(long l2) {
        return FileTimes.ntfsTimeToDate(BigDecimal.valueOf(l2));
    }

    public static FileTime ntfsTimeToFileTime(long l2) {
        return FileTime.from(FileTimes.ntfsTimeToInstant(l2));
    }

    static Instant ntfsTimeToInstant(BigDecimal bigDecimalArray) {
        bigDecimalArray = bigDecimalArray.add(UNIX_TO_NTFS_OFFSET_BD);
        bigDecimalArray = bigDecimalArray.divideAndRemainder(HUNDRED_NANOS_PER_SECOND_BD, MATH_CONTEXT);
        return Instant.ofEpochSecond(bigDecimalArray[0].longValueExact(), bigDecimalArray[1].multiply(HUNDRED_BD).longValueExact());
    }

    static Instant ntfsTimeToInstant(long l2) {
        return FileTimes.ntfsTimeToInstant(BigDecimal.valueOf(l2));
    }

    public static FileTime plusMillis(FileTime fileTime, long l2) {
        return FileTime.from(fileTime.toInstant().plusMillis(l2));
    }

    public static FileTime plusNanos(FileTime fileTime, long l2) {
        return FileTime.from(fileTime.toInstant().plusNanos(l2));
    }

    public static FileTime plusSeconds(FileTime fileTime, long l2) {
        return FileTime.from(fileTime.toInstant().plusSeconds(l2));
    }

    public static void setLastModifiedTime(Path path) throws IOException {
        Files.setLastModifiedTime(path, FileTimes.now());
    }

    public static Date toDate(FileTime fileTime) {
        if (fileTime != null) {
            return new Date(fileTime.toMillis());
        }
        return null;
    }

    public static FileTime toFileTime(Date date) {
        if (date != null) {
            return FileTime.fromMillis(date.getTime());
        }
        return null;
    }

    public static long toNtfsTime(Date date) {
        return FileTimes.toNtfsTime(date.getTime());
    }

    public static long toNtfsTime(FileTime fileTime) {
        return FileTimes.toNtfsTime(fileTime.toInstant());
    }

    static long toNtfsTime(Instant comparable) {
        comparable = BigDecimal.valueOf(comparable.getEpochSecond()).multiply(HUNDRED_NANOS_PER_SECOND_BD).add(BigDecimal.valueOf(comparable.getNano() / 100));
        return ((BigDecimal)comparable).subtract(UNIX_TO_NTFS_OFFSET_BD).longValueExact();
    }

    public static long toNtfsTime(long l2) {
        BigDecimal bigDecimal = BigDecimal.valueOf(l2).multiply(HUNDRED_NANOS_PER_MILLISECOND_BD);
        if ((bigDecimal = bigDecimal.subtract(UNIX_TO_NTFS_OFFSET_BD)).compareTo(LONG_MAX_VALUE_BD) >= 0) {
            return Long.MAX_VALUE;
        }
        if (bigDecimal.compareTo(LONG_MIN_VALUE_BD) <= 0) {
            return Long.MIN_VALUE;
        }
        return bigDecimal.longValue();
    }

    public static long toUnixTime(FileTime fileTime) {
        if (fileTime != null) {
            return fileTime.to(TimeUnit.SECONDS);
        }
        return 0L;
    }

    private FileTimes() {
    }
}

