/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;

public class EmptyFileFilter
extends AbstractFileFilter
implements Serializable {
    public static final IOFileFilter EMPTY = new EmptyFileFilter();
    public static final IOFileFilter NOT_EMPTY = EMPTY.negate();
    private static final long serialVersionUID = 3631422087512832211L;

    protected EmptyFileFilter() {
    }

    @Override
    public boolean accept(File objectArray) {
        if (objectArray == null) {
            return true;
        }
        if (objectArray.isDirectory()) {
            return IOUtils.length(objectArray = objectArray.listFiles()) == 0;
        }
        return objectArray.length() == 0L;
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        if (path == null) {
            return this.toFileVisitResult(true);
        }
        EmptyFileFilter emptyFileFilter = this;
        return emptyFileFilter.get(() -> {
            if (Files.isDirectory(path, new LinkOption[0])) {
                path = Files.list(path);
                try {
                    FileVisitResult fileVisitResult = this.toFileVisitResult(!path.findFirst().isPresent());
                    return fileVisitResult;
                }
                finally {
                    if (path != null) {
                        path.close();
                    }
                }
            }
            return this.toFileVisitResult(Files.size(path) == 0L);
        });
    }
}

