/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.io.file.NoopPathVisitor;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.PathVisitor;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class PathVisitorFileFilter
extends AbstractFileFilter {
    private final PathVisitor pathVisitor;

    public PathVisitorFileFilter(PathVisitor pathVisitor) {
        this.pathVisitor = pathVisitor == null ? NoopPathVisitor.INSTANCE : pathVisitor;
    }

    @Override
    public boolean accept(File file) {
        try {
            Path path = file.toPath();
            return ((AbstractFileFilter)this).visitFile(path, file.exists() ? PathUtils.readBasicFileAttributes(path) : null) == FileVisitResult.CONTINUE;
        }
        catch (IOException iOException) {
            return this.handle(iOException) == FileVisitResult.CONTINUE;
        }
    }

    @Override
    public boolean accept(File comparable, String string) {
        try {
            Comparable<File> comparable2 = comparable = comparable.toPath().resolve(string);
            return this.accept((Path)comparable2, PathUtils.readBasicFileAttributes((Path)comparable2)) == FileVisitResult.CONTINUE;
        }
        catch (IOException iOException) {
            return this.handle(iOException) == FileVisitResult.CONTINUE;
        }
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        PathVisitorFileFilter pathVisitorFileFilter = this;
        return pathVisitorFileFilter.get(() -> {
            if (Files.isDirectory(path, new LinkOption[0])) {
                return this.pathVisitor.postVisitDirectory(path, null);
            }
            return ((AbstractFileFilter)this).visitFile(path, basicFileAttributes);
        });
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        return this.pathVisitor.visitFile(path, basicFileAttributes);
    }
}

