/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter$1;
import org.apache.commons.io.filefilter.WildcardFileFilter$Builder;

public class WildcardFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = -7426486598995782105L;
    private final String[] wildcards;
    private final IOCase ioCase;

    public static WildcardFileFilter$Builder builder() {
        return new WildcardFileFilter$Builder();
    }

    private static <T> T requireWildcards(T t2) {
        return Objects.requireNonNull(t2, "wildcards");
    }

    private WildcardFileFilter(WildcardFileFilter$Builder wildcardFileFilter$Builder) {
        this(WildcardFileFilter$Builder.access$200(wildcardFileFilter$Builder), WildcardFileFilter$Builder.access$300(wildcardFileFilter$Builder));
    }

    private WildcardFileFilter(IOCase iOCase, String ... stringArray) {
        this.wildcards = (String[])WildcardFileFilter.requireWildcards(stringArray).clone();
        this.ioCase = IOCase.value(iOCase, IOCase.SENSITIVE);
    }

    @Deprecated
    public WildcardFileFilter(List<String> list) {
        this(list, IOCase.SENSITIVE);
    }

    @Deprecated
    public WildcardFileFilter(List<String> list, IOCase iOCase) {
        this(iOCase, WildcardFileFilter.requireWildcards(list).toArray(EMPTY_STRING_ARRAY));
    }

    @Deprecated
    public WildcardFileFilter(String string) {
        this(IOCase.SENSITIVE, WildcardFileFilter.requireWildcards(string));
    }

    @Deprecated
    public WildcardFileFilter(String ... stringArray) {
        this(IOCase.SENSITIVE, stringArray);
    }

    @Deprecated
    public WildcardFileFilter(String string, IOCase iOCase) {
        this(iOCase, string);
    }

    @Deprecated
    public WildcardFileFilter(String[] stringArray, IOCase iOCase) {
        this(iOCase, stringArray);
    }

    @Override
    public boolean accept(File file) {
        return this.accept(file.getName());
    }

    @Override
    public boolean accept(File file, String string) {
        return this.accept(string);
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        WildcardFileFilter wildcardFileFilter = this;
        return wildcardFileFilter.toFileVisitResult(wildcardFileFilter.accept(PathUtils.getFileNameString(path)));
    }

    private boolean accept(String string) {
        return Stream.of(this.wildcards).anyMatch(string2 -> FilenameUtils.wildcardMatch(string, string2, this.ioCase));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        WildcardFileFilter wildcardFileFilter = this;
        wildcardFileFilter.append(wildcardFileFilter.wildcards, stringBuilder);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    /* synthetic */ WildcardFileFilter(WildcardFileFilter$Builder wildcardFileFilter$Builder, WildcardFileFilter$1 wildcardFileFilter$1) {
        this(wildcardFileFilter$Builder);
    }

    static /* synthetic */ Object access$100(Object object) {
        return WildcardFileFilter.requireWildcards(object);
    }
}

