/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.Closeable;
import java.io.IOException;
import java.util.stream.BaseStream;
import org.apache.commons.io.function.Erase;
import org.apache.commons.io.function.IOIterator;
import org.apache.commons.io.function.IOIteratorAdapter;
import org.apache.commons.io.function.IORunnable;
import org.apache.commons.io.function.IOSpliterator;
import org.apache.commons.io.function.IOSpliteratorAdapter;
import org.apache.commons.io.function.UncheckedIOBaseStream;

public interface IOBaseStream<T, S extends IOBaseStream<T, S, B>, B extends BaseStream<T, B>>
extends Closeable {
    default public BaseStream<T, B> asBaseStream() {
        return new UncheckedIOBaseStream(this);
    }

    @Override
    default public void close() {
        this.unwrap().close();
    }

    default public boolean isParallel() {
        return this.unwrap().isParallel();
    }

    default public IOIterator<T> iterator() {
        return IOIteratorAdapter.adapt(this.unwrap().iterator());
    }

    default public S onClose(IORunnable iORunnable) throws IOException {
        IOBaseStream iOBaseStream = this;
        return iOBaseStream.wrap(iOBaseStream.unwrap().onClose(() -> Erase.run(iORunnable)));
    }

    default public S parallel() {
        if (this.isParallel()) {
            return (S)this;
        }
        IOBaseStream iOBaseStream = this;
        return iOBaseStream.wrap(iOBaseStream.unwrap().parallel());
    }

    default public S sequential() {
        if (this.isParallel()) {
            IOBaseStream iOBaseStream = this;
            return iOBaseStream.wrap(iOBaseStream.unwrap().sequential());
        }
        return (S)this;
    }

    default public IOSpliterator<T> spliterator() {
        return IOSpliteratorAdapter.adapt(this.unwrap().spliterator());
    }

    default public S unordered() {
        IOBaseStream iOBaseStream = this;
        return iOBaseStream.wrap(iOBaseStream.unwrap().unordered());
    }

    public B unwrap();

    public S wrap(B var1);
}

