/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.IOIndexedException;
import org.apache.commons.io.function.IOStreams;
import org.apache.commons.io.function.Uncheck;

@FunctionalInterface
public interface IOConsumer<T> {
    public static final IOConsumer<?> NOOP_IO_CONSUMER = object -> {};

    public static <T> void forAll(IOConsumer<T> iOConsumer, Iterable<T> iterable) throws IOExceptionList {
        IOStreams.forAll(IOStreams.of(iterable), iOConsumer);
    }

    public static <T> void forAll(IOConsumer<T> iOConsumer, Stream<T> stream) throws IOExceptionList {
        IOStreams.forAll(stream, iOConsumer, IOIndexedException::new);
    }

    @SafeVarargs
    public static <T> void forAll(IOConsumer<T> iOConsumer, T ... TArray) throws IOExceptionList {
        IOStreams.forAll(IOStreams.of(TArray), iOConsumer);
    }

    public static <T> void forEach(Iterable<T> iterable, IOConsumer<T> iOConsumer) throws IOException {
        IOStreams.forEach(IOStreams.of(iterable), iOConsumer);
    }

    public static <T> void forEach(Stream<T> stream, IOConsumer<T> iOConsumer) throws IOException {
        IOStreams.forEach(stream, iOConsumer);
    }

    public static <T> void forEach(T[] TArray, IOConsumer<T> iOConsumer) throws IOException {
        IOStreams.forEach(IOStreams.of(TArray), iOConsumer);
    }

    public static <T> IOConsumer<T> noop() {
        return NOOP_IO_CONSUMER;
    }

    public void accept(T var1) throws IOException;

    default public IOConsumer<T> andThen(IOConsumer<? super T> iOConsumer) {
        Objects.requireNonNull(iOConsumer, "after");
        return object -> {
            this.accept(object);
            iOConsumer.accept(object);
        };
    }

    default public Consumer<T> asConsumer() {
        return object -> Uncheck.accept(this, object);
    }
}

