/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.io.function.IOIterator;

final class IOIteratorAdapter<E>
implements IOIterator<E> {
    private final Iterator<E> delegate;

    static <E> IOIteratorAdapter<E> adapt(Iterator<E> iterator) {
        return new IOIteratorAdapter<E>(iterator);
    }

    private IOIteratorAdapter(Iterator<E> iterator) {
        this.delegate = Objects.requireNonNull(iterator, "delegate");
    }

    @Override
    public final boolean hasNext() throws IOException {
        return this.delegate.hasNext();
    }

    @Override
    public final E next() throws IOException {
        return this.delegate.next();
    }

    @Override
    public final Iterator<E> unwrap() {
        return this.delegate;
    }
}

