/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Supplier;
import org.apache.commons.io.function.IOBiConsumer;
import org.apache.commons.io.function.IOBiFunction;
import org.apache.commons.io.function.IOBooleanSupplier;
import org.apache.commons.io.function.IOComparator;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOIntConsumer;
import org.apache.commons.io.function.IOIntSupplier;
import org.apache.commons.io.function.IOLongSupplier;
import org.apache.commons.io.function.IOPredicate;
import org.apache.commons.io.function.IOQuadFunction;
import org.apache.commons.io.function.IORunnable;
import org.apache.commons.io.function.IOSupplier;
import org.apache.commons.io.function.IOTriConsumer;
import org.apache.commons.io.function.IOTriFunction;

public final class Uncheck {
    public static <T, U> void accept(IOBiConsumer<T, U> object, T t2, U u2) {
        try {
            object.accept(t2, u2);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException);
        }
    }

    public static <T> void accept(IOConsumer<T> object, T t2) {
        try {
            object.accept(t2);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException);
        }
    }

    public static void accept(IOIntConsumer object, int n2) {
        try {
            object.accept(n2);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException);
        }
    }

    public static <T, U, V> void accept(IOTriConsumer<T, U, V> object, T t2, U u2, V v2) {
        try {
            object.accept(t2, u2, v2);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException);
        }
    }

    public static <T, U, R> R apply(IOBiFunction<T, U, R> object, T t2, U u2) {
        try {
            return object.apply(t2, u2);
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException);
        }
    }

    public static <T, R> R apply(IOFunction<T, R> object, T t2) {
        try {
            return object.apply(t2);
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException);
        }
    }

    public static <T, U, V, W, R> R apply(IOQuadFunction<T, U, V, W, R> object, T t2, U u2, V v2, W w2) {
        try {
            return object.apply(t2, u2, v2, w2);
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException);
        }
    }

    public static <T, U, V, R> R apply(IOTriFunction<T, U, V, R> object, T t2, U u2, V v2) {
        try {
            return object.apply(t2, u2, v2);
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException);
        }
    }

    public static <T> int compare(IOComparator<T> object, T t2, T t3) {
        try {
            return object.compare(t2, t3);
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException);
        }
    }

    public static <T> T get(IOSupplier<T> object) {
        try {
            return object.get();
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException);
        }
    }

    public static <T> T get(IOSupplier<T> object, Supplier<String> supplier) {
        try {
            return object.get();
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException, supplier);
        }
    }

    public static boolean getAsBoolean(IOBooleanSupplier object) {
        try {
            return object.getAsBoolean();
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException);
        }
    }

    public static int getAsInt(IOIntSupplier object) {
        try {
            return object.getAsInt();
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException);
        }
    }

    public static int getAsInt(IOIntSupplier object, Supplier<String> supplier) {
        try {
            return object.getAsInt();
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException, supplier);
        }
    }

    public static long getAsLong(IOLongSupplier object) {
        try {
            return object.getAsLong();
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException);
        }
    }

    public static long getAsLong(IOLongSupplier object, Supplier<String> supplier) {
        try {
            return object.getAsLong();
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException, supplier);
        }
    }

    public static void run(IORunnable object) {
        try {
            object.run();
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException);
        }
    }

    public static void run(IORunnable object, Supplier<String> supplier) {
        try {
            object.run();
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException, supplier);
        }
    }

    public static <T> boolean test(IOPredicate<T> object, T t2) {
        try {
            return object.test(t2);
        }
        catch (IOException iOException) {
            object = iOException;
            throw Uncheck.wrap(iOException);
        }
    }

    private static UncheckedIOException wrap(IOException iOException) {
        return new UncheckedIOException(iOException);
    }

    private static UncheckedIOException wrap(IOException iOException, Supplier<String> supplier) {
        return new UncheckedIOException(supplier.get(), iOException);
    }

    private Uncheck() {
    }
}

