/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.input.BufferedFileChannelInputStream$1;
import org.apache.commons.io.input.BufferedFileChannelInputStream$Builder;
import org.apache.commons.io.input.ByteBufferCleaner;
import org.apache.commons.io.input.Input;

public final class BufferedFileChannelInputStream
extends InputStream {
    private final ByteBuffer byteBuffer;
    private final FileChannel fileChannel;

    public static BufferedFileChannelInputStream$Builder builder() {
        return new BufferedFileChannelInputStream$Builder();
    }

    private BufferedFileChannelInputStream(BufferedFileChannelInputStream$Builder bufferedFileChannelInputStream$Builder) throws IOException {
        this.fileChannel = BufferedFileChannelInputStream$Builder.access$100(bufferedFileChannelInputStream$Builder) != null ? BufferedFileChannelInputStream$Builder.access$100(bufferedFileChannelInputStream$Builder) : FileChannel.open(bufferedFileChannelInputStream$Builder.getPath(), StandardOpenOption.READ);
        this.byteBuffer = ByteBuffer.allocateDirect(bufferedFileChannelInputStream$Builder.getBufferSize());
        this.byteBuffer.flip();
    }

    @Deprecated
    public BufferedFileChannelInputStream(File file) throws IOException {
        this(file, 8192);
    }

    @Deprecated
    public BufferedFileChannelInputStream(File file, int n2) throws IOException {
        this(file.toPath(), n2);
    }

    @Deprecated
    public BufferedFileChannelInputStream(Path path) throws IOException {
        this(path, 8192);
    }

    @Deprecated
    public BufferedFileChannelInputStream(Path path, int n2) throws IOException {
        this((BufferedFileChannelInputStream$Builder)((BufferedFileChannelInputStream$Builder)BufferedFileChannelInputStream.builder().setPath(path)).setBufferSize(n2));
    }

    @Override
    public final synchronized int available() throws IOException {
        if (!this.fileChannel.isOpen()) {
            return 0;
        }
        if (!this.refill()) {
            return 0;
        }
        return this.byteBuffer.remaining();
    }

    private void clean(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            this.cleanDirectBuffer(byteBuffer);
        }
    }

    private void cleanDirectBuffer(ByteBuffer byteBuffer) {
        if (ByteBufferCleaner.isSupported()) {
            ByteBufferCleaner.clean(byteBuffer);
        }
    }

    @Override
    public final synchronized void close() throws IOException {
        try {
            this.fileChannel.close();
            BufferedFileChannelInputStream bufferedFileChannelInputStream = this;
            bufferedFileChannelInputStream.clean(bufferedFileChannelInputStream.byteBuffer);
            return;
        }
        catch (Throwable throwable) {
            BufferedFileChannelInputStream bufferedFileChannelInputStream = this;
            bufferedFileChannelInputStream.clean(bufferedFileChannelInputStream.byteBuffer);
            throw throwable;
        }
    }

    @Override
    public final synchronized int read() throws IOException {
        if (!this.refill()) {
            return -1;
        }
        return this.byteBuffer.get() & 0xFF;
    }

    @Override
    public final synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.refill()) {
            return -1;
        }
        n3 = Math.min(n3, this.byteBuffer.remaining());
        this.byteBuffer.get(byArray, n2, n3);
        return n3;
    }

    private boolean refill() throws IOException {
        Input.checkOpen(this.fileChannel.isOpen());
        if (!this.byteBuffer.hasRemaining()) {
            this.byteBuffer.clear();
            int n2 = 0;
            while (n2 == 0) {
                n2 = this.fileChannel.read(this.byteBuffer);
            }
            this.byteBuffer.flip();
            return n2 >= 0;
        }
        return true;
    }

    @Override
    public final synchronized long skip(long l2) throws IOException {
        if (l2 <= 0L) {
            return 0L;
        }
        if ((long)this.byteBuffer.remaining() >= l2) {
            this.byteBuffer.position(this.byteBuffer.position() + (int)l2);
            return l2;
        }
        long l3 = this.byteBuffer.remaining();
        long l4 = l2 - l3;
        this.byteBuffer.position(0);
        this.byteBuffer.flip();
        return l3 + this.skipFromFileChannel(l4);
    }

    private long skipFromFileChannel(long l2) throws IOException {
        long l3 = this.fileChannel.position();
        long l4 = this.fileChannel.size();
        if (l2 > l4 - l3) {
            this.fileChannel.position(l4);
            return l4 - l3;
        }
        this.fileChannel.position(l3 + l2);
        return l2;
    }

    /* synthetic */ BufferedFileChannelInputStream(BufferedFileChannelInputStream$Builder bufferedFileChannelInputStream$Builder, BufferedFileChannelInputStream$1 bufferedFileChannelInputStream$1) throws IOException {
        this(bufferedFileChannelInputStream$Builder);
    }
}

