/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.nio.ByteBuffer;
import org.apache.commons.io.input.ByteBufferCleaner$Cleaner;
import org.apache.commons.io.input.ByteBufferCleaner$Java8Cleaner;
import org.apache.commons.io.input.ByteBufferCleaner$Java9Cleaner;

final class ByteBufferCleaner {
    private static final ByteBufferCleaner$Cleaner INSTANCE = ByteBufferCleaner.getCleaner();

    ByteBufferCleaner() {
    }

    static void clean(ByteBuffer byteBuffer) {
        try {
            INSTANCE.clean(byteBuffer);
            return;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to clean direct buffer.", exception);
        }
    }

    private static ByteBufferCleaner$Cleaner getCleaner() {
        try {
            return new ByteBufferCleaner$Java8Cleaner(null);
        }
        catch (Exception exception) {
            try {
                return new ByteBufferCleaner$Java9Cleaner(null);
            }
            catch (Exception exception2) {
                throw new IllegalStateException("Failed to initialize a Cleaner.", exception);
            }
        }
    }

    static boolean isSupported() {
        return INSTANCE != null;
    }
}

