/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AbstractInputStream;
import org.apache.commons.io.input.RandomAccessFileInputStream$1;
import org.apache.commons.io.input.RandomAccessFileInputStream$Builder;

public class RandomAccessFileInputStream
extends AbstractInputStream {
    private final boolean propagateClose;
    private final RandomAccessFile randomAccessFile;

    public static RandomAccessFileInputStream$Builder builder() {
        return new RandomAccessFileInputStream$Builder();
    }

    private RandomAccessFileInputStream(RandomAccessFileInputStream$Builder randomAccessFileInputStream$Builder) throws IOException {
        this(randomAccessFileInputStream$Builder.getRandomAccessFile(), RandomAccessFileInputStream$Builder.access$100(randomAccessFileInputStream$Builder));
    }

    @Deprecated
    public RandomAccessFileInputStream(RandomAccessFile randomAccessFile) {
        this(randomAccessFile, false);
    }

    @Deprecated
    public RandomAccessFileInputStream(RandomAccessFile randomAccessFile, boolean bl2) {
        this.randomAccessFile = Objects.requireNonNull(randomAccessFile, "file");
        this.propagateClose = bl2;
    }

    @Override
    public int available() throws IOException {
        return Math.toIntExact(Math.min(this.availableLong(), Integer.MAX_VALUE));
    }

    public long availableLong() throws IOException {
        if (this.isClosed()) {
            return 0L;
        }
        return this.randomAccessFile.length() - this.randomAccessFile.getFilePointer();
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.propagateClose) {
            this.randomAccessFile.close();
        }
    }

    public long copy(long l2, long l3, OutputStream outputStream) throws IOException {
        this.randomAccessFile.seek(l2);
        return IOUtils.copyLarge(this, outputStream, 0L, l3);
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.randomAccessFile;
    }

    public boolean isCloseOnClose() {
        return this.propagateClose;
    }

    @Override
    public int read() throws IOException {
        return this.randomAccessFile.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.randomAccessFile.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.randomAccessFile.read(byArray, n2, n3);
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3;
        if (l2 <= 0L) {
            return 0L;
        }
        long l4 = this.randomAccessFile.getFilePointer();
        if (l4 >= (l3 = this.randomAccessFile.length())) {
            return 0L;
        }
        long l5 = l4 + l2;
        long l6 = l5 > l3 ? l3 - 1L : l5;
        if (l6 > 0L) {
            this.randomAccessFile.seek(l6);
        }
        return this.randomAccessFile.getFilePointer() - l4;
    }

    /* synthetic */ RandomAccessFileInputStream(RandomAccessFileInputStream$Builder randomAccessFileInputStream$Builder, RandomAccessFileInputStream$1 randomAccessFileInputStream$1) throws IOException {
        this(randomAccessFileInputStream$Builder);
    }
}

