/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.input.ReadAheadInputStream$1;
import org.apache.commons.io.input.ReadAheadInputStream$Builder;

public class ReadAheadInputStream
extends FilterInputStream {
    private static final ThreadLocal<byte[]> BYTE_ARRAY_1 = ThreadLocal.withInitial(() -> new byte[1]);
    private final ReentrantLock stateChangeLock = new ReentrantLock();
    private ByteBuffer activeBuffer;
    private ByteBuffer readAheadBuffer;
    private boolean endOfStream;
    private boolean readInProgress;
    private boolean readAborted;
    private Throwable readException;
    private boolean isClosed;
    private boolean isUnderlyingInputStreamBeingClosed;
    private boolean isReading;
    private final AtomicBoolean isWaiting = new AtomicBoolean();
    private final ExecutorService executorService;
    private final boolean shutdownExecutorService;
    private final Condition asyncReadComplete = this.stateChangeLock.newCondition();

    public static ReadAheadInputStream$Builder builder() {
        return new ReadAheadInputStream$Builder();
    }

    private static Thread newDaemonThread(Runnable runnable) {
        runnable = new Thread(runnable, "commons-io-read-ahead");
        ((Thread)runnable).setDaemon(true);
        return runnable;
    }

    private static ExecutorService newExecutorService() {
        return Executors.newSingleThreadExecutor(ReadAheadInputStream::newDaemonThread);
    }

    private ReadAheadInputStream(ReadAheadInputStream$Builder readAheadInputStream$Builder) throws IOException {
        this(readAheadInputStream$Builder.getInputStream(), readAheadInputStream$Builder.getBufferSize(), ReadAheadInputStream$Builder.access$100(readAheadInputStream$Builder) != null ? ReadAheadInputStream$Builder.access$100(readAheadInputStream$Builder) : ReadAheadInputStream.newExecutorService(), ReadAheadInputStream$Builder.access$100(readAheadInputStream$Builder) == null);
    }

    @Deprecated
    public ReadAheadInputStream(InputStream inputStream, int n2) {
        this(inputStream, n2, ReadAheadInputStream.newExecutorService(), true);
    }

    @Deprecated
    public ReadAheadInputStream(InputStream inputStream, int n2, ExecutorService executorService) {
        this(inputStream, n2, executorService, false);
    }

    private ReadAheadInputStream(InputStream inputStream, int n2, ExecutorService executorService, boolean bl2) {
        super(Objects.requireNonNull(inputStream, "inputStream"));
        if (n2 <= 0) {
            throw new IllegalArgumentException("bufferSizeInBytes should be greater than 0, but the value is " + n2);
        }
        this.executorService = Objects.requireNonNull(executorService, "executorService");
        this.shutdownExecutorService = bl2;
        this.activeBuffer = ByteBuffer.allocate(n2);
        this.readAheadBuffer = ByteBuffer.allocate(n2);
        this.activeBuffer.flip();
        this.readAheadBuffer.flip();
    }

    @Override
    public int available() throws IOException {
        this.stateChangeLock.lock();
        try {
            int n2 = (int)Math.min(Integer.MAX_VALUE, (long)this.activeBuffer.remaining() + (long)this.readAheadBuffer.remaining());
            return n2;
        }
        finally {
            this.stateChangeLock.unlock();
        }
    }

    private void checkReadException() throws IOException {
        if (this.readAborted) {
            if (this.readException instanceof IOException) {
                throw (IOException)this.readException;
            }
            throw new IOException(this.readException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        boolean bl2 = false;
        this.stateChangeLock.lock();
        try {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            if (!this.isReading) {
                bl2 = true;
                this.isUnderlyingInputStreamBeingClosed = true;
            }
        }
        finally {
            this.stateChangeLock.unlock();
        }
        if (!this.shutdownExecutorService) return;
        try {
            this.executorService.shutdownNow();
            this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            if (!bl2) return;
        }
        catch (InterruptedException interruptedException) {
            try {
                InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
                interruptedIOException.initCause(interruptedException);
                throw interruptedIOException;
            }
            catch (Throwable throwable) {
                if (!bl2) throw throwable;
                super.close();
                throw throwable;
            }
        }
        super.close();
        return;
    }

    private void closeUnderlyingInputStreamIfNecessary() {
        boolean bl2 = false;
        this.stateChangeLock.lock();
        try {
            this.isReading = false;
            if (this.isClosed && !this.isUnderlyingInputStreamBeingClosed) {
                bl2 = true;
            }
        }
        finally {
            this.stateChangeLock.unlock();
        }
        if (bl2) {
            try {
                super.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    private boolean isEndOfStream() {
        return !this.activeBuffer.hasRemaining() && !this.readAheadBuffer.hasRemaining() && this.endOfStream;
    }

    @Override
    public int read() throws IOException {
        if (this.activeBuffer.hasRemaining()) {
            return this.activeBuffer.get() & 0xFF;
        }
        byte[] byArray = BYTE_ARRAY_1.get();
        byte[] byArray2 = byArray;
        byArray[0] = 0;
        if (this.read(byArray2, 0, 1) == -1) {
            return -1;
        }
        return byArray2[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        if (!this.activeBuffer.hasRemaining()) {
            this.stateChangeLock.lock();
            try {
                this.waitForAsyncReadComplete();
                if (!this.readAheadBuffer.hasRemaining()) {
                    this.readAsync();
                    this.waitForAsyncReadComplete();
                    if (this.isEndOfStream()) {
                        return -1;
                    }
                }
                this.swapBuffers();
                this.readAsync();
            }
            finally {
                this.stateChangeLock.unlock();
            }
        }
        n3 = Math.min(n3, this.activeBuffer.remaining());
        this.activeBuffer.get(byArray, n2, n3);
        return n3;
    }

    private void readAsync() throws IOException {
        byte[] byArray;
        this.stateChangeLock.lock();
        try {
            byArray = this.readAheadBuffer.array();
            if (this.endOfStream || this.readInProgress) {
                return;
            }
            this.checkReadException();
            this.readAheadBuffer.position(0);
            this.readAheadBuffer.flip();
            this.readInProgress = true;
        }
        finally {
            this.stateChangeLock.unlock();
        }
        this.executorService.execute(() -> {
            this.stateChangeLock.lock();
            try {
                if (this.isClosed) {
                    this.readInProgress = false;
                    return;
                }
                this.isReading = true;
            }
            finally {
                this.stateChangeLock.unlock();
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = byArray.length;
            Throwable throwable = null;
            while ((n2 = this.in.read(byArray, n3, n4)) > 0) {
                n3 += n2;
                if ((n4 -= n2) > 0 && !this.isWaiting.get()) continue;
            }
            this.stateChangeLock.lock();
            try {
                this.readAheadBuffer.limit(n3);
                if (n2 < 0) {
                    this.endOfStream = true;
                }
                this.readInProgress = false;
                this.signalAsyncReadComplete();
            }
            finally {
                this.stateChangeLock.unlock();
            }
            this.closeUnderlyingInputStreamIfNecessary();
            return;
            catch (Throwable throwable2) {
                try {
                    byArray = throwable2;
                    throwable = throwable2;
                    if (byArray instanceof Error) {
                        throw (Error)byArray;
                    }
                    this.stateChangeLock.lock();
                }
                catch (Throwable throwable3) {
                    this.stateChangeLock.lock();
                    try {
                        this.readAheadBuffer.limit(n3);
                        if (n2 < 0 || throwable instanceof EOFException) {
                            this.endOfStream = true;
                        } else if (throwable != null) {
                            this.readAborted = true;
                            this.readException = throwable;
                        }
                        this.readInProgress = false;
                        this.signalAsyncReadComplete();
                    }
                    finally {
                        this.stateChangeLock.unlock();
                    }
                    this.closeUnderlyingInputStreamIfNecessary();
                    throw throwable3;
                }
                try {
                    this.readAheadBuffer.limit(n3);
                    if (n2 < 0 || throwable instanceof EOFException) {
                        this.endOfStream = true;
                    } else {
                        this.readAborted = true;
                        this.readException = throwable;
                    }
                    this.readInProgress = false;
                    this.signalAsyncReadComplete();
                }
                finally {
                    this.stateChangeLock.unlock();
                }
                this.closeUnderlyingInputStreamIfNecessary();
                return;
            }
        });
    }

    private void signalAsyncReadComplete() {
        this.stateChangeLock.lock();
        try {
            this.asyncReadComplete.signalAll();
            return;
        }
        finally {
            this.stateChangeLock.unlock();
        }
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3;
        if (l2 <= 0L) {
            return 0L;
        }
        if (l2 <= (long)this.activeBuffer.remaining()) {
            this.activeBuffer.position((int)l2 + this.activeBuffer.position());
            return l2;
        }
        this.stateChangeLock.lock();
        try {
            l3 = this.skipInternal(l2);
        }
        finally {
            this.stateChangeLock.unlock();
        }
        return l3;
    }

    private long skipInternal(long l2) throws IOException {
        if (!this.stateChangeLock.isLocked()) {
            throw new IllegalStateException("Expected stateChangeLock to be locked");
        }
        this.waitForAsyncReadComplete();
        if (this.isEndOfStream()) {
            return 0L;
        }
        if ((long)this.available() >= l2) {
            int n2 = (int)l2;
            if ((n2 -= this.activeBuffer.remaining()) <= 0) {
                throw new IllegalStateException("Expected toSkip > 0, actual: " + n2);
            }
            this.activeBuffer.position(0);
            this.activeBuffer.flip();
            ByteBuffer byteBuffer = this.readAheadBuffer;
            byteBuffer.position(n2 + byteBuffer.position());
            this.swapBuffers();
            this.readAsync();
            return l2;
        }
        int n3 = this.available();
        long l3 = l2 - (long)n3;
        this.activeBuffer.position(0);
        this.activeBuffer.flip();
        this.readAheadBuffer.position(0);
        this.readAheadBuffer.flip();
        long l4 = this.in.skip(l3);
        this.readAsync();
        return (long)n3 + l4;
    }

    private void swapBuffers() {
        ByteBuffer byteBuffer = this.activeBuffer;
        this.activeBuffer = this.readAheadBuffer;
        this.readAheadBuffer = byteBuffer;
    }

    private void waitForAsyncReadComplete() throws IOException {
        this.stateChangeLock.lock();
        try {
            this.isWaiting.set(true);
            while (this.readInProgress) {
                this.asyncReadComplete.await();
            }
        }
        catch (InterruptedException interruptedException) {
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            interruptedIOException.initCause(interruptedException);
            throw interruptedIOException;
        }
        finally {
            try {
                this.isWaiting.set(false);
            }
            finally {
                this.stateChangeLock.unlock();
            }
        }
        this.checkReadException();
    }

    /* synthetic */ ReadAheadInputStream(ReadAheadInputStream$Builder readAheadInputStream$Builder, ReadAheadInputStream$1 readAheadInputStream$1) throws IOException {
        this(readAheadInputStream$Builder);
    }
}

