/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.apache.commons.io.input.ReversedLinesFileReader$1;

final class ReversedLinesFileReader$FilePart {
    private final long partNumber;
    private final byte[] data;
    private byte[] leftOver;
    private int currentLastBytePos;
    final /* synthetic */ ReversedLinesFileReader this$0;

    private ReversedLinesFileReader$FilePart(ReversedLinesFileReader reversedLinesFileReader, long l2, int n2, byte[] byArray) throws IOException {
        this.this$0 = reversedLinesFileReader;
        this.partNumber = l2;
        int n3 = n2 + (byArray != null ? byArray.length : 0);
        this.data = new byte[n3];
        long l3 = (l2 - 1L) * (long)ReversedLinesFileReader.access$200(reversedLinesFileReader);
        if (l2 > 0L) {
            ReversedLinesFileReader.access$300(reversedLinesFileReader).position(l3);
            int n4 = ReversedLinesFileReader.access$300(reversedLinesFileReader).read(ByteBuffer.wrap(this.data, 0, n2));
            if (n4 != n2) {
                throw new IllegalStateException("Count of requested bytes and actually read bytes don't match");
            }
        }
        if (byArray != null) {
            System.arraycopy(byArray, 0, this.data, n2, byArray.length);
        }
        this.currentLastBytePos = this.data.length - 1;
        this.leftOver = null;
    }

    private void createLeftOver() {
        int n2 = this.currentLastBytePos + 1;
        this.leftOver = (byte[])(n2 > 0 ? Arrays.copyOf(this.data, n2) : null);
        this.currentLastBytePos = -1;
    }

    private int getNewLineMatchByteCount(byte[] byArray, int n2) {
        for (byte[] byArray2 : ReversedLinesFileReader.access$400(this.this$0)) {
            boolean bl2 = true;
            for (int i2 = byArray2.length - 1; i2 >= 0; --i2) {
                int n3 = n2 + i2 - (byArray2.length - 1);
                bl2 &= n3 >= 0 && byArray[n3] == byArray2[i2];
            }
            if (!bl2) continue;
            return byArray2.length;
        }
        return 0;
    }

    private String readLine() {
        Object object = null;
        boolean bl2 = this.partNumber == 1L;
        int n2 = this.currentLastBytePos;
        while (n2 >= 0) {
            if (!bl2 && n2 < ReversedLinesFileReader.access$500(this.this$0)) {
                this.createLeftOver();
                break;
            }
            ReversedLinesFileReader$FilePart reversedLinesFileReader$FilePart = this;
            int n3 = reversedLinesFileReader$FilePart.getNewLineMatchByteCount(reversedLinesFileReader$FilePart.data, n2);
            if (n3 > 0) {
                int n4 = n2 + 1;
                int n5 = this.currentLastBytePos - n4 + 1;
                if (n5 < 0) {
                    throw new IllegalStateException("Unexpected negative line length=" + n5);
                }
                int n6 = n4;
                object = Arrays.copyOfRange(this.data, n6, n6 + n5);
                object = new String((byte[])object, ReversedLinesFileReader.access$600(this.this$0));
                this.currentLastBytePos = n2 - n3;
                break;
            }
            if ((n2 -= ReversedLinesFileReader.access$700(this.this$0)) >= 0) continue;
            this.createLeftOver();
            break;
        }
        if (bl2 && this.leftOver != null) {
            object = new String(this.leftOver, ReversedLinesFileReader.access$600(this.this$0));
            this.leftOver = null;
        }
        return object;
    }

    private ReversedLinesFileReader$FilePart rollOver() throws IOException {
        if (this.currentLastBytePos >= 0) {
            throw new IllegalStateException("Current currentLastCharPos unexpectedly positive... last readLine() should have returned something! currentLastCharPos=" + this.currentLastBytePos);
        }
        if (this.partNumber > 1L) {
            return new ReversedLinesFileReader$FilePart(this.this$0, this.partNumber - 1L, ReversedLinesFileReader.access$200(this.this$0), this.leftOver);
        }
        if (this.leftOver != null) {
            throw new IllegalStateException("Unexpected leftover of the last block: leftOverOfThisFilePart=" + new String(this.leftOver, ReversedLinesFileReader.access$600(this.this$0)));
        }
        return null;
    }

    /* synthetic */ ReversedLinesFileReader$FilePart(ReversedLinesFileReader reversedLinesFileReader, long l2, int n2, byte[] byArray, ReversedLinesFileReader$1 reversedLinesFileReader$1) throws IOException {
        this(reversedLinesFileReader, l2, n2, byArray);
    }

    static /* synthetic */ String access$900(ReversedLinesFileReader$FilePart reversedLinesFileReader$FilePart) {
        return reversedLinesFileReader$FilePart.readLine();
    }

    static /* synthetic */ ReversedLinesFileReader$FilePart access$1000(ReversedLinesFileReader$FilePart reversedLinesFileReader$FilePart) throws IOException {
        return reversedLinesFileReader$FilePart.rollOver();
    }
}

