/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileSystem;
import org.apache.commons.io.StandardLineSeparator;
import org.apache.commons.io.function.IOIterable;
import org.apache.commons.io.function.IOIterator;
import org.apache.commons.io.input.ReversedLinesFileReader$1;
import org.apache.commons.io.input.ReversedLinesFileReader$Builder;
import org.apache.commons.io.input.ReversedLinesFileReader$FilePart;

public class ReversedLinesFileReader
implements Closeable,
IOIterable<String> {
    private static final String EMPTY_STRING = "";
    private static final int DEFAULT_BLOCK_SIZE = FileSystem.getCurrent().getBlockSize();
    private final int blockSize;
    private final Charset charset;
    private final SeekableByteChannel channel;
    private final long totalByteLength;
    private final long totalBlockCount;
    private final byte[][] newLineSequences;
    private final int avoidNewlineSplitBufferSize;
    private final int byteDecrement;
    private ReversedLinesFileReader$FilePart currentFilePart;
    private boolean trailingNewlineOfFileSkipped;

    public static ReversedLinesFileReader$Builder builder() {
        return new ReversedLinesFileReader$Builder();
    }

    private ReversedLinesFileReader(ReversedLinesFileReader$Builder reversedLinesFileReader$Builder) throws IOException {
        this.blockSize = reversedLinesFileReader$Builder.getBufferSize();
        this.charset = Charsets.toCharset(reversedLinesFileReader$Builder.getCharset());
        CharsetEncoder charsetEncoder = this.charset.newEncoder();
        float f2 = charsetEncoder.maxBytesPerChar();
        if (f2 == 1.0f || this.charset == StandardCharsets.UTF_8) {
            this.byteDecrement = 1;
        } else if (this.charset == Charset.forName("Shift_JIS") || this.charset == Charset.forName("windows-31j") || this.charset == Charset.forName("x-windows-949") || this.charset == Charset.forName("gbk") || this.charset == Charset.forName("x-windows-950")) {
            this.byteDecrement = 1;
        } else if (this.charset == StandardCharsets.UTF_16BE || this.charset == StandardCharsets.UTF_16LE) {
            this.byteDecrement = 2;
        } else {
            if (this.charset == StandardCharsets.UTF_16) {
                throw new UnsupportedEncodingException("For UTF-16, you need to specify the byte order (use UTF-16BE or UTF-16LE)");
            }
            throw new UnsupportedEncodingException("Encoding " + this.charset + " is not supported yet (feel free to submit a patch)");
        }
        this.newLineSequences = new byte[][]{StandardLineSeparator.CRLF.getBytes(this.charset), StandardLineSeparator.LF.getBytes(this.charset), StandardLineSeparator.CR.getBytes(this.charset)};
        this.avoidNewlineSplitBufferSize = this.newLineSequences[0].length;
        this.channel = Files.newByteChannel(reversedLinesFileReader$Builder.getPath(), StandardOpenOption.READ);
        this.totalByteLength = this.channel.size();
        int n2 = (int)(this.totalByteLength % (long)this.blockSize);
        if (n2 > 0) {
            this.totalBlockCount = this.totalByteLength / (long)this.blockSize + 1L;
        } else {
            this.totalBlockCount = this.totalByteLength / (long)this.blockSize;
            if (this.totalByteLength > 0L) {
                n2 = this.blockSize;
            }
        }
        ReversedLinesFileReader reversedLinesFileReader = this;
        this.currentFilePart = new ReversedLinesFileReader$FilePart(reversedLinesFileReader, reversedLinesFileReader.totalBlockCount, n2, null, null);
    }

    @Deprecated
    public ReversedLinesFileReader(File file) throws IOException {
        this(file, DEFAULT_BLOCK_SIZE, Charset.defaultCharset());
    }

    @Deprecated
    public ReversedLinesFileReader(File file, Charset charset) throws IOException {
        this(file.toPath(), charset);
    }

    @Deprecated
    public ReversedLinesFileReader(File file, int n2, Charset charset) throws IOException {
        this(file.toPath(), n2, charset);
    }

    @Deprecated
    public ReversedLinesFileReader(File file, int n2, String string) throws IOException {
        this(file.toPath(), n2, string);
    }

    @Deprecated
    public ReversedLinesFileReader(Path path, Charset charset) throws IOException {
        this(path, DEFAULT_BLOCK_SIZE, charset);
    }

    @Deprecated
    public ReversedLinesFileReader(Path path, int n2, Charset charset) throws IOException {
        this((ReversedLinesFileReader$Builder)((ReversedLinesFileReader$Builder)((ReversedLinesFileReader$Builder)ReversedLinesFileReader.builder().setPath(path)).setBufferSize(n2)).setCharset(charset));
    }

    @Deprecated
    public ReversedLinesFileReader(Path path, int n2, String string) throws IOException {
        this(path, n2, Charsets.toCharset(string));
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public IOIterator<String> iterator() {
        return new ReversedLinesFileReader$1(this);
    }

    public String readLine() throws IOException {
        String string = ReversedLinesFileReader$FilePart.access$900(this.currentFilePart);
        while (string == null) {
            this.currentFilePart = ReversedLinesFileReader$FilePart.access$1000(this.currentFilePart);
            if (this.currentFilePart == null) break;
            string = ReversedLinesFileReader$FilePart.access$900(this.currentFilePart);
        }
        if (EMPTY_STRING.equals(string) && !this.trailingNewlineOfFileSkipped) {
            this.trailingNewlineOfFileSkipped = true;
            string = this.readLine();
        }
        return string;
    }

    public List<String> readLines(int n2) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException("lineCount < 0");
        }
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.readLine();
            if (string == null) {
                return arrayList;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public String toString(int n2) throws IOException {
        List<String> list = this.readLines(n2);
        Collections.reverse(list);
        if (list.isEmpty()) {
            return EMPTY_STRING;
        }
        return String.join((CharSequence)System.lineSeparator(), list) + System.lineSeparator();
    }

    @Override
    public Iterable<String> unwrap() {
        return null;
    }

    static /* synthetic */ int access$000() {
        return DEFAULT_BLOCK_SIZE;
    }

    /* synthetic */ ReversedLinesFileReader(ReversedLinesFileReader$Builder reversedLinesFileReader$Builder, ReversedLinesFileReader$1 reversedLinesFileReader$1) throws IOException {
        this(reversedLinesFileReader$Builder);
    }

    static /* synthetic */ int access$200(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.blockSize;
    }

    static /* synthetic */ SeekableByteChannel access$300(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.channel;
    }

    static /* synthetic */ byte[][] access$400(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.newLineSequences;
    }

    static /* synthetic */ int access$500(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.avoidNewlineSplitBufferSize;
    }

    static /* synthetic */ Charset access$600(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.charset;
    }

    static /* synthetic */ int access$700(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.byteDecrement;
    }
}

