/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.ThreadUtils;
import org.apache.commons.io.file.attribute.FileTimes;
import org.apache.commons.io.input.Tailer$1;
import org.apache.commons.io.input.Tailer$Builder;
import org.apache.commons.io.input.Tailer$RandomAccessResourceBridge;
import org.apache.commons.io.input.Tailer$Tailable;
import org.apache.commons.io.input.Tailer$TailablePath;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.io.input.TailerListenerAdapter;

public class Tailer
implements AutoCloseable,
Runnable {
    private static final boolean DEFAULT_IGNORE_TOUCH = false;
    private static final int DEFAULT_DELAY_MILLIS = 1000;
    private static final String RAF_READ_ONLY_MODE = "r";
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private final byte[] inbuf;
    private final Tailer$Tailable tailable;
    private final Charset charset;
    private final Duration delayDuration;
    private final boolean tailFromEnd;
    private final TailerListener listener;
    private final boolean reOpen;
    private volatile boolean run = true;
    private final boolean ignoreTouch;

    public static Tailer$Builder builder() {
        return new Tailer$Builder();
    }

    @Deprecated
    public static Tailer create(File file, Charset charset, TailerListener tailerListener, long l2, boolean bl2, boolean bl3, int n2) {
        return ((Tailer$Builder)((Tailer$Builder)((Tailer$Builder)Tailer.builder().setFile(file)).setTailerListener(tailerListener).setCharset(charset)).setDelayDuration(Duration.ofMillis(l2)).setTailFromEnd(bl2).setReOpen(bl3).setBufferSize(n2)).get();
    }

    @Deprecated
    public static Tailer create(File file, TailerListener tailerListener) {
        return ((Tailer$Builder)Tailer.builder().setFile(file)).setTailerListener(tailerListener).get();
    }

    @Deprecated
    public static Tailer create(File file, TailerListener tailerListener, long l2) {
        return ((Tailer$Builder)Tailer.builder().setFile(file)).setTailerListener(tailerListener).setDelayDuration(Duration.ofMillis(l2)).get();
    }

    @Deprecated
    public static Tailer create(File file, TailerListener tailerListener, long l2, boolean bl2) {
        return ((Tailer$Builder)Tailer.builder().setFile(file)).setTailerListener(tailerListener).setDelayDuration(Duration.ofMillis(l2)).setTailFromEnd(bl2).get();
    }

    @Deprecated
    public static Tailer create(File file, TailerListener tailerListener, long l2, boolean bl2, boolean bl3) {
        return ((Tailer$Builder)Tailer.builder().setFile(file)).setTailerListener(tailerListener).setDelayDuration(Duration.ofMillis(l2)).setTailFromEnd(bl2).setReOpen(bl3).get();
    }

    @Deprecated
    public static Tailer create(File file, TailerListener tailerListener, long l2, boolean bl2, boolean bl3, int n2) {
        return ((Tailer$Builder)((Tailer$Builder)Tailer.builder().setFile(file)).setTailerListener(tailerListener).setDelayDuration(Duration.ofMillis(l2)).setTailFromEnd(bl2).setReOpen(bl3).setBufferSize(n2)).get();
    }

    @Deprecated
    public static Tailer create(File file, TailerListener tailerListener, long l2, boolean bl2, int n2) {
        return ((Tailer$Builder)((Tailer$Builder)Tailer.builder().setFile(file)).setTailerListener(tailerListener).setDelayDuration(Duration.ofMillis(l2)).setTailFromEnd(bl2).setBufferSize(n2)).get();
    }

    private Tailer(Tailer$Builder tailer$Builder) {
        this.tailable = Objects.requireNonNull(Tailer$Builder.access$300(tailer$Builder), "tailable");
        this.listener = Objects.requireNonNull(Tailer$Builder.access$400(tailer$Builder), "listener");
        this.delayDuration = Tailer$Builder.access$500(tailer$Builder);
        this.tailFromEnd = Tailer$Builder.access$600(tailer$Builder);
        this.inbuf = IOUtils.byteArray(tailer$Builder.getBufferSize());
        this.listener.init(this);
        this.reOpen = Tailer$Builder.access$700(tailer$Builder);
        this.charset = tailer$Builder.getCharset();
        this.ignoreTouch = Tailer$Builder.access$800(tailer$Builder);
    }

    @Deprecated
    public Tailer(File file, Charset charset, TailerListener tailerListener, long l2, boolean bl2, boolean bl3, int n2) {
        this(new Tailer$TailablePath(file.toPath(), new LinkOption[0], null), charset, tailerListener, Duration.ofMillis(l2), bl2, bl3, n2, false);
    }

    @Deprecated
    public Tailer(File file, TailerListener tailerListener) {
        this(file, tailerListener, 1000L);
    }

    @Deprecated
    public Tailer(File file, TailerListener tailerListener, long l2) {
        this(file, tailerListener, l2, false);
    }

    @Deprecated
    public Tailer(File file, TailerListener tailerListener, long l2, boolean bl2) {
        this(file, tailerListener, l2, bl2, 8192);
    }

    @Deprecated
    public Tailer(File file, TailerListener tailerListener, long l2, boolean bl2, boolean bl3) {
        this(file, tailerListener, l2, bl2, bl3, 8192);
    }

    @Deprecated
    public Tailer(File file, TailerListener tailerListener, long l2, boolean bl2, boolean bl3, int n2) {
        this(file, DEFAULT_CHARSET, tailerListener, l2, bl2, bl3, n2);
    }

    @Deprecated
    public Tailer(File file, TailerListener tailerListener, long l2, boolean bl2, int n2) {
        this(file, tailerListener, l2, bl2, false, n2);
    }

    private Tailer(Tailer$Tailable tailer$Tailable, Charset charset, TailerListener tailerListener, Duration duration, boolean bl2, boolean bl3, int n2, boolean bl4) {
        this.tailable = Objects.requireNonNull(tailer$Tailable, "tailable");
        this.listener = Objects.requireNonNull(tailerListener, "listener");
        this.delayDuration = duration;
        this.tailFromEnd = bl2;
        this.inbuf = IOUtils.byteArray(n2);
        tailerListener.init(this);
        this.reOpen = bl3;
        this.charset = charset;
        this.ignoreTouch = bl4;
    }

    @Override
    public void close() {
        this.run = false;
    }

    @Deprecated
    public long getDelay() {
        return this.delayDuration.toMillis();
    }

    public Duration getDelayDuration() {
        return this.delayDuration;
    }

    public File getFile() {
        if (this.tailable instanceof Tailer$TailablePath) {
            return ((Tailer$TailablePath)this.tailable).getPath().toFile();
        }
        throw new IllegalStateException("Cannot extract java.io.File from " + this.tailable.getClass().getName());
    }

    protected boolean getRun() {
        return this.run;
    }

    public Tailer$Tailable getTailable() {
        return this.tailable;
    }

    private long readLines(Tailer$RandomAccessResourceBridge tailer$RandomAccessResourceBridge) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(64);){
            int n2;
            long l2;
            long l3 = l2 = tailer$RandomAccessResourceBridge.getPointer();
            boolean bl2 = false;
            while (this.getRun() && (n2 = tailer$RandomAccessResourceBridge.read(this.inbuf)) != -1) {
                block10: for (int i2 = 0; i2 < n2; ++i2) {
                    byte by2 = this.inbuf[i2];
                    switch (by2) {
                        case 10: {
                            bl2 = false;
                            this.listener.handle(new String(byteArrayOutputStream.toByteArray(), this.charset));
                            byteArrayOutputStream.reset();
                            l3 = l2 + (long)i2 + 1L;
                            continue block10;
                        }
                        case 13: {
                            if (bl2) {
                                byteArrayOutputStream.write(13);
                            }
                            bl2 = true;
                            continue block10;
                        }
                        default: {
                            if (bl2) {
                                bl2 = false;
                                this.listener.handle(new String(byteArrayOutputStream.toByteArray(), this.charset));
                                byteArrayOutputStream.reset();
                                l3 = l2 + (long)i2 + 1L;
                            }
                            byteArrayOutputStream.write(by2);
                        }
                    }
                }
                l2 = tailer$RandomAccessResourceBridge.getPointer();
            }
            tailer$RandomAccessResourceBridge.seek(l3);
            if (this.listener instanceof TailerListenerAdapter) {
                ((TailerListenerAdapter)this.listener).endOfFileReached();
            }
            long l4 = l3;
            return l4;
        }
    }

    @Override
    public void run() {
        Tailer$RandomAccessResourceBridge tailer$RandomAccessResourceBridge = null;
        try {
            FileTime fileTime = FileTimes.EPOCH;
            long l2 = 0L;
            while (this.getRun() && tailer$RandomAccessResourceBridge == null) {
                try {
                    tailer$RandomAccessResourceBridge = this.tailable.getRandomAccess(RAF_READ_ONLY_MODE);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.listener.fileNotFound();
                }
                if (tailer$RandomAccessResourceBridge == null) {
                    ThreadUtils.sleep(this.delayDuration);
                    continue;
                }
                l2 = this.tailFromEnd ? this.tailable.size() : 0L;
                fileTime = this.tailable.lastModifiedFileTime();
                tailer$RandomAccessResourceBridge.seek(l2);
            }
            while (this.getRun()) {
                block38: {
                    block37: {
                        boolean bl2;
                        block36: {
                            bl2 = this.tailable.isNewer(fileTime);
                            long l3 = this.tailable.size();
                            if (l3 < l2) {
                                this.listener.fileRotated();
                                try {
                                    Tailer$RandomAccessResourceBridge tailer$RandomAccessResourceBridge2 = tailer$RandomAccessResourceBridge;
                                    try {
                                        tailer$RandomAccessResourceBridge = this.tailable.getRandomAccess(RAF_READ_ONLY_MODE);
                                        try {
                                            this.readLines(tailer$RandomAccessResourceBridge2);
                                        }
                                        catch (IOException iOException) {
                                            this.listener.handle(iOException);
                                        }
                                        l2 = 0L;
                                    }
                                    finally {
                                        if (tailer$RandomAccessResourceBridge2 == null) continue;
                                        tailer$RandomAccessResourceBridge2.close();
                                    }
                                }
                                catch (FileNotFoundException fileNotFoundException) {
                                    this.listener.fileNotFound();
                                    ThreadUtils.sleep(this.delayDuration);
                                }
                                continue;
                            }
                            if (l3 <= l2) break block36;
                            l2 = this.readLines(tailer$RandomAccessResourceBridge);
                            break block37;
                        }
                        if (!bl2) break block38;
                        if (!this.ignoreTouch) {
                            tailer$RandomAccessResourceBridge.seek(0L);
                            l2 = this.readLines(tailer$RandomAccessResourceBridge);
                        }
                    }
                    fileTime = this.tailable.lastModifiedFileTime();
                }
                if (this.reOpen && tailer$RandomAccessResourceBridge != null) {
                    tailer$RandomAccessResourceBridge.close();
                }
                ThreadUtils.sleep(this.delayDuration);
                if (!this.getRun() || !this.reOpen) continue;
                tailer$RandomAccessResourceBridge = this.tailable.getRandomAccess(RAF_READ_ONLY_MODE);
                tailer$RandomAccessResourceBridge.seek(l2);
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            this.listener.handle(interruptedException);
            return;
        }
        catch (Exception exception) {
            this.listener.handle(exception);
            return;
        }
        finally {
            try {
                IOUtils.close(tailer$RandomAccessResourceBridge);
            }
            catch (IOException iOException) {
                this.listener.handle(iOException);
            }
            this.close();
        }
    }

    @Deprecated
    public void stop() {
        this.close();
    }

    /* synthetic */ Tailer(Tailer$Builder tailer$Builder, Tailer$1 tailer$1) {
        this(tailer$Builder);
    }
}

