/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import org.apache.commons.io.input.ProxyReader;

public class TeeReader
extends ProxyReader {
    private final Writer branch;
    private final boolean closeBranch;

    public TeeReader(Reader reader, Writer writer) {
        this(reader, writer, false);
    }

    public TeeReader(Reader reader, Writer writer, boolean bl2) {
        super(reader);
        this.branch = writer;
        this.closeBranch = bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        try {
            super.close();
            if (!this.closeBranch) return;
        }
        catch (Throwable throwable) {
            if (!this.closeBranch) throw throwable;
            this.branch.close();
            throw throwable;
        }
        this.branch.close();
    }

    @Override
    public int read() throws IOException {
        int n2 = super.read();
        if (n2 != -1) {
            this.branch.write(n2);
        }
        return n2;
    }

    @Override
    public int read(char[] cArray) throws IOException {
        int n2 = super.read(cArray);
        if (n2 != -1) {
            this.branch.write(cArray, 0, n2);
        }
        return n2;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        if ((n3 = super.read(cArray, n2, n3)) != -1) {
            this.branch.write(cArray, n2, n3);
        }
        return n3;
    }

    @Override
    public int read(CharBuffer charBuffer) throws IOException {
        int n2 = charBuffer.position();
        int n3 = super.read(charBuffer);
        if (n3 != -1) {
            int n4 = charBuffer.position();
            int n5 = charBuffer.limit();
            try {
                charBuffer.position(n2).limit(n4);
                this.branch.append(charBuffer);
            }
            finally {
                charBuffer.position(n4).limit(n5);
            }
        }
        return n3;
    }
}

