/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.apache.commons.io.input.ProxyInputStream$AbstractBuilder;
import org.apache.commons.io.input.ThrottledInputStream;

public class ThrottledInputStream$Builder
extends ProxyInputStream$AbstractBuilder<ThrottledInputStream, ThrottledInputStream$Builder> {
    private double maxBytesPerSecond = Double.MAX_VALUE;

    @Override
    public ThrottledInputStream get() throws IOException {
        return new ThrottledInputStream(this, null);
    }

    double getMaxBytesPerSecond() {
        return this.maxBytesPerSecond;
    }

    public ThrottledInputStream$Builder setMaxBytes(long l2, ChronoUnit chronoUnit) {
        this.setMaxBytes(l2, chronoUnit.getDuration());
        return (ThrottledInputStream$Builder)this.asThis();
    }

    ThrottledInputStream$Builder setMaxBytes(long l2, Duration duration) {
        this.setMaxBytesPerSecond((double)Objects.requireNonNull(duration, "duration").toMillis() / 1000.0 * (double)l2);
        return (ThrottledInputStream$Builder)this.asThis();
    }

    private ThrottledInputStream$Builder setMaxBytesPerSecond(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Bandwidth " + d2 + " must be > 0.");
        }
        this.maxBytesPerSecond = d2;
        return (ThrottledInputStream$Builder)this.asThis();
    }

    public void setMaxBytesPerSecond(long l2) {
        this.setMaxBytesPerSecond((double)l2);
    }

    static /* synthetic */ double access$100(ThrottledInputStream$Builder throttledInputStream$Builder) {
        return throttledInputStream$Builder.maxBytesPerSecond;
    }
}

