/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream$1;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream$Builder;

public class UnsynchronizedByteArrayInputStream
extends InputStream {
    public static final int END_OF_STREAM = -1;
    private final byte[] data;
    private final int eod;
    private int offset;
    private int markedOffset;

    public static UnsynchronizedByteArrayInputStream$Builder builder() {
        return new UnsynchronizedByteArrayInputStream$Builder();
    }

    private static int minPosLen(byte[] byArray, int n2) {
        UnsynchronizedByteArrayInputStream.requireNonNegative(n2, "defaultValue");
        return Math.min(n2, byArray.length > 0 ? byArray.length : n2);
    }

    private static int requireNonNegative(int n2, String string) {
        if (n2 < 0) {
            throw new IllegalArgumentException(string + " cannot be negative");
        }
        return n2;
    }

    private UnsynchronizedByteArrayInputStream(UnsynchronizedByteArrayInputStream$Builder unsynchronizedByteArrayInputStream$Builder) throws IOException {
        this(UnsynchronizedByteArrayInputStream$Builder.access$100(unsynchronizedByteArrayInputStream$Builder), UnsynchronizedByteArrayInputStream$Builder.access$200(unsynchronizedByteArrayInputStream$Builder), UnsynchronizedByteArrayInputStream$Builder.access$300(unsynchronizedByteArrayInputStream$Builder));
    }

    @Deprecated
    public UnsynchronizedByteArrayInputStream(byte[] byArray) {
        this(byArray, byArray.length, 0, 0);
    }

    @Deprecated
    public UnsynchronizedByteArrayInputStream(byte[] byArray, int n2) {
        this(byArray, byArray.length, Math.min(UnsynchronizedByteArrayInputStream.requireNonNegative(n2, "offset"), UnsynchronizedByteArrayInputStream.minPosLen(byArray, n2)), UnsynchronizedByteArrayInputStream.minPosLen(byArray, n2));
    }

    @Deprecated
    public UnsynchronizedByteArrayInputStream(byte[] byArray, int n2, int n3) {
        UnsynchronizedByteArrayInputStream.requireNonNegative(n2, "offset");
        UnsynchronizedByteArrayInputStream.requireNonNegative(n3, "length");
        this.data = Objects.requireNonNull(byArray, "data");
        this.eod = Math.min(UnsynchronizedByteArrayInputStream.minPosLen(byArray, n2) + n3, byArray.length);
        this.offset = UnsynchronizedByteArrayInputStream.minPosLen(byArray, n2);
        this.markedOffset = UnsynchronizedByteArrayInputStream.minPosLen(byArray, n2);
    }

    private UnsynchronizedByteArrayInputStream(byte[] byArray, int n2, int n3, int n4) {
        this.data = Objects.requireNonNull(byArray, "data");
        this.eod = n2;
        this.offset = n3;
        this.markedOffset = n4;
    }

    @Override
    public int available() {
        if (this.offset < this.eod) {
            return this.eod - this.offset;
        }
        return 0;
    }

    @Override
    public void mark(int n2) {
        this.markedOffset = this.offset;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        if (this.offset < this.eod) {
            return this.data[this.offset++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) {
        Objects.requireNonNull(byArray, "dest");
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        Objects.requireNonNull(byArray, "dest");
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.offset >= this.eod) {
            return -1;
        }
        int n4 = this.eod - this.offset;
        if (n3 < n4) {
            n4 = n3;
        }
        if (n4 <= 0) {
            return 0;
        }
        System.arraycopy(this.data, this.offset, byArray, n2, n4);
        this.offset += n4;
        return n4;
    }

    @Override
    public void reset() {
        this.offset = this.markedOffset;
    }

    @Override
    public long skip(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skipping backward is not supported");
        }
        long l3 = this.eod - this.offset;
        if (l2 < l3) {
            l3 = l2;
        }
        this.offset = Math.addExact(this.offset, Math.toIntExact(l2));
        return l3;
    }

    /* synthetic */ UnsynchronizedByteArrayInputStream(UnsynchronizedByteArrayInputStream$Builder unsynchronizedByteArrayInputStream$Builder, UnsynchronizedByteArrayInputStream$1 unsynchronizedByteArrayInputStream$1) throws IOException {
        this(unsynchronizedByteArrayInputStream$Builder);
    }
}

