/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Stream;
import org.apache.commons.io.ThreadUtils;
import org.apache.commons.io.monitor.FileAlterationObserver;

public final class FileAlterationMonitor
implements Runnable {
    private static final FileAlterationObserver[] EMPTY_ARRAY = new FileAlterationObserver[0];
    private final long intervalMillis;
    private final List<FileAlterationObserver> observers = new CopyOnWriteArrayList<FileAlterationObserver>();
    private Thread thread;
    private ThreadFactory threadFactory;
    private volatile boolean running;

    public FileAlterationMonitor() {
        this(10000L);
    }

    public FileAlterationMonitor(long l2) {
        this.intervalMillis = l2;
    }

    public FileAlterationMonitor(long l2, Collection<FileAlterationObserver> collection) {
        this(l2, ((Collection)Optional.ofNullable(collection).orElse(Collections.emptyList())).toArray(EMPTY_ARRAY));
    }

    public FileAlterationMonitor(long l2, FileAlterationObserver ... fileAlterationObserverArray) {
        this(l2);
        if (fileAlterationObserverArray != null) {
            Stream.of(fileAlterationObserverArray).forEach(this::addObserver);
        }
    }

    public final void addObserver(FileAlterationObserver fileAlterationObserver) {
        if (fileAlterationObserver != null) {
            this.observers.add(fileAlterationObserver);
        }
    }

    public final long getInterval() {
        return this.intervalMillis;
    }

    public final Iterable<FileAlterationObserver> getObservers() {
        return new ArrayList<FileAlterationObserver>(this.observers);
    }

    public final void removeObserver(FileAlterationObserver fileAlterationObserver) {
        if (fileAlterationObserver != null) {
            this.observers.removeIf(fileAlterationObserver::equals);
        }
    }

    @Override
    public final void run() {
        while (this.running) {
            this.observers.forEach(FileAlterationObserver::checkAndNotify);
            if (!this.running) break;
            try {
                ThreadUtils.sleep(Duration.ofMillis(this.intervalMillis));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public final synchronized void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public final synchronized void start() throws Exception {
        if (this.running) {
            throw new IllegalStateException("Monitor is already running");
        }
        for (FileAlterationObserver fileAlterationObserver : this.observers) {
            fileAlterationObserver.initialize();
        }
        this.running = true;
        this.thread = this.threadFactory != null ? this.threadFactory.newThread(this) : new Thread(this);
        this.thread.start();
    }

    public final synchronized void stop() throws Exception {
        FileAlterationMonitor fileAlterationMonitor = this;
        fileAlterationMonitor.stop(fileAlterationMonitor.intervalMillis);
    }

    public final synchronized void stop(long l2) throws Exception {
        if (!this.running) {
            throw new IllegalStateException("Monitor is not running");
        }
        this.running = false;
        try {
            this.thread.interrupt();
            this.thread.join(l2);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        for (FileAlterationObserver fileAlterationObserver : this.observers) {
            fileAlterationObserver.destroy();
        }
    }
}

