/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver$1;
import org.apache.commons.io.monitor.FileAlterationObserver$Builder;
import org.apache.commons.io.monitor.FileEntry;

public class FileAlterationObserver
implements Serializable {
    private static final long serialVersionUID = 1185122225658782848L;
    private final transient List<FileAlterationListener> listeners = new CopyOnWriteArrayList<FileAlterationListener>();
    private final FileEntry rootEntry;
    private final transient FileFilter fileFilter;
    private final Comparator<File> comparator;

    public static FileAlterationObserver$Builder builder() {
        return new FileAlterationObserver$Builder(null);
    }

    private static Comparator<File> toComparator(IOCase iOCase) {
        switch (IOCase.value(iOCase, IOCase.SYSTEM)) {
            case SYSTEM: {
                return NameFileComparator.NAME_SYSTEM_COMPARATOR;
            }
            case INSENSITIVE: {
                return NameFileComparator.NAME_INSENSITIVE_COMPARATOR;
            }
        }
        return NameFileComparator.NAME_COMPARATOR;
    }

    private FileAlterationObserver(FileAlterationObserver$Builder fileAlterationObserver$Builder) {
        this(FileAlterationObserver$Builder.access$200(fileAlterationObserver$Builder) != null ? FileAlterationObserver$Builder.access$200(fileAlterationObserver$Builder) : new FileEntry(FileAlterationObserver$Builder.access$300(fileAlterationObserver$Builder)), FileAlterationObserver$Builder.access$400(fileAlterationObserver$Builder), FileAlterationObserver.toComparator(FileAlterationObserver$Builder.access$500(fileAlterationObserver$Builder)));
    }

    @Deprecated
    public FileAlterationObserver(File file) {
        this(file, null);
    }

    @Deprecated
    public FileAlterationObserver(File file, FileFilter fileFilter) {
        this(file, fileFilter, null);
    }

    @Deprecated
    public FileAlterationObserver(File file, FileFilter fileFilter, IOCase iOCase) {
        this(new FileEntry(file), fileFilter, iOCase);
    }

    private FileAlterationObserver(FileEntry fileEntry, FileFilter fileFilter, Comparator<File> comparator) {
        Objects.requireNonNull(fileEntry, "rootEntry");
        Objects.requireNonNull(fileEntry.getFile(), "rootEntry.getFile()");
        this.rootEntry = fileEntry;
        this.fileFilter = fileFilter != null ? fileFilter : TrueFileFilter.INSTANCE;
        this.comparator = Objects.requireNonNull(comparator, "comparator");
    }

    protected FileAlterationObserver(FileEntry fileEntry, FileFilter fileFilter, IOCase iOCase) {
        this(fileEntry, fileFilter, FileAlterationObserver.toComparator(iOCase));
    }

    @Deprecated
    public FileAlterationObserver(String string) {
        this(new File(string));
    }

    @Deprecated
    public FileAlterationObserver(String string, FileFilter fileFilter) {
        this(new File(string), fileFilter);
    }

    @Deprecated
    public FileAlterationObserver(String string, FileFilter fileFilter, IOCase iOCase) {
        this(new File(string), fileFilter, iOCase);
    }

    public void addListener(FileAlterationListener fileAlterationListener) {
        if (fileAlterationListener != null) {
            this.listeners.add(fileAlterationListener);
        }
    }

    private void checkAndFire(FileEntry fileEntry, FileEntry[] fileEntryArray, File[] fileArray) {
        int n2 = 0;
        FileEntry[] fileEntryArray2 = fileArray.length > 0 ? new FileEntry[fileArray.length] : FileEntry.EMPTY_FILE_ENTRY_ARRAY;
        for (FileEntry fileEntry2 : fileEntryArray) {
            while (n2 < fileArray.length && this.comparator.compare(fileEntry2.getFile(), fileArray[n2]) > 0) {
                fileEntryArray2[n2] = this.createFileEntry(fileEntry, fileArray[n2]);
                this.fireOnCreate(fileEntryArray2[n2]);
                ++n2;
            }
            if (n2 < fileArray.length && this.comparator.compare(fileEntry2.getFile(), fileArray[n2]) == 0) {
                this.fireOnChange(fileEntry2, fileArray[n2]);
                FileEntry fileEntry3 = fileEntry2;
                this.checkAndFire(fileEntry3, fileEntry3.getChildren(), this.listFiles(fileArray[n2]));
                fileEntryArray2[n2] = fileEntry2;
                ++n2;
                continue;
            }
            FileEntry fileEntry4 = fileEntry2;
            this.checkAndFire(fileEntry4, fileEntry4.getChildren(), FileUtils.EMPTY_FILE_ARRAY);
            this.fireOnDelete(fileEntry2);
        }
        while (n2 < fileArray.length) {
            fileEntryArray2[n2] = this.createFileEntry(fileEntry, fileArray[n2]);
            this.fireOnCreate(fileEntryArray2[n2]);
            ++n2;
        }
        fileEntry.setChildren(fileEntryArray2);
    }

    public void checkAndNotify() {
        this.listeners.forEach(fileAlterationListener -> fileAlterationListener.onStart(this));
        File file = this.rootEntry.getFile();
        if (file.exists()) {
            FileAlterationObserver fileAlterationObserver = this;
            fileAlterationObserver.checkAndFire(fileAlterationObserver.rootEntry, this.rootEntry.getChildren(), this.listFiles(file));
        } else if (this.rootEntry.isExists()) {
            FileAlterationObserver fileAlterationObserver = this;
            fileAlterationObserver.checkAndFire(fileAlterationObserver.rootEntry, this.rootEntry.getChildren(), FileUtils.EMPTY_FILE_ARRAY);
        }
        this.listeners.forEach(fileAlterationListener -> fileAlterationListener.onStop(this));
    }

    private FileEntry createFileEntry(FileEntry fileEntry, File file) {
        fileEntry = fileEntry.newChildInstance(file);
        fileEntry.refresh(file);
        fileEntry.setChildren(this.listFileEntries(file, fileEntry));
        return fileEntry;
    }

    public void destroy() throws Exception {
    }

    private void fireOnChange(FileEntry fileEntry, File file) {
        if (fileEntry.refresh(file)) {
            this.listeners.forEach(fileAlterationListener -> {
                if (fileEntry.isDirectory()) {
                    fileAlterationListener.onDirectoryChange(file);
                    return;
                }
                fileAlterationListener.onFileChange(file);
            });
        }
    }

    private void fireOnCreate(FileEntry fileEntry) {
        this.listeners.forEach(fileAlterationListener -> {
            if (fileEntry.isDirectory()) {
                fileAlterationListener.onDirectoryCreate(fileEntry.getFile());
                return;
            }
            fileAlterationListener.onFileCreate(fileEntry.getFile());
        });
        Stream.of(fileEntry.getChildren()).forEach(this::fireOnCreate);
    }

    private void fireOnDelete(FileEntry fileEntry) {
        this.listeners.forEach(fileAlterationListener -> {
            if (fileEntry.isDirectory()) {
                fileAlterationListener.onDirectoryDelete(fileEntry.getFile());
                return;
            }
            fileAlterationListener.onFileDelete(fileEntry.getFile());
        });
    }

    Comparator<File> getComparator() {
        return this.comparator;
    }

    public File getDirectory() {
        return this.rootEntry.getFile();
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public Iterable<FileAlterationListener> getListeners() {
        return new ArrayList<FileAlterationListener>(this.listeners);
    }

    public void initialize() throws Exception {
        this.rootEntry.refresh(this.rootEntry.getFile());
        FileAlterationObserver fileAlterationObserver = this;
        this.rootEntry.setChildren(fileAlterationObserver.listFileEntries(fileAlterationObserver.rootEntry.getFile(), this.rootEntry));
    }

    private FileEntry[] listFileEntries(File file2, FileEntry fileEntry) {
        return (FileEntry[])Stream.of(this.listFiles(file2)).map(file -> this.createFileEntry(fileEntry, (File)file)).toArray(FileEntry[]::new);
    }

    private File[] listFiles(File file) {
        if (file.isDirectory()) {
            return this.sort(file.listFiles(this.fileFilter));
        }
        return FileUtils.EMPTY_FILE_ARRAY;
    }

    public void removeListener(FileAlterationListener fileAlterationListener) {
        if (fileAlterationListener != null) {
            this.listeners.removeIf((Predicate<FileAlterationListener>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lorg/apache/commons/io/monitor/FileAlterationListener;)Z)((FileAlterationListener)fileAlterationListener));
        }
    }

    private File[] sort(File[] fileArray) {
        if (fileArray == null) {
            return FileUtils.EMPTY_FILE_ARRAY;
        }
        if (fileArray.length > 1) {
            Arrays.sort(fileArray, this.comparator);
        }
        return fileArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("[file='");
        stringBuilder.append(this.getDirectory().getPath());
        stringBuilder.append('\'');
        stringBuilder.append(", ");
        stringBuilder.append(this.fileFilter.toString());
        stringBuilder.append(", listeners=");
        stringBuilder.append(this.listeners.size());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    /* synthetic */ FileAlterationObserver(FileAlterationObserver$Builder fileAlterationObserver$Builder, FileAlterationObserver$1 fileAlterationObserver$1) {
        this(fileAlterationObserver$Builder);
    }
}

