/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.output.AbstractByteArrayOutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.DeferredFileOutputStream$1;
import org.apache.commons.io.output.DeferredFileOutputStream$Builder;
import org.apache.commons.io.output.ThresholdingOutputStream;

public class DeferredFileOutputStream
extends ThresholdingOutputStream {
    private ByteArrayOutputStream memoryOutputStream;
    private OutputStream currentOutputStream;
    private Path outputPath;
    private final String prefix;
    private final String suffix;
    private final Path directory;
    private boolean closed;

    public static DeferredFileOutputStream$Builder builder() {
        return new DeferredFileOutputStream$Builder();
    }

    private static int checkBufferSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Initial buffer size must be at least 0.");
        }
        return n2;
    }

    private static Path toPath(File file, Supplier<Path> supplier) {
        if (file != null) {
            return file.toPath();
        }
        if (supplier == null) {
            return null;
        }
        return supplier.get();
    }

    private static Path toPath(Path path, Supplier<Path> supplier) {
        if (path != null) {
            return path;
        }
        if (supplier == null) {
            return null;
        }
        return supplier.get();
    }

    private DeferredFileOutputStream(DeferredFileOutputStream$Builder deferredFileOutputStream$Builder) {
        super(DeferredFileOutputStream$Builder.access$300(deferredFileOutputStream$Builder));
        this.outputPath = DeferredFileOutputStream.toPath(DeferredFileOutputStream$Builder.access$400(deferredFileOutputStream$Builder), null);
        this.prefix = DeferredFileOutputStream$Builder.access$500(deferredFileOutputStream$Builder);
        this.suffix = DeferredFileOutputStream$Builder.access$600(deferredFileOutputStream$Builder);
        this.directory = DeferredFileOutputStream.toPath(DeferredFileOutputStream$Builder.access$700(deferredFileOutputStream$Builder), PathUtils::getTempDirectory);
        this.memoryOutputStream = new ByteArrayOutputStream(DeferredFileOutputStream.checkBufferSize(deferredFileOutputStream$Builder.getBufferSize()));
        this.currentOutputStream = this.memoryOutputStream;
    }

    @Deprecated
    public DeferredFileOutputStream(int n2, File file) {
        this(n2, file, null, null, null, 1024);
    }

    private DeferredFileOutputStream(int n2, File file, String string, String string2, File file2, int n3) {
        super(n2);
        this.outputPath = DeferredFileOutputStream.toPath(file, null);
        this.prefix = string;
        this.suffix = string2;
        this.directory = DeferredFileOutputStream.toPath(file2, PathUtils::getTempDirectory);
        this.memoryOutputStream = new ByteArrayOutputStream(DeferredFileOutputStream.checkBufferSize(n3));
        this.currentOutputStream = this.memoryOutputStream;
    }

    @Deprecated
    public DeferredFileOutputStream(int n2, int n3, File file) {
        this(n2, file, null, null, null, n3);
    }

    @Deprecated
    public DeferredFileOutputStream(int n2, int n3, String string, String string2, File file) {
        this(n2, null, Objects.requireNonNull(string, "prefix"), string2, file, n3);
    }

    @Deprecated
    public DeferredFileOutputStream(int n2, String string, String string2, File file) {
        this(n2, null, Objects.requireNonNull(string, "prefix"), string2, file, 1024);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    public byte[] getData() {
        if (this.memoryOutputStream != null) {
            return ((AbstractByteArrayOutputStream)this.memoryOutputStream).toByteArray();
        }
        return null;
    }

    public File getFile() {
        if (this.outputPath != null) {
            return this.outputPath.toFile();
        }
        return null;
    }

    public Path getPath() {
        return this.outputPath;
    }

    @Override
    @Deprecated
    protected OutputStream getStream() throws IOException {
        return this.currentOutputStream;
    }

    public boolean isInMemory() {
        return !this.isThresholdExceeded();
    }

    @Override
    protected void thresholdReached() throws IOException {
        if (this.prefix != null) {
            this.outputPath = Files.createTempFile(this.directory, this.prefix, this.suffix, new FileAttribute[0]);
        }
        PathUtils.createParentDirectories(this.outputPath, null, PathUtils.EMPTY_FILE_ATTRIBUTE_ARRAY);
        OutputStream outputStream = Files.newOutputStream(this.outputPath, new OpenOption[0]);
        try {
            ((AbstractByteArrayOutputStream)this.memoryOutputStream).writeTo(outputStream);
        }
        catch (IOException iOException) {
            outputStream.close();
            throw iOException;
        }
        this.currentOutputStream = outputStream;
        this.memoryOutputStream = null;
    }

    public InputStream toInputStream() throws IOException {
        if (!this.closed) {
            throw new IOException("Stream not closed");
        }
        if (this.isInMemory()) {
            return ((AbstractByteArrayOutputStream)this.memoryOutputStream).toInputStream();
        }
        return Files.newInputStream(this.outputPath, new OpenOption[0]);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (!this.closed) {
            throw new IOException("Stream not closed");
        }
        if (this.isInMemory()) {
            ((AbstractByteArrayOutputStream)this.memoryOutputStream).writeTo(outputStream);
            return;
        }
        Files.copy(this.outputPath, outputStream);
    }

    /* synthetic */ DeferredFileOutputStream(DeferredFileOutputStream$Builder deferredFileOutputStream$Builder, DeferredFileOutputStream$1 deferredFileOutputStream$1) {
        this(deferredFileOutputStream$Builder);
    }

    static /* synthetic */ Path access$100(File file, Supplier supplier) {
        return DeferredFileOutputStream.toPath(file, (Supplier<Path>)supplier);
    }

    static /* synthetic */ Path access$200(Path path, Supplier supplier) {
        return DeferredFileOutputStream.toPath(path, (Supplier<Path>)supplier);
    }
}

