/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.function.IOConsumer;

public class FilterCollectionWriter
extends Writer {
    protected final Collection<Writer> EMPTY_WRITERS = Collections.emptyList();
    protected final Collection<Writer> writers;

    protected FilterCollectionWriter(Collection<Writer> collection) {
        this.writers = collection == null ? this.EMPTY_WRITERS : collection;
    }

    protected FilterCollectionWriter(Writer ... writerArray) {
        this.writers = writerArray == null ? this.EMPTY_WRITERS : Arrays.asList(writerArray);
    }

    @Override
    public Writer append(char c2) throws IOException {
        return this.forAllWriters(writer -> writer.append(c2));
    }

    @Override
    public Writer append(CharSequence charSequence) throws IOException {
        return this.forAllWriters(writer -> writer.append(charSequence));
    }

    @Override
    public Writer append(CharSequence charSequence, int n2, int n3) throws IOException {
        return this.forAllWriters(writer -> writer.append(charSequence, n2, n3));
    }

    @Override
    public void close() throws IOException {
        this.forAllWriters(Writer::close);
    }

    @Override
    public void flush() throws IOException {
        this.forAllWriters(Writer::flush);
    }

    private FilterCollectionWriter forAllWriters(IOConsumer<Writer> iOConsumer) throws IOExceptionList {
        IOConsumer.forAll(iOConsumer, this.writers());
        return this;
    }

    @Override
    public void write(char[] cArray) throws IOException {
        this.forAllWriters(writer -> writer.write(cArray));
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        this.forAllWriters(writer -> writer.write(cArray, n2, n3));
    }

    @Override
    public void write(int n2) throws IOException {
        this.forAllWriters(writer -> writer.write(n2));
    }

    @Override
    public void write(String string) throws IOException {
        this.forAllWriters(writer -> writer.write(string));
    }

    @Override
    public void write(String string, int n2, int n3) throws IOException {
        this.forAllWriters(writer -> writer.write(string, n2, n3));
    }

    private Stream<Writer> writers() {
        return this.writers.stream().filter(Objects::nonNull);
    }
}

