/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.CharRange;

public class CharSet
implements Serializable {
    private static final long serialVersionUID = 5947847346149275958L;
    public static final CharSet EMPTY = new CharSet(new String[]{null});
    public static final CharSet ASCII_ALPHA = new CharSet("a-zA-Z");
    public static final CharSet ASCII_ALPHA_LOWER = new CharSet("a-z");
    public static final CharSet ASCII_ALPHA_UPPER = new CharSet("A-Z");
    public static final CharSet ASCII_NUMERIC = new CharSet("0-9");
    protected static final Map<String, CharSet> COMMON = Collections.synchronizedMap(new HashMap());
    private final Set<CharRange> set = Collections.synchronizedSet(new HashSet());

    public static CharSet getInstance(String ... stringArray) {
        CharSet charSet;
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 1 && (charSet = COMMON.get(stringArray[0])) != null) {
            return charSet;
        }
        return new CharSet(stringArray);
    }

    protected CharSet(String ... stringArray) {
        Stream.of(stringArray).forEach(this::add);
    }

    protected void add(String string) {
        if (string == null) {
            return;
        }
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n2 - n3;
            if (n4 >= 4 && string.charAt(n3) == '^' && string.charAt(n3 + 2) == '-') {
                this.set.add(CharRange.isNotIn(string.charAt(n3 + 1), string.charAt(n3 + 3)));
                n3 += 4;
                continue;
            }
            if (n4 >= 3 && string.charAt(n3 + 1) == '-') {
                this.set.add(CharRange.isIn(string.charAt(n3), string.charAt(n3 + 2)));
                n3 += 3;
                continue;
            }
            if (n4 >= 2 && string.charAt(n3) == '^') {
                this.set.add(CharRange.isNot(string.charAt(n3 + 1)));
                n3 += 2;
                continue;
            }
            this.set.add(CharRange.is(string.charAt(n3)));
            ++n3;
        }
    }

    public boolean contains(char c2) {
        Set<CharRange> set = this.set;
        synchronized (set) {
            return this.set.stream().anyMatch(charRange -> charRange.contains(c2));
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CharSet)) {
            return false;
        }
        object = (CharSet)object;
        return this.set.equals(((CharSet)object).set);
    }

    CharRange[] getCharRanges() {
        return this.set.toArray(CharRange.EMPTY_ARRAY);
    }

    public int hashCode() {
        return 89 + this.set.hashCode();
    }

    public String toString() {
        return this.set.toString();
    }

    static {
        COMMON.put(null, EMPTY);
        COMMON.put("", EMPTY);
        COMMON.put("a-zA-Z", ASCII_ALPHA);
        COMMON.put("A-Za-z", ASCII_ALPHA);
        COMMON.put("a-z", ASCII_ALPHA_LOWER);
        COMMON.put("A-Z", ASCII_ALPHA_UPPER);
        COMMON.put("0-9", ASCII_NUMERIC);
    }
}

