/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Objects;

public class ClassPathUtils {
    public static String packageToPath(String string) {
        return Objects.requireNonNull(string, "path").replace('.', '/');
    }

    public static String pathToPackage(String string) {
        return Objects.requireNonNull(string, "path").replace('/', '.');
    }

    public static String toFullyQualifiedName(Class<?> clazz, String string) {
        Objects.requireNonNull(clazz, "context");
        Objects.requireNonNull(string, "resourceName");
        return ClassPathUtils.toFullyQualifiedName(clazz.getPackage(), string);
    }

    public static String toFullyQualifiedName(Package package_, String string) {
        Objects.requireNonNull(package_, "context");
        Objects.requireNonNull(string, "resourceName");
        return package_.getName() + "." + string;
    }

    public static String toFullyQualifiedPath(Class<?> clazz, String string) {
        Objects.requireNonNull(clazz, "context");
        Objects.requireNonNull(string, "resourceName");
        return ClassPathUtils.toFullyQualifiedPath(clazz.getPackage(), string);
    }

    public static String toFullyQualifiedPath(Package package_, String string) {
        Objects.requireNonNull(package_, "context");
        Objects.requireNonNull(string, "resourceName");
        return ClassPathUtils.packageToPath(package_.getName()) + "/" + string;
    }

    @Deprecated
    public ClassPathUtils() {
    }
}

