/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Random;
import java.util.function.Supplier;
import org.apache.commons.lang3.CachedRandomBits;
import org.apache.commons.lang3.RandomUtils;

public class RandomStringUtils {
    private static final Supplier<RandomUtils> SECURE_SUPPLIER = RandomUtils::secure;
    private static RandomStringUtils INSECURE = new RandomStringUtils(RandomUtils::insecure);
    private static RandomStringUtils SECURE = new RandomStringUtils(SECURE_SUPPLIER);
    private static RandomStringUtils SECURE_STRONG = new RandomStringUtils(RandomUtils::secureStrong);
    private static final char[] ALPHANUMERICAL_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final int ASCII_0 = 48;
    private static final int ASCII_9 = 57;
    private static final int ASCII_A = 65;
    private static final int ASCII_z = 122;
    private static final int CACHE_PADDING_BITS = 3;
    private static final int BITS_TO_BYTES_DIVISOR = 5;
    private static final int BASE_CACHE_SIZE_PADDING = 10;
    private final Supplier<RandomUtils> random;

    public static RandomStringUtils insecure() {
        return INSECURE;
    }

    @Deprecated
    public static String random(int n2) {
        return RandomStringUtils.secure().next(n2);
    }

    @Deprecated
    public static String random(int n2, boolean bl2, boolean bl3) {
        return RandomStringUtils.secure().next(n2, bl2, bl3);
    }

    @Deprecated
    public static String random(int n2, char ... cArray) {
        return RandomStringUtils.secure().next(n2, cArray);
    }

    @Deprecated
    public static String random(int n2, int n3, int n4, boolean bl2, boolean bl3) {
        return RandomStringUtils.secure().next(n2, n3, n4, bl2, bl3);
    }

    @Deprecated
    public static String random(int n2, int n3, int n4, boolean bl2, boolean bl3, char ... cArray) {
        return RandomStringUtils.secure().next(n2, n3, n4, bl2, bl3, cArray);
    }

    public static String random(int n2, int n3, int n4, boolean bl2, boolean bl3, char[] cArray, Random object) {
        block28: {
            while (true) {
                if (n2 == 0) {
                    return "";
                }
                if (n2 < 0) {
                    throw new IllegalArgumentException("Requested random string length " + n2 + " is less than 0.");
                }
                if (cArray != null && cArray.length == 0) {
                    throw new IllegalArgumentException("The chars array must not be empty");
                }
                if (n3 == 0 && n4 == 0) {
                    if (cArray != null) {
                        n4 = cArray.length;
                    } else if (!bl2 && !bl3) {
                        n4 = 0x10FFFF;
                    } else {
                        n4 = 123;
                        n3 = 32;
                    }
                } else {
                    if (n4 <= n3) {
                        throw new IllegalArgumentException("Parameter end (" + n4 + ") must be greater than start (" + n3 + ")");
                    }
                    if (n3 < 0 || n4 < 0) {
                        throw new IllegalArgumentException("Character positions MUST be >= 0");
                    }
                }
                if (n4 > 0x10FFFF) {
                    n4 = 0x10FFFF;
                }
                if (cArray != null || n4 > 127) break block28;
                if (!bl2 || !bl3 || n3 > 48 || n4 < 123) break;
                cArray = ALPHANUMERICAL_CHARS;
                bl3 = false;
                bl2 = false;
                n4 = 0;
                n3 = 0;
            }
            if (bl3 && n4 <= 48 || bl2 && n4 <= 65) {
                throw new IllegalArgumentException("Parameter end (" + n4 + ") must be greater then (48" + ") for generating digits or greater then (65" + ") for generating letters.");
            }
            if (bl2 && bl3) {
                n3 = Math.max(48, n3);
                n4 = Math.min(123, n4);
            } else if (bl3) {
                n3 = Math.max(48, n3);
                n4 = Math.min(58, n4);
            } else if (bl2) {
                n3 = Math.max(65, n3);
                n4 = Math.min(123, n4);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n5 = n4 - n3;
        n5 = 32 - Integer.numberOfLeadingZeros(n5);
        long l2 = ((long)n2 * (long)n5 + 3L) / 5L + 10L;
        int n6 = (int)Math.min(l2, 429496739L);
        object = new CachedRandomBits(n6, (Random)object);
        block4: while (n2-- != 0) {
            n6 = ((CachedRandomBits)object).nextBits(n5) + n3;
            if (n6 >= n4) {
                ++n2;
                continue;
            }
            if (cArray == null) {
                switch (Character.getType(n6)) {
                    case 0: 
                    case 18: 
                    case 19: {
                        ++n2;
                        continue block4;
                    }
                }
            } else {
                n6 = cArray[n6];
            }
            int n7 = Character.charCount(n6);
            if (n2 == 0 && n7 > 1) {
                ++n2;
                continue;
            }
            if (bl2 && Character.isLetter(n6) || bl3 && Character.isDigit(n6) || !bl2 && !bl3) {
                stringBuilder.appendCodePoint(n6);
                if (n7 != 2) continue;
                --n2;
                continue;
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static String random(int n2, String string) {
        return RandomStringUtils.secure().next(n2, string);
    }

    @Deprecated
    public static String randomAlphabetic(int n2) {
        return RandomStringUtils.secure().nextAlphabetic(n2);
    }

    @Deprecated
    public static String randomAlphabetic(int n2, int n3) {
        return RandomStringUtils.secure().nextAlphabetic(n2, n3);
    }

    @Deprecated
    public static String randomAlphanumeric(int n2) {
        return RandomStringUtils.secure().nextAlphanumeric(n2);
    }

    @Deprecated
    public static String randomAlphanumeric(int n2, int n3) {
        return RandomStringUtils.secure().nextAlphanumeric(n2, n3);
    }

    @Deprecated
    public static String randomAscii(int n2) {
        return RandomStringUtils.secure().nextAscii(n2);
    }

    @Deprecated
    public static String randomAscii(int n2, int n3) {
        return RandomStringUtils.secure().nextAscii(n2, n3);
    }

    @Deprecated
    public static String randomGraph(int n2) {
        return RandomStringUtils.secure().nextGraph(n2);
    }

    @Deprecated
    public static String randomGraph(int n2, int n3) {
        return RandomStringUtils.secure().nextGraph(n2, n3);
    }

    @Deprecated
    public static String randomNumeric(int n2) {
        return RandomStringUtils.secure().nextNumeric(n2);
    }

    @Deprecated
    public static String randomNumeric(int n2, int n3) {
        return RandomStringUtils.secure().nextNumeric(n2, n3);
    }

    @Deprecated
    public static String randomPrint(int n2) {
        return RandomStringUtils.secure().nextPrint(n2);
    }

    @Deprecated
    public static String randomPrint(int n2, int n3) {
        return RandomStringUtils.secure().nextPrint(n2, n3);
    }

    public static RandomStringUtils secure() {
        return SECURE;
    }

    public static RandomStringUtils secureStrong() {
        return SECURE_STRONG;
    }

    @Deprecated
    public RandomStringUtils() {
        this(SECURE_SUPPLIER);
    }

    private RandomStringUtils(Supplier<RandomUtils> supplier) {
        this.random = supplier;
    }

    public String next(int n2) {
        return this.next(n2, false, false);
    }

    public String next(int n2, boolean bl2, boolean bl3) {
        return this.next(n2, 0, 0, bl2, bl3);
    }

    public String next(int n2, char ... cArray) {
        if (cArray == null) {
            return RandomStringUtils.random(n2, 0, 0, false, false, null, this.random());
        }
        return RandomStringUtils.random(n2, 0, cArray.length, false, false, cArray, this.random());
    }

    public String next(int n2, int n3, int n4, boolean bl2, boolean bl3) {
        return RandomStringUtils.random(n2, n3, n4, bl2, bl3, null, this.random());
    }

    public String next(int n2, int n3, int n4, boolean bl2, boolean bl3, char ... cArray) {
        return RandomStringUtils.random(n2, n3, n4, bl2, bl3, cArray, this.random());
    }

    public String next(int n2, String string) {
        if (string == null) {
            return RandomStringUtils.random(n2, 0, 0, false, false, null, this.random());
        }
        return this.next(n2, string.toCharArray());
    }

    public String nextAlphabetic(int n2) {
        return this.next(n2, true, false);
    }

    public String nextAlphabetic(int n2, int n3) {
        RandomStringUtils randomStringUtils = this;
        return randomStringUtils.nextAlphabetic(randomStringUtils.randomUtils().randomInt(n2, n3));
    }

    public String nextAlphanumeric(int n2) {
        return this.next(n2, true, true);
    }

    public String nextAlphanumeric(int n2, int n3) {
        RandomStringUtils randomStringUtils = this;
        return randomStringUtils.nextAlphanumeric(randomStringUtils.randomUtils().randomInt(n2, n3));
    }

    public String nextAscii(int n2) {
        return this.next(n2, 32, 127, false, false);
    }

    public String nextAscii(int n2, int n3) {
        RandomStringUtils randomStringUtils = this;
        return randomStringUtils.nextAscii(randomStringUtils.randomUtils().randomInt(n2, n3));
    }

    public String nextGraph(int n2) {
        return this.next(n2, 33, 126, false, false);
    }

    public String nextGraph(int n2, int n3) {
        RandomStringUtils randomStringUtils = this;
        return randomStringUtils.nextGraph(randomStringUtils.randomUtils().randomInt(n2, n3));
    }

    public String nextNumeric(int n2) {
        return this.next(n2, false, true);
    }

    public String nextNumeric(int n2, int n3) {
        RandomStringUtils randomStringUtils = this;
        return randomStringUtils.nextNumeric(randomStringUtils.randomUtils().randomInt(n2, n3));
    }

    public String nextPrint(int n2) {
        return this.next(n2, 32, 126, false, false);
    }

    public String nextPrint(int n2, int n3) {
        RandomStringUtils randomStringUtils = this;
        return randomStringUtils.nextPrint(randomStringUtils.randomUtils().randomInt(n2, n3));
    }

    private Random random() {
        return this.randomUtils().random();
    }

    private RandomUtils randomUtils() {
        return this.random.get();
    }

    public String toString() {
        return "RandomStringUtils [random=" + this.random() + "]";
    }
}

