/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils$ClassLoaderAwareObjectInputStream;

public class SerializationUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T clone(T object) {
        if (object == null) {
            return null;
        }
        Object object2 = new ByteArrayInputStream(SerializationUtils.serialize((Serializable)object));
        object = ObjectUtils.getClass(object);
        try {
            object = new SerializationUtils$ClassLoaderAwareObjectInputStream((InputStream)object2, ((Class)object).getClassLoader());
            try {
                object2 = (Serializable)((ObjectInputStream)object).readObject();
                return (T)object2;
            }
            finally {
                ((ObjectInputStream)object).close();
            }
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new SerializationException(String.format("%s while reading cloned object data", exception.getClass().getSimpleName()), exception);
        }
    }

    public static <T> T deserialize(byte[] byArray) {
        Objects.requireNonNull(byArray, "objectData");
        return SerializationUtils.deserialize(new ByteArrayInputStream(byArray));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "inputStream");
        try {
            inputStream = new ObjectInputStream(inputStream);
            try {
                Object object;
                Object object2 = object = ((ObjectInputStream)inputStream).readObject();
                return (T)object2;
            }
            finally {
                ((ObjectInputStream)inputStream).close();
            }
        }
        catch (IOException | ClassNotFoundException | NegativeArraySizeException exception) {
            throw new SerializationException(exception);
        }
    }

    public static <T extends Serializable> T roundtrip(T t2) {
        return (T)((Serializable)SerializationUtils.deserialize(SerializationUtils.serialize(t2)));
    }

    public static byte[] serialize(Serializable serializable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        SerializationUtils.serialize(serializable, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void serialize(Serializable serializable, OutputStream outputStream) {
        Objects.requireNonNull(outputStream, "outputStream");
        try {
            outputStream = new ObjectOutputStream(outputStream);
            try {
                ((ObjectOutputStream)outputStream).writeObject(serializable);
            }
            finally {
                ((ObjectOutputStream)outputStream).close();
            }
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    @Deprecated
    public SerializationUtils() {
    }
}

